/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.peppol.servlet;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.peppol.security.PeppolTrustedCA;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.peppolid.factory.SimpleIdentifierFactory;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.peppol.servlet.Phase4PeppolReceiverConfiguration;
import com.helger.security.certificate.TrustedCAChecker;
import com.helger.smpclient.peppol.ISMPExtendedServiceMetadataProvider;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;

@NotThreadSafe
public final class Phase4PeppolDefaultReceiverConfiguration {
    public static final IIdentifierFactory DEFAULT_SBDH_IDENTIFIER_FACTORY = SimpleIdentifierFactory.INSTANCE;
    public static final boolean DEFAULT_RECEIVER_CHECK_ENABLED = true;
    public static final boolean DEFAULT_CHECK_SIGNING_CERTIFICATE_REVOCATION = true;
    public static final TrustedCAChecker DEFAULT_PEPPOL_AP_CA_CHECKER = PeppolTrustedCA.peppolAllAP();
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(Phase4PeppolDefaultReceiverConfiguration.class);
    private static boolean s_bReceiverCheckEnabled = true;
    private static ISMPExtendedServiceMetadataProvider s_aSMPClient;
    private static String s_sAS4EndpointURL;
    private static X509Certificate s_aAPCertificate;
    private static IIdentifierFactory s_aSBDHIdentifierFactory;
    private static boolean s_bPerformSBDHValueChecks;
    private static boolean s_bCheckSBDHForMandatoryCountryC1;
    private static boolean s_bCheckSigningCertificateRevocation;
    private static TrustedCAChecker s_aAPCAChecker;

    private Phase4PeppolDefaultReceiverConfiguration() {
    }

    public static boolean isReceiverCheckEnabled() {
        return s_bReceiverCheckEnabled;
    }

    public static void setReceiverCheckEnabled(boolean bl) {
        s_bReceiverCheckEnabled = bl;
    }

    @Nullable
    public static ISMPExtendedServiceMetadataProvider getSMPClient() {
        return s_aSMPClient;
    }

    public static void setSMPClient(@Nullable ISMPExtendedServiceMetadataProvider iSMPExtendedServiceMetadataProvider) {
        s_aSMPClient = iSMPExtendedServiceMetadataProvider;
    }

    @Nullable
    public static String getAS4EndpointURL() {
        return s_sAS4EndpointURL;
    }

    public static void setAS4EndpointURL(@Nullable String string) {
        s_sAS4EndpointURL = string;
    }

    @Nullable
    public static X509Certificate getAPCertificate() {
        return s_aAPCertificate;
    }

    public static void setAPCertificate(@Nullable X509Certificate x509Certificate) {
        s_aAPCertificate = x509Certificate;
    }

    @Nonnull
    public static IIdentifierFactory getSBDHIdentifierFactory() {
        return s_aSBDHIdentifierFactory;
    }

    public static void setSBDHIdentifierFactory(@Nonnull IIdentifierFactory iIdentifierFactory) {
        ValueEnforcer.notNull((Object)iIdentifierFactory, (String)"SBDHIdentifierFactory");
        s_aSBDHIdentifierFactory = iIdentifierFactory;
    }

    public static boolean isPerformSBDHValueChecks() {
        return s_bPerformSBDHValueChecks;
    }

    public static void setPerformSBDHValueChecks(boolean bl) {
        boolean bl2 = bl != s_bPerformSBDHValueChecks;
        s_bPerformSBDHValueChecks = bl;
        if (bl2) {
            LOGGER.info("phase4 Peppol SBDH value checks are now " + (bl ? "enabled" : "disabled"));
        }
    }

    public static boolean isCheckSBDHForMandatoryCountryC1() {
        return s_bCheckSBDHForMandatoryCountryC1;
    }

    public static void setCheckSBDHForMandatoryCountryC1(boolean bl) {
        boolean bl2 = bl != s_bCheckSBDHForMandatoryCountryC1;
        s_bCheckSBDHForMandatoryCountryC1 = bl;
        if (bl2) {
            LOGGER.info("phase4 Peppol SBDH checking for mandatory C1 Country Code is now " + (bl ? "enabled" : "disabled"));
        }
    }

    public static boolean isCheckSigningCertificateRevocation() {
        return s_bCheckSigningCertificateRevocation;
    }

    public static void setCheckSigningCertificateRevocation(boolean bl) {
        boolean bl2 = bl != s_bCheckSigningCertificateRevocation;
        s_bCheckSigningCertificateRevocation = bl;
        if (bl2) {
            LOGGER.info("phase4 Peppol signing certificate revocation check is now " + (bl ? "enabled" : "disabled"));
        }
    }

    @Nullable
    public static TrustedCAChecker getAPCAChecker() {
        return s_aAPCAChecker;
    }

    public static void setAPCAChecker(@Nullable TrustedCAChecker trustedCAChecker) {
        boolean bl = trustedCAChecker != s_aAPCAChecker;
        s_aAPCAChecker = trustedCAChecker;
        if (bl) {
            LOGGER.info("phase4 Peppol AP CA Checker is set to " + String.valueOf(trustedCAChecker));
        }
    }

    @Nonnull
    public static Phase4PeppolReceiverConfiguration.Phase4PeppolReceiverConfigurationBuilder getAsReceiverCheckDataBuilder() {
        ISMPExtendedServiceMetadataProvider iSMPExtendedServiceMetadataProvider = Phase4PeppolDefaultReceiverConfiguration.getSMPClient();
        String string = Phase4PeppolDefaultReceiverConfiguration.getAS4EndpointURL();
        X509Certificate x509Certificate = Phase4PeppolDefaultReceiverConfiguration.getAPCertificate();
        boolean bl = iSMPExtendedServiceMetadataProvider == null || StringHelper.isEmpty((String)string) || x509Certificate == null ? false : Phase4PeppolDefaultReceiverConfiguration.isReceiverCheckEnabled();
        return Phase4PeppolReceiverConfiguration.builder().receiverCheckEnabled(bl).serviceMetadataProvider(iSMPExtendedServiceMetadataProvider).as4EndpointUrl(string).apCertificate(x509Certificate).sbdhIdentifierFactory(Phase4PeppolDefaultReceiverConfiguration.getSBDHIdentifierFactory()).performSBDHValueChecks(Phase4PeppolDefaultReceiverConfiguration.isPerformSBDHValueChecks()).checkSBDHForMandatoryCountryC1(Phase4PeppolDefaultReceiverConfiguration.isCheckSBDHForMandatoryCountryC1()).checkSigningCertificateRevocation(Phase4PeppolDefaultReceiverConfiguration.isCheckSigningCertificateRevocation()).apCAChecker(Phase4PeppolDefaultReceiverConfiguration.getAPCAChecker());
    }

    @Nonnull
    public static Phase4PeppolReceiverConfiguration getAsReceiverCheckData() {
        return Phase4PeppolDefaultReceiverConfiguration.getAsReceiverCheckDataBuilder().build();
    }

    static {
        s_aSBDHIdentifierFactory = DEFAULT_SBDH_IDENTIFIER_FACTORY;
        s_bPerformSBDHValueChecks = true;
        s_bCheckSBDHForMandatoryCountryC1 = true;
        s_bCheckSigningCertificateRevocation = true;
        s_aAPCAChecker = DEFAULT_PEPPOL_AP_CA_CHECKER;
    }
}

