/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet;

import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.http.EHttpMethod;
import com.helger.http.EHttpVersion;
import com.helger.http.header.HttpHeaderMap;
import com.helger.mime.IMimeType;
import com.helger.phase4.attachment.IAS4IncomingAttachmentFactory;
import com.helger.phase4.crypto.AS4CryptoFactoryConfiguration;
import com.helger.phase4.incoming.AS4IncomingMessageMetadata;
import com.helger.phase4.incoming.AS4IncomingProfileSelectorConstant;
import com.helger.phase4.incoming.AS4IncomingReceiverConfiguration;
import com.helger.phase4.incoming.AS4RequestHandler;
import com.helger.phase4.incoming.IAS4ResponseAbstraction;
import com.helger.phase4.incoming.crypto.AS4IncomingSecurityConfiguration;
import com.helger.phase4.incoming.mgr.AS4ProfileSelector;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.messaging.http.AS4HttpDebug;
import com.helger.phase4.model.pmode.resolve.AS4DefaultPModeResolver;
import com.helger.phase4.servlet.AS4UnifiedResponse;
import com.helger.phase4.servlet.IAS4ServletRequestHandlerCustomizer;
import com.helger.phase4.util.Phase4Exception;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;

public class AS4XServletHandler
implements IXServletSimpleHandler {
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(AS4XServletHandler.class);
    private IAS4ServletRequestHandlerCustomizer m_aRequestHandlerCustomizer;

    @Nullable
    public final IAS4ServletRequestHandlerCustomizer getRequestHandlerCustomizer() {
        return this.m_aRequestHandlerCustomizer;
    }

    @Nonnull
    public final AS4XServletHandler setRequestHandlerCustomizer(@Nullable IAS4ServletRequestHandlerCustomizer iAS4ServletRequestHandlerCustomizer) {
        this.m_aRequestHandlerCustomizer = iAS4ServletRequestHandlerCustomizer;
        return this;
    }

    @Nonnull
    public AS4UnifiedResponse createUnifiedResponse(@Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull HttpServletRequest httpServletRequest, @Nonnull IRequestWebScope iRequestWebScope) {
        return new AS4UnifiedResponse(eHttpVersion, eHttpMethod, httpServletRequest);
    }

    @Nonnull
    @OverrideOnDemand
    protected AS4IncomingMessageMetadata createIncomingMessageMetadata(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        X509Certificate[] x509CertificateArray = null;
        try {
            x509CertificateArray = (X509Certificate[])iRequestWebScopeWithoutResponse.getRequest().getAttribute("jakarta.servlet.request.X509Certificate");
        }
        catch (Exception exception) {
            LOGGER.warn("No client TLS certificate provided: " + exception.getMessage());
        }
        return AS4IncomingMessageMetadata.createForRequest().setRemoteAddr(iRequestWebScopeWithoutResponse.getRemoteAddr()).setRemoteHost(iRequestWebScopeWithoutResponse.getRemoteHost()).setRemotePort(iRequestWebScopeWithoutResponse.getRemotePort()).setRemoteUser(iRequestWebScopeWithoutResponse.getRemoteUser()).setCookies(iRequestWebScopeWithoutResponse.getCookies()).setHttpHeaders(iRequestWebScopeWithoutResponse.headers()).setRemoteTlsCerts(x509CertificateArray);
    }

    @Nonnull
    public static IAS4ResponseAbstraction createResponseAbstraction(final @Nonnull AS4UnifiedResponse aS4UnifiedResponse) {
        return new IAS4ResponseAbstraction(){

            @Override
            public void setContent(@Nonnull byte[] byArray, @Nonnull Charset charset) {
                aS4UnifiedResponse.setContent(byArray);
                aS4UnifiedResponse.setCharset(charset);
            }

            @Override
            public void setContent(@Nonnull HttpHeaderMap httpHeaderMap, @Nonnull IHasInputStream iHasInputStream) {
                aS4UnifiedResponse.addCustomResponseHeaders(httpHeaderMap);
                aS4UnifiedResponse.setContent(iHasInputStream);
            }

            @Override
            public void setMimeType(@Nonnull IMimeType iMimeType) {
                aS4UnifiedResponse.setMimeType(iMimeType);
            }

            @Override
            public void setStatus(int n) {
                aS4UnifiedResponse.setStatus(n);
            }
        };
    }

    protected void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull AS4UnifiedResponse aS4UnifiedResponse, @Nullable IAS4ServletRequestHandlerCustomizer iAS4ServletRequestHandlerCustomizer) throws Exception {
        AS4IncomingMessageMetadata aS4IncomingMessageMetadata = this.createIncomingMessageMetadata(iRequestWebScopeWithoutResponse);
        try (AS4RequestHandler aS4RequestHandler = new AS4RequestHandler(aS4IncomingMessageMetadata);){
            String string = AS4ProfileSelector.getDefaultAS4ProfileID();
            AS4CryptoFactoryConfiguration aS4CryptoFactoryConfiguration = AS4CryptoFactoryConfiguration.getDefaultInstanceOrNull();
            if (aS4CryptoFactoryConfiguration != null) {
                aS4RequestHandler.setCryptoFactory(aS4CryptoFactoryConfiguration);
            }
            aS4RequestHandler.setPModeResolver(new AS4DefaultPModeResolver(string));
            aS4RequestHandler.setIncomingProfileSelector(new AS4IncomingProfileSelectorConstant(string, true));
            aS4RequestHandler.setIncomingAttachmentFactory(IAS4IncomingAttachmentFactory.DEFAULT_INSTANCE);
            aS4RequestHandler.setIncomingSecurityConfiguration(AS4IncomingSecurityConfiguration.createDefaultInstance());
            aS4RequestHandler.setIncomingReceiverConfiguration(new AS4IncomingReceiverConfiguration());
            if (iAS4ServletRequestHandlerCustomizer != null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Before customizeBeforeHandling");
                }
                iAS4ServletRequestHandlerCustomizer.customizeBeforeHandling(iRequestWebScopeWithoutResponse, aS4UnifiedResponse, aS4RequestHandler);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("After customizeBeforeHandling");
                }
            }
            AS4HttpDebug.debug(() -> "RECEIVE-START at " + iRequestWebScopeWithoutResponse.getFullContextAndServletPath());
            ServletInputStream servletInputStream = iRequestWebScopeWithoutResponse.getRequest().getInputStream();
            HttpHeaderMap httpHeaderMap = iRequestWebScopeWithoutResponse.headers().getClone();
            IAS4ResponseAbstraction iAS4ResponseAbstraction = AS4XServletHandler.createResponseAbstraction(aS4UnifiedResponse);
            aS4RequestHandler.handleRequest((InputStream)servletInputStream, httpHeaderMap, iAS4ResponseAbstraction);
            if (iAS4ServletRequestHandlerCustomizer != null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Before customizeAfterHandling");
                }
                iAS4ServletRequestHandlerCustomizer.customizeAfterHandling(iRequestWebScopeWithoutResponse, aS4UnifiedResponse, aS4RequestHandler);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("After customizeAfterHandling");
                }
            }
        }
        catch (Phase4Exception phase4Exception) {
            aS4UnifiedResponse.setResponseError(400, "Bad Request: " + phase4Exception.getMessage(), phase4Exception.getCause());
        }
        catch (Exception exception) {
            aS4UnifiedResponse.setResponseError(500, "Internal error processing AS4 request", exception);
        }
    }

    public final void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws Exception {
        AS4UnifiedResponse aS4UnifiedResponse = (AS4UnifiedResponse)unifiedResponse;
        this.handleRequest(iRequestWebScopeWithoutResponse, aS4UnifiedResponse, this.m_aRequestHandlerCustomizer);
    }
}

