/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.sender;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.collection.CollectionFind;
import com.helger.phase4.client.AS4ClientSentMessage;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.MessagePartNRInformation;
import com.helger.phase4.ebms3header.NonRepudiationInformation;
import com.helger.phase4.incoming.IAS4IncomingMessageMetadata;
import com.helger.phase4.incoming.IAS4IncomingMessageState;
import com.helger.phase4.incoming.IAS4SignalMessageConsumer;
import com.helger.phase4.sender.IAS4SignalMessageValidationResultHandler;
import com.helger.phase4.sender.LoggingAS4SignalMsgValidationResultHandler;
import com.helger.phase4.util.Phase4Exception;
import com.helger.xsds.xmldsig.ReferenceType;
import com.helger.xsds.xmldsig.TransformType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ValidatingAS4SignalMsgConsumer
implements IAS4SignalMessageConsumer {
    private static final IAS4SignalMessageValidationResultHandler DEFAULT_RES_HDL = new LoggingAS4SignalMsgValidationResultHandler();
    private final AS4ClientSentMessage<?> m_aClientSetMsg;
    private final IAS4SignalMessageConsumer m_aOriginalConsumer;
    private final IAS4SignalMessageValidationResultHandler m_aResultHandler;

    public ValidatingAS4SignalMsgConsumer(@Nonnull AS4ClientSentMessage<?> aS4ClientSentMessage, @Nullable IAS4SignalMessageConsumer iAS4SignalMessageConsumer, @Nullable IAS4SignalMessageValidationResultHandler iAS4SignalMessageValidationResultHandler) {
        ValueEnforcer.notNull(aS4ClientSentMessage, (String)"ClientSetMsg");
        this.m_aClientSetMsg = aS4ClientSentMessage;
        this.m_aOriginalConsumer = iAS4SignalMessageConsumer;
        this.m_aResultHandler = iAS4SignalMessageValidationResultHandler != null ? iAS4SignalMessageValidationResultHandler : DEFAULT_RES_HDL;
    }

    public static boolean areSemanticallyEquivalent(@Nonnull ReferenceType referenceType, @Nonnull ReferenceType referenceType2) {
        List list;
        if (!EqualsHelper.equals((Object)referenceType.getURI(), (Object)referenceType2.getURI())) {
            return false;
        }
        List list2 = referenceType.getTransforms() == null ? new ArrayList() : referenceType.getTransforms().getTransform();
        List list3 = list = referenceType2.getTransforms() == null ? new ArrayList() : referenceType2.getTransforms().getTransform();
        if (list2.size() != list.size()) {
            return false;
        }
        for (TransformType transformType : list2) {
            if (CollectionFind.containsAny(list, transformType2 -> EqualsHelper.equals((Object)transformType2.getAlgorithm(), (Object)transformType.getAlgorithm()))) continue;
            return false;
        }
        if (!EqualsHelper.equals((Object)referenceType.getDigestMethod().getAlgorithm(), (Object)referenceType2.getDigestMethod().getAlgorithm())) {
            return false;
        }
        return EqualsHelper.equals((Object)referenceType.getDigestValue(), (Object)referenceType2.getDigestValue());
    }

    @Override
    public void handleSignalMessage(@Nonnull Ebms3SignalMessage ebms3SignalMessage, @Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull IAS4IncomingMessageState iAS4IncomingMessageState) throws Phase4Exception {
        boolean bl = false;
        if (this.m_aClientSetMsg.getBuiltMessage().hasDSReferences() && ebms3SignalMessage != null && ebms3SignalMessage.getReceipt() != null && ebms3SignalMessage.getReceipt().hasAnyEntries()) {
            NonRepudiationInformation nonRepudiationInformation = null;
            List<Object> list = ebms3SignalMessage.getReceipt().getAny();
            for (Object object : list) {
                if (!(object instanceof NonRepudiationInformation)) continue;
                nonRepudiationInformation = (NonRepudiationInformation)object;
                break;
            }
            if (nonRepudiationInformation != null) {
                bl = true;
                Iterator<Object> iterator = this.m_aClientSetMsg.getBuiltMessage().getAllDSReferences();
                if (iterator.size() != nonRepudiationInformation.getMessagePartNRInformationCount()) {
                    this.m_aResultHandler.onError("The UserMessage sent out contains " + iterator.size() + " DSig references, wheres the received Receipt contains " + nonRepudiationInformation.getMessagePartNRInformationCount() + " DSig references. This will lead to follow-up errors.");
                }
                int n = 0;
                for (MessagePartNRInformation messagePartNRInformation : nonRepudiationInformation.getMessagePartNRInformation()) {
                    ReferenceType referenceType = messagePartNRInformation.getReference();
                    ReferenceType referenceType3 = (ReferenceType)iterator.findFirst(referenceType2 -> ValidatingAS4SignalMsgConsumer.areSemanticallyEquivalent(referenceType, referenceType2));
                    if (referenceType3 == null) {
                        this.m_aResultHandler.onError("The received DSig reference was not found in the source list: " + String.valueOf(referenceType));
                        continue;
                    }
                    ++n;
                }
                if (n != iterator.size()) {
                    this.m_aResultHandler.onError("No all sent DSig references were found in the received AS4 Receipt message");
                } else {
                    this.m_aResultHandler.onSuccess();
                }
            }
        }
        if (!bl) {
            this.m_aResultHandler.onNotApplicable();
        }
        if (this.m_aOriginalConsumer != null) {
            this.m_aOriginalConsumer.handleSignalMessage(ebms3SignalMessage, iAS4IncomingMessageMetadata, iAS4IncomingMessageState);
        }
    }
}

