/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.trait.IAddableByTrait;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.model.pmode.leg.PModeLegBusinessInformation;
import com.helger.phase4.model.pmode.leg.PModeLegBusinessInformationJsonConverter;
import com.helger.phase4.model.pmode.leg.PModeLegErrorHandling;
import com.helger.phase4.model.pmode.leg.PModeLegErrorHandlingJsonConverter;
import com.helger.phase4.model.pmode.leg.PModeLegProtocol;
import com.helger.phase4.model.pmode.leg.PModeLegProtocolJsonConverter;
import com.helger.phase4.model.pmode.leg.PModeLegReliability;
import com.helger.phase4.model.pmode.leg.PModeLegReliabilityJsonConverter;
import com.helger.phase4.model.pmode.leg.PModeLegSecurity;
import com.helger.phase4.model.pmode.leg.PModeLegSecurityJsonConverter;
import jakarta.annotation.Nonnull;

@Immutable
public final class PModeLegJsonConverter {
    private static final String PROTOCOL = "Protocol";
    private static final String BUSINESS_INFORMATION = "BusinessInfo";
    private static final String ERROR_HANDLING = "ErrorHandling";
    private static final String RELIABILITY = "Reliability";
    private static final String SECURITY = "Security";

    private PModeLegJsonConverter() {
    }

    @Nonnull
    public static IJsonObject convertToJson(@Nonnull PModeLeg pModeLeg) {
        JsonObject jsonObject = new JsonObject();
        if (pModeLeg.hasProtocol()) {
            jsonObject.add((Object)PROTOCOL, (IAddableByTrait)PModeLegProtocolJsonConverter.convertToJson(pModeLeg.getProtocol()));
        }
        if (pModeLeg.hasBusinessInfo()) {
            jsonObject.add((Object)BUSINESS_INFORMATION, (IAddableByTrait)PModeLegBusinessInformationJsonConverter.convertToJson(pModeLeg.getBusinessInfo()));
        }
        if (pModeLeg.hasErrorHandling()) {
            jsonObject.add((Object)ERROR_HANDLING, (IAddableByTrait)PModeLegErrorHandlingJsonConverter.convertToJson(pModeLeg.getErrorHandling()));
        }
        if (pModeLeg.hasReliability()) {
            jsonObject.add((Object)RELIABILITY, (IAddableByTrait)PModeLegReliabilityJsonConverter.convertToJson(pModeLeg.getReliability()));
        }
        if (pModeLeg.hasSecurity()) {
            jsonObject.add((Object)SECURITY, (IAddableByTrait)PModeLegSecurityJsonConverter.convertToJson(pModeLeg.getSecurity()));
        }
        return jsonObject;
    }

    @Nonnull
    public static PModeLeg convertToNative(@Nonnull IJsonObject iJsonObject) {
        IJsonObject iJsonObject2 = iJsonObject.getAsObject(PROTOCOL);
        PModeLegProtocol pModeLegProtocol = iJsonObject2 == null ? null : PModeLegProtocolJsonConverter.convertToNative(iJsonObject2);
        IJsonObject iJsonObject3 = iJsonObject.getAsObject(BUSINESS_INFORMATION);
        PModeLegBusinessInformation pModeLegBusinessInformation = iJsonObject3 == null ? null : PModeLegBusinessInformationJsonConverter.convertToNative(iJsonObject3);
        IJsonObject iJsonObject4 = iJsonObject.getAsObject(ERROR_HANDLING);
        PModeLegErrorHandling pModeLegErrorHandling = iJsonObject4 == null ? null : PModeLegErrorHandlingJsonConverter.convertToNative(iJsonObject4);
        IJsonObject iJsonObject5 = iJsonObject.getAsObject(RELIABILITY);
        PModeLegReliability pModeLegReliability = iJsonObject5 == null ? null : PModeLegReliabilityJsonConverter.convertToNative(iJsonObject5);
        IJsonObject iJsonObject6 = iJsonObject.getAsObject(SECURITY);
        PModeLegSecurity pModeLegSecurity = iJsonObject6 == null ? null : PModeLegSecurityJsonConverter.convertToNative(iJsonObject6);
        return new PModeLeg(pModeLegProtocol, pModeLegBusinessInformation, pModeLegErrorHandling, pModeLegReliability, pModeLegSecurity);
    }
}

