/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.logging;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.concurrent.Callable;

@ThreadSafe
public final class Phase4LogCustomizer {
    private static final ThreadLocal<String> TL_PREFIX = new ThreadLocal();
    private static final ThreadLocal<String> TL_SUFFIX = new ThreadLocal();

    @Deprecated(forRemoval=false)
    private Phase4LogCustomizer() {
    }

    @Nullable
    public static String getThreadLocalLogPrefix() {
        return TL_PREFIX.get();
    }

    public static void setThreadLocalLogPrefix(@Nullable String string) {
        TL_PREFIX.set(string);
    }

    @Nullable
    public static String getThreadLocalLogSuffix() {
        return TL_SUFFIX.get();
    }

    public static void setThreadLocalLogSuffix(@Nullable String string) {
        TL_SUFFIX.set(string);
    }

    public static void clearThreadLocals() {
        TL_PREFIX.remove();
        TL_SUFFIX.remove();
    }

    public static void runWithLogPrefixAndSuffix(@Nullable String string, @Nullable String string2, @Nonnull Runnable runnable) {
        ValueEnforcer.notNull((Object)runnable, (String)"Runnable");
        Phase4LogCustomizer.setThreadLocalLogPrefix(string);
        Phase4LogCustomizer.setThreadLocalLogSuffix(string2);
        try {
            runnable.run();
        }
        finally {
            Phase4LogCustomizer.clearThreadLocals();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T callWithLogPrefixAndSuffix(@Nullable String string, @Nullable String string2, @Nonnull Callable<T> callable) throws Exception {
        ValueEnforcer.notNull(callable, (String)"Callable");
        Phase4LogCustomizer.setThreadLocalLogPrefix(string);
        Phase4LogCustomizer.setThreadLocalLogSuffix(string2);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            Phase4LogCustomizer.clearThreadLocals();
        }
    }
}

