/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.incoming.soap;

import com.helger.base.charset.CharsetHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.state.ESuccess;
import com.helger.base.string.StringHelper;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.list.ErrorList;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.ebms3header.Ebms3CollaborationInfo;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3MessageInfo;
import com.helger.phase4.ebms3header.Ebms3Messaging;
import com.helger.phase4.ebms3header.Ebms3PartInfo;
import com.helger.phase4.ebms3header.Ebms3PartyId;
import com.helger.phase4.ebms3header.Ebms3PayloadInfo;
import com.helger.phase4.ebms3header.Ebms3Property;
import com.helger.phase4.ebms3header.Ebms3PullRequest;
import com.helger.phase4.ebms3header.Ebms3Receipt;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.incoming.AS4IncomingMessageState;
import com.helger.phase4.incoming.IAS4IncomingReceiverConfiguration;
import com.helger.phase4.incoming.mgr.AS4IncomingPullRequestProcessorManager;
import com.helger.phase4.incoming.soap.ISoapHeaderElementProcessor;
import com.helger.phase4.incoming.spi.IAS4IncomingPullRequestProcessorSPI;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.marshaller.Ebms3MessagingMarshaller;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.error.EEbmsError;
import com.helger.phase4.model.message.MessageHelperMethods;
import com.helger.phase4.model.mpc.IMPC;
import com.helger.phase4.model.mpc.IMPCManager;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.model.pmode.resolve.IAS4PModeResolver;
import com.helger.xml.XMLHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.ext.Attachment;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SoapHeaderElementProcessorExtractEbms3Messaging
implements ISoapHeaderElementProcessor {
    public static final QName QNAME_MESSAGING = new QName("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "Messaging");
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(SoapHeaderElementProcessorExtractEbms3Messaging.class);
    private final IAS4PModeResolver m_aPModeResolver;
    private final Consumer<? super IPMode> m_aPModeConsumer;
    private final IAS4IncomingReceiverConfiguration m_aIncomingReceiverConfiguration;

    public SoapHeaderElementProcessorExtractEbms3Messaging(@Nonnull IAS4PModeResolver iAS4PModeResolver, @Nullable Consumer<? super IPMode> consumer, @Nonnull IAS4IncomingReceiverConfiguration iAS4IncomingReceiverConfiguration) {
        ValueEnforcer.notNull((Object)iAS4PModeResolver, (String)"PModeResolver");
        this.m_aPModeResolver = iAS4PModeResolver;
        this.m_aPModeConsumer = consumer;
        this.m_aIncomingReceiverConfiguration = iAS4IncomingReceiverConfiguration;
    }

    private static boolean _isUseLeg1(@Nonnull Ebms3UserMessage ebms3UserMessage) {
        Ebms3MessageInfo ebms3MessageInfo = ebms3UserMessage.getMessageInfo();
        String string = ebms3MessageInfo.getMessageId();
        String string2 = ebms3MessageInfo.getRefToMessageId();
        if (StringHelper.isNotEmpty((String)string2) && string.equals(string2)) {
            LOGGER.warn("MessageID and ReferenceToMessageID are the same (" + string + ")!");
        }
        return StringHelper.isEmpty((String)string2) || string2.equals(string);
    }

    @Nullable
    private static String _getMPCIDOfUserMsg(@Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull PModeLeg pModeLeg) {
        String string = ebms3UserMessage.getMpc();
        if (string == null && pModeLeg.getBusinessInfo() != null) {
            string = pModeLeg.getBusinessInfo().getMPCID();
        }
        return string;
    }

    @Nonnull
    private static ESuccess _checkMPCOfPMode(@Nonnull PModeLeg pModeLeg, @Nonnull IMPCManager iMPCManager, @Nonnull Locale locale, @Nonnull ICommonsList<Ebms3Error> iCommonsList) {
        String string;
        if (pModeLeg.getBusinessInfo() != null && (string = pModeLeg.getBusinessInfo().getMPCID()) != null && !iMPCManager.containsWithID(string)) {
            String string2 = "Error processing the usermessage, PMode-MPC ID '" + string + "' is invalid!";
            LOGGER.error(string2);
            iCommonsList.add((Object)EEbmsError.EBMS_PROCESSING_MODE_MISMATCH.errorBuilder(locale).errorDetail(string2).build());
            return ESuccess.FAILURE;
        }
        return ESuccess.SUCCESS;
    }

    private static boolean _checkSoapBodyHasPayload(@Nonnull PModeLeg pModeLeg, @Nonnull Document document) {
        Element element = XMLHelper.getFirstChildElementOfName((Node)document.getFirstChild(), (String)pModeLeg.getProtocol().getSoapVersion().getBodyElementName());
        return element != null && element.hasChildNodes();
    }

    private void _notifyPModeResolved(@Nonnull IPMode iPMode) {
        if (this.m_aPModeConsumer != null) {
            this.m_aPModeConsumer.accept(iPMode);
        }
    }

    @Override
    @Nonnull
    public ESuccess processHeaderElement(@Nonnull Document document, @Nonnull Element element, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4IncomingMessageState aS4IncomingMessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList2) {
        IMPCManager iMPCManager = MetaAS4Manager.getMPCMgr();
        IPMode iPMode = null;
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        IMPC iMPC = null;
        String string = null;
        String string2 = null;
        Locale locale = aS4IncomingMessageState.getLocale();
        ErrorList errorList = new ErrorList();
        Ebms3Messaging ebms3Messaging = (Ebms3Messaging)new Ebms3MessagingMarshaller().setCollectErrors(errorList).read((Node)element);
        if (ebms3Messaging == null || errorList.containsAtLeastOneError()) {
            for (IError iError : errorList) {
                String string3 = "Header error: " + iError.getAsString(locale);
                LOGGER.error(string3);
                iCommonsList2.add((Object)EEbmsError.EBMS_INVALID_HEADER.errorBuilder(locale).errorDetail(string3, iError.getLinkedException()).build());
            }
            return ESuccess.FAILURE;
        }
        aS4IncomingMessageState.setMessaging(ebms3Messaging);
        int n = ebms3Messaging.getUserMessageCount();
        if (n > 1) {
            String string4 = "Too many UserMessage objects (" + n + ") contained.";
            LOGGER.error(string4);
            iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail(string4).build());
            return ESuccess.FAILURE;
        }
        int n2 = ebms3Messaging.getSignalMessageCount();
        if (n2 > 1) {
            String string5 = "Too many SignalMessage objects (" + n2 + ") contained.";
            LOGGER.error(string5);
            iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail(string5).build());
            return ESuccess.FAILURE;
        }
        if (n + n2 == 0) {
            LOGGER.error("Neither UserMessage nor SignalMessage object contained.");
            iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail("Neither UserMessage nor SignalMessage object contained.").build());
            return ESuccess.FAILURE;
        }
        Ebms3UserMessage ebms3UserMessage = (Ebms3UserMessage)CollectionHelper.getAtIndex(ebms3Messaging.getUserMessage(), (int)0);
        if (ebms3UserMessage != null) {
            String string6;
            Object object;
            Object object2;
            Object object3;
            Iterator<Ebms3PartInfo> iterator;
            List<Ebms3PartyId> list;
            Ebms3MessageInfo ebms3MessageInfo = ebms3UserMessage.getMessageInfo();
            if (ebms3MessageInfo != null) {
                aS4IncomingMessageState.setMessageID(ebms3MessageInfo.getMessageId());
                aS4IncomingMessageState.setRefToMessageID(ebms3MessageInfo.getRefToMessageId());
                aS4IncomingMessageState.setMessageTimestamp(ebms3MessageInfo.getTimestamp());
            }
            if ((list = ebms3UserMessage.getPartyInfo().getFrom().getPartyId()).size() > 1) {
                String string7 = "More than one PartyId (" + list.size() + ") is contained in From-Recipient please check the message.";
                LOGGER.error(string7);
                iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail(string7).build());
                return ESuccess.FAILURE;
            }
            List<Ebms3PartyId> list2 = ebms3UserMessage.getPartyInfo().getTo().getPartyId();
            if (list2.size() > 1) {
                String string8 = "More than one PartyId (" + list2.size() + ") is contained in To-Recipient please check the message.";
                LOGGER.error(string8);
                iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail(string8).build());
                return ESuccess.FAILURE;
            }
            string = list.get(0).getValue();
            string2 = list2.get(0).getValue();
            Ebms3CollaborationInfo ebms3CollaborationInfo = ebms3UserMessage.getCollaborationInfo();
            if (ebms3CollaborationInfo != null) {
                iterator = null;
                object3 = ebms3CollaborationInfo.getService().getValue();
                String string9 = ebms3CollaborationInfo.getAction();
                String string10 = null;
                if (ebms3CollaborationInfo.getAgreementRef() != null) {
                    iterator = ebms3CollaborationInfo.getAgreementRef().getPmode();
                    string10 = ebms3CollaborationInfo.getAgreementRef().getValue();
                }
                if ((iPMode = this.m_aPModeResolver.findPMode((String)((Object)iterator), (String)object3, string9, string, string2, string10, (String)(object2 = this.m_aIncomingReceiverConfiguration.getReceiverEndpointAddress()))) == null) {
                    String string11 = "Failed to resolve PMode for UserMessage '" + iterator + "' / '" + (String)object3 + "' / '" + string9 + "' / '" + string + "' / '" + string2 + "' / '" + string10 + "' / '" + (String)object2 + "' using resolver " + String.valueOf(this.m_aPModeResolver);
                    LOGGER.error(string11);
                    iCommonsList2.add((Object)EEbmsError.EBMS_PROCESSING_MODE_MISMATCH.errorBuilder(locale).errorDetail(string11).build());
                    return ESuccess.FAILURE;
                }
                this._notifyPModeResolved(iPMode);
            }
            iterator = null;
            object3 = null;
            boolean bl = false;
            if (iPMode != null) {
                int n3;
                boolean bl2;
                iterator = iPMode.getLeg1();
                object3 = iPMode.getLeg2();
                boolean bl3 = bl2 = iPMode.getMEPBinding().getRequiredLegs() == 2;
                if (bl2 && object3 == null) {
                    LOGGER.error("Error processing the UserMessage, PMode does not contain leg 2.");
                    iCommonsList2.add((Object)EEbmsError.EBMS_PROCESSING_MODE_MISMATCH.errorBuilder(locale).errorDetail("Error processing the UserMessage, PMode does not contain leg 2.").build());
                    return ESuccess.FAILURE;
                }
                boolean bl4 = SoapHeaderElementProcessorExtractEbms3Messaging._isUseLeg1(ebms3UserMessage);
                object = bl4 ? iterator : object3;
                int n4 = n3 = bl4 ? 1 : 2;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Using leg " + n3 + " for Conversation ID '" + ebms3UserMessage.getCollaborationInfo().getConversationId() + "'");
                }
                if (object == null) {
                    String string12 = "Error processing the UserMessage, PMode does not contain effective leg " + n3 + ".";
                    LOGGER.error(string12);
                    iCommonsList2.add((Object)EEbmsError.EBMS_PROCESSING_MODE_MISMATCH.errorBuilder(locale).errorDetail(string12).build());
                    return ESuccess.FAILURE;
                }
                aS4IncomingMessageState.setEffectivePModeLeg(n3, (PModeLeg)object);
                if (SoapHeaderElementProcessorExtractEbms3Messaging._checkMPCOfPMode(object, iMPCManager, locale, iCommonsList2).isFailure()) {
                    return ESuccess.FAILURE;
                }
                bl = SoapHeaderElementProcessorExtractEbms3Messaging._checkSoapBodyHasPayload((PModeLeg)object, document);
                string6 = SoapHeaderElementProcessorExtractEbms3Messaging._getMPCIDOfUserMsg(ebms3UserMessage, (PModeLeg)object);
                iMPC = iMPCManager.getMPCOrDefaultOfID(string6);
                if (iMPC == null) {
                    String string13 = "Error processing the UserMessage, effective MPC ID '" + string6 + "' is unknown!";
                    LOGGER.error(string13);
                    iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail(string13).build());
                    return ESuccess.FAILURE;
                }
            }
            aS4IncomingMessageState.setSoapBodyPayloadPresent(bl);
            Ebms3PayloadInfo ebms3PayloadInfo = ebms3UserMessage.getPayloadInfo();
            if (ebms3PayloadInfo == null || ebms3PayloadInfo.getPartInfo().isEmpty()) {
                if (bl) {
                    LOGGER.error("No PayloadInfo/PartInfo is specified, so no SOAP body payload is allowed.");
                    iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail("No PayloadInfo/PartInfo is specified, so no SOAP body payload is allowed.").build());
                    return ESuccess.FAILURE;
                }
                if (iCommonsList.isNotEmpty()) {
                    LOGGER.error("No PayloadInfo/PartInfo is specified, so no attachments are allowed.");
                    iCommonsList2.add((Object)EEbmsError.EBMS_EXTERNAL_PAYLOAD_ERROR.errorBuilder(locale).errorDetail("No PayloadInfo/PartInfo is specified, so no attachments are allowed.").build());
                    return ESuccess.FAILURE;
                }
            } else {
                if (iCommonsList.size() > ebms3PayloadInfo.getPartInfoCount()) {
                    object2 = "Error processing the UserMessage, the amount of specified attachments does not correlate with the actual attachments in the UserMessage. Expected " + ebms3PayloadInfo.getPartInfoCount() + " but having " + iCommonsList.size() + " attachments.";
                    LOGGER.error((String)object2);
                    iCommonsList2.add((Object)EEbmsError.EBMS_EXTERNAL_PAYLOAD_ERROR.errorBuilder(locale).errorDetail((String)object2).build());
                    return ESuccess.FAILURE;
                }
                int n5 = 0;
                for (Ebms3PartInfo ebms3PartInfo : ebms3PayloadInfo.getPartInfo()) {
                    if (StringHelper.isEmpty((String)ebms3PartInfo.getHref())) {
                        if (bl) continue;
                        LOGGER.error("Error processing the UserMessage. Expected a SOAP body payload but there is none present.");
                        iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail("Error processing the UserMessage. Expected a SOAP body payload but there is none present.").build());
                        return ESuccess.FAILURE;
                    }
                    ++n5;
                    string6 = StringHelper.trimStart((String)ebms3PartInfo.getHref(), (String)MessageHelperMethods.PREFIX_CID);
                    WSS4JAttachment wSS4JAttachment2 = (WSS4JAttachment)iCommonsList.findFirst(wSS4JAttachment -> EqualsHelper.equals((Object)wSS4JAttachment.getId(), (Object)string6));
                    if (wSS4JAttachment2 == null) {
                        LOGGER.warn("Failed to resolve MIME attachment '" + string6 + "' in list of " + String.valueOf(iCommonsList.getAllMapped(Attachment::getId)));
                    }
                    boolean bl5 = false;
                    boolean bl6 = false;
                    if (ebms3PartInfo.getPartProperties() != null) {
                        for (Ebms3Property ebms3Property : ebms3PartInfo.getPartProperties().getProperty()) {
                            Object object4;
                            String string14 = ebms3Property.getName();
                            String string15 = ebms3Property.getValue();
                            if (string14.equalsIgnoreCase("MimeType")) {
                                bl5 = StringHelper.isNotEmpty((String)string15);
                                continue;
                            }
                            if (string14.equalsIgnoreCase("CompressionType")) {
                                object4 = EAS4CompressionMode.getFromMimeTypeStringOrNull(string15);
                                if (object4 == null) {
                                    String string16 = "Error processing the UserMessage, CompressionType '" + string15 + "' of attachment '" + string6 + "' is not supported.";
                                    LOGGER.error(string16);
                                    iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail(string16).build());
                                    return ESuccess.FAILURE;
                                }
                                commonsHashMap.put((Object)string6, object4);
                                bl6 = true;
                                continue;
                            }
                            if (!string14.equalsIgnoreCase("CharacterSet") || !StringHelper.isNotEmpty((String)string15)) continue;
                            object4 = CharsetHelper.getCharsetFromNameOrNull((String)string15);
                            if (object4 == null) {
                                String string17 = "Value '" + string15 + "' of property 'CharacterSet' of attachment '" + string6 + "' is not supported";
                                LOGGER.error(string17);
                                iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail(string17).build());
                                return ESuccess.FAILURE;
                            }
                            if (wSS4JAttachment2 == null) continue;
                            wSS4JAttachment2.setCharset((Charset)object4);
                        }
                    }
                    if (!bl6 || bl5) continue;
                    String string18 = "Error processing the UserMessage, MimeType for a compressed attachment ('" + string6 + "') is not present.";
                    LOGGER.error(string18);
                    iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail(string18).build());
                    return ESuccess.FAILURE;
                }
                if (n5 != iCommonsList.size()) {
                    object = "Error processing the UserMessage: the amount of specified attachments does not correlate with the actual attachments in the UserMessage. Expected " + ebms3PayloadInfo.getPartInfoCount() + " but having " + iCommonsList.size() + " attachments. This is an indicator, that an external attached was provided.";
                    LOGGER.error((String)object);
                    iCommonsList2.add((Object)EEbmsError.EBMS_EXTERNAL_PAYLOAD_ERROR.errorBuilder(locale).errorDetail((String)object).build());
                    return ESuccess.FAILURE;
                }
            }
        } else {
            Ebms3SignalMessage ebms3SignalMessage = ebms3Messaging.getSignalMessageAtIndex(0);
            Ebms3MessageInfo ebms3MessageInfo = ebms3SignalMessage.getMessageInfo();
            if (ebms3MessageInfo != null) {
                aS4IncomingMessageState.setMessageID(ebms3MessageInfo.getMessageId());
                aS4IncomingMessageState.setRefToMessageID(ebms3MessageInfo.getRefToMessageId());
                aS4IncomingMessageState.setMessageTimestamp(ebms3MessageInfo.getTimestamp());
            }
            Ebms3PullRequest ebms3PullRequest = ebms3SignalMessage.getPullRequest();
            Ebms3Receipt ebms3Receipt = ebms3SignalMessage.getReceipt();
            if (ebms3PullRequest != null) {
                String string19 = ebms3PullRequest.getMpc();
                IMPC iMPC2 = iMPCManager.getMPCOfID(string19);
                if (iMPC2 == null) {
                    String string20 = "Failed to resolve the PullRequest MPC '" + string19 + "'";
                    LOGGER.error(string20);
                    iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_NOT_RECOGNIZED.errorBuilder(locale).errorDetail(string20).build());
                    return ESuccess.FAILURE;
                }
                for (IAS4IncomingPullRequestProcessorSPI iAS4IncomingPullRequestProcessorSPI : AS4IncomingPullRequestProcessorManager.getAllProcessors()) {
                    iPMode = iAS4IncomingPullRequestProcessorSPI.findPMode(ebms3SignalMessage);
                    if (iPMode == null) continue;
                    LOGGER.info("Found PMode '" + (String)iPMode.getID() + "' for MPC '" + string19 + "' in SignalMessage " + String.valueOf(ebms3SignalMessage));
                    this._notifyPModeResolved(iPMode);
                    break;
                }
                if (iPMode == null) {
                    String string21 = "Failed to resolve PMode for PullRequest with MPC '" + string19 + "'";
                    LOGGER.error(string21);
                    iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_NOT_RECOGNIZED.errorBuilder(locale).errorDetail(string21).build());
                    return ESuccess.FAILURE;
                }
            } else if (ebms3Receipt != null) {
                String string22 = ebms3SignalMessage.getMessageInfo().getRefToMessageId();
                if (StringHelper.isEmpty((String)string22)) {
                    LOGGER.error("The Receipt does not contain a RefToMessageId");
                    iCommonsList2.add((Object)EEbmsError.EBMS_INVALID_RECEIPT.errorBuilder(locale).errorDetail("The Receipt does not contain a RefToMessageId").build());
                    return ESuccess.FAILURE;
                }
            } else if (!ebms3SignalMessage.getError().isEmpty()) {
                for (Ebms3Error ebms3Error : ebms3SignalMessage.getError()) {
                }
            }
        }
        aS4IncomingMessageState.setPMode(iPMode);
        aS4IncomingMessageState.setOriginalSoapDocument(document);
        aS4IncomingMessageState.setOriginalAttachments(iCommonsList);
        aS4IncomingMessageState.setCompressedAttachmentIDs((ICommonsMap<String, EAS4CompressionMode>)commonsHashMap);
        aS4IncomingMessageState.setMPC(iMPC);
        aS4IncomingMessageState.setInitiatorID(string);
        aS4IncomingMessageState.setResponderID(string2);
        return ESuccess.SUCCESS;
    }
}

