/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.incoming.soap;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.logging.Phase4LoggerFactory;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.slf4j.Logger;

@Immutable
public final class AS4KeyStoreCallbackHandler
implements CallbackHandler {
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(AS4KeyStoreCallbackHandler.class);
    private final IAS4CryptoFactory m_aCryptoFactoryCrypt;

    public AS4KeyStoreCallbackHandler(@Nonnull IAS4CryptoFactory iAS4CryptoFactory) {
        ValueEnforcer.notNull((Object)iAS4CryptoFactory, (String)"CryptoFactoryCrypt");
        this.m_aCryptoFactoryCrypt = iAS4CryptoFactory;
    }

    @Nonnull
    @Nonempty
    private static String _getUsage(int n) {
        switch (n) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "DECRYPT";
            }
            case 2: {
                return "USERNAME_TOKEN";
            }
            case 3: {
                return "SIGNATURE";
            }
            case 6: {
                return "SECURITY_CONTEXT_TOKEN";
            }
            case 7: {
                return "CUSTOM_TOKEN";
            }
            case 9: {
                return "SECRET_KEY";
            }
            case 10: {
                return "PASSWORD_ENCRYPTOR_PASSWORD";
            }
        }
        return "Unknown usage value " + n;
    }

    @Override
    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbackArray) {
            if (callback instanceof WSPasswordCallback) {
                WSPasswordCallback wSPasswordCallback = (WSPasswordCallback)callback;
                String string = wSPasswordCallback.getIdentifier();
                String string2 = this.m_aCryptoFactoryCrypt.getKeyPasswordPerAlias(string);
                if (string2 != null) {
                    wSPasswordCallback.setPassword(string2);
                    LOGGER.info("Found keystore password for alias '" + string + "' and usage " + AS4KeyStoreCallbackHandler._getUsage(wSPasswordCallback.getUsage()));
                    continue;
                }
                LOGGER.warn("Found unsupported keystore alias '" + string + "' and usage " + AS4KeyStoreCallbackHandler._getUsage(wSPasswordCallback.getUsage()));
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
        }
    }
}

