/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.incoming;

import com.helger.annotation.Nonempty;
import com.helger.annotation.WillClose;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.iface.IThrowingRunnable;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayOutputStream;
import com.helger.base.io.stream.HasInputStream;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.state.ISuccessIndicator;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.http.header.HttpHeaderMap;
import com.helger.httpclient.response.ResponseHandlerXml;
import com.helger.mime.EMimeContentType;
import com.helger.mime.IMimeType;
import com.helger.mime.MimeType;
import com.helger.mime.parse.MimeTypeParser;
import com.helger.phase4.attachment.AS4DecompressException;
import com.helger.phase4.attachment.IAS4IncomingAttachmentFactory;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.client.IAS4RetryCallback;
import com.helger.phase4.crypto.AS4CryptParams;
import com.helger.phase4.crypto.AS4SigningParams;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.dump.AS4DumpManager;
import com.helger.phase4.dump.IAS4IncomingDumper;
import com.helger.phase4.dump.IAS4OutgoingDumper;
import com.helger.phase4.ebms3header.Ebms3CollaborationInfo;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3MessageInfo;
import com.helger.phase4.ebms3header.Ebms3MessageProperties;
import com.helger.phase4.ebms3header.Ebms3PartyInfo;
import com.helger.phase4.ebms3header.Ebms3PayloadInfo;
import com.helger.phase4.ebms3header.Ebms3Property;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.incoming.AS4IncomingHandler;
import com.helger.phase4.incoming.IAS4IncomingMessageMetadata;
import com.helger.phase4.incoming.IAS4IncomingMessageState;
import com.helger.phase4.incoming.IAS4IncomingProfileSelector;
import com.helger.phase4.incoming.IAS4IncomingReceiverConfiguration;
import com.helger.phase4.incoming.IAS4RequestHandlerErrorConsumer;
import com.helger.phase4.incoming.IAS4ResponseAbstraction;
import com.helger.phase4.incoming.IAS4SoapProcessingFinalizedCallback;
import com.helger.phase4.incoming.crypto.IAS4IncomingSecurityConfiguration;
import com.helger.phase4.incoming.mgr.AS4IncomingMessageProcessorManager;
import com.helger.phase4.incoming.soap.SoapHeaderElementProcessorRegistry;
import com.helger.phase4.incoming.spi.AS4MessageProcessorResult;
import com.helger.phase4.incoming.spi.AS4SignalMessageProcessorResult;
import com.helger.phase4.incoming.spi.IAS4IncomingMessageProcessorSPI;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.messaging.EAS4MessageMode;
import com.helger.phase4.messaging.crypto.AS4Encryptor;
import com.helger.phase4.messaging.crypto.AS4Signer;
import com.helger.phase4.messaging.http.AS4HttpDebug;
import com.helger.phase4.messaging.http.BasicHttpPoster;
import com.helger.phase4.messaging.http.HttpMimeMessageEntity;
import com.helger.phase4.messaging.http.HttpRetrySettings;
import com.helger.phase4.messaging.http.HttpXMLEntity;
import com.helger.phase4.messaging.mime.AS4MimeMessage;
import com.helger.phase4.messaging.mime.AS4MimeMessageHelper;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.EMEPBinding;
import com.helger.phase4.model.ESoapVersion;
import com.helger.phase4.model.MEPHelper;
import com.helger.phase4.model.error.EEbmsError;
import com.helger.phase4.model.message.AS4ErrorMessage;
import com.helger.phase4.model.message.AS4ReceiptMessage;
import com.helger.phase4.model.message.AS4UserMessage;
import com.helger.phase4.model.message.EAS4MessageType;
import com.helger.phase4.model.message.MessageHelperMethods;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.leg.EPModeSendReceiptReplyPattern;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.model.pmode.resolve.IAS4PModeResolver;
import com.helger.phase4.profile.IAS4Profile;
import com.helger.phase4.util.AS4ResourceHelper;
import com.helger.phase4.util.AS4XMLHelper;
import com.helger.phase4.util.Phase4Exception;
import com.helger.photon.io.PhotonWorkerPool;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@NotThreadSafe
public class AS4RequestHandler
implements AutoCloseable {
    public static final IMimeType MT_MULTIPART_RELATED = EMimeContentType.MULTIPART.buildMimeType("related");
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(AS4RequestHandler.class);
    private final AS4ResourceHelper m_aResHelper;
    private final IAS4IncomingMessageMetadata m_aMessageMetadata;
    private IAS4CryptoFactory m_aCryptoFactorySign;
    private IAS4CryptoFactory m_aCryptoFactoryCrypt;
    private IAS4PModeResolver m_aPModeResolver;
    private IAS4IncomingAttachmentFactory m_aIncomingAttachmentFactory;
    private IAS4IncomingSecurityConfiguration m_aIncomingSecurityConfig;
    private IAS4IncomingReceiverConfiguration m_aIncomingReceiverConfig;
    private IAS4IncomingProfileSelector m_aIncomingProfileSelector;
    private Locale m_aLocale = Locale.US;
    private IAS4IncomingDumper m_aIncomingDumper;
    private IAS4OutgoingDumper m_aOutgoingDumper;
    private IAS4RetryCallback m_aRetryCallback;
    private IAS4SoapProcessingFinalizedCallback m_aSoapProcessingFinalizedCB;
    private Supplier<? extends ICommonsList<IAS4IncomingMessageProcessorSPI>> m_aProcessorSupplier = AS4IncomingMessageProcessorManager::getAllProcessors;
    private IAS4RequestHandlerErrorConsumer m_aErrorConsumer;

    public AS4RequestHandler(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata) {
        ValueEnforcer.notNull((Object)iAS4IncomingMessageMetadata, (String)"MessageMetadata");
        this.m_aResHelper = new AS4ResourceHelper();
        this.m_aMessageMetadata = iAS4IncomingMessageMetadata;
    }

    @Override
    public void close() {
        this.m_aResHelper.close();
    }

    @Nonnull
    protected final IAS4IncomingMessageMetadata getMessageMetadata() {
        return this.m_aMessageMetadata;
    }

    @Nullable
    public final IAS4CryptoFactory getCryptoFactorySign() {
        return this.m_aCryptoFactorySign;
    }

    @Nonnull
    public final AS4RequestHandler setCryptoFactorySign(@Nonnull IAS4CryptoFactory iAS4CryptoFactory) {
        ValueEnforcer.notNull((Object)iAS4CryptoFactory, (String)"CryptoFactorySign");
        this.m_aCryptoFactorySign = iAS4CryptoFactory;
        return this;
    }

    @Nullable
    public final IAS4CryptoFactory getCryptoFactoryCrypt() {
        return this.m_aCryptoFactoryCrypt;
    }

    @Nonnull
    public final AS4RequestHandler setCryptoFactoryCrypt(@Nonnull IAS4CryptoFactory iAS4CryptoFactory) {
        ValueEnforcer.notNull((Object)iAS4CryptoFactory, (String)"CryptoFactoryCrypt");
        this.m_aCryptoFactoryCrypt = iAS4CryptoFactory;
        return this;
    }

    @Nonnull
    public final AS4RequestHandler setCryptoFactory(@Nonnull IAS4CryptoFactory iAS4CryptoFactory) {
        ValueEnforcer.notNull((Object)iAS4CryptoFactory, (String)"CryptoFactory");
        return this.setCryptoFactorySign(iAS4CryptoFactory).setCryptoFactoryCrypt(iAS4CryptoFactory);
    }

    @Nullable
    public final IAS4PModeResolver getPModeResolver() {
        return this.m_aPModeResolver;
    }

    @Nonnull
    public final AS4RequestHandler setPModeResolver(@Nonnull IAS4PModeResolver iAS4PModeResolver) {
        ValueEnforcer.notNull((Object)iAS4PModeResolver, (String)"PModeResolver");
        this.m_aPModeResolver = iAS4PModeResolver;
        return this;
    }

    @Nullable
    public final IAS4IncomingAttachmentFactory getIncomingAttachmentFactory() {
        return this.m_aIncomingAttachmentFactory;
    }

    @Nonnull
    public final AS4RequestHandler setIncomingAttachmentFactory(@Nonnull IAS4IncomingAttachmentFactory iAS4IncomingAttachmentFactory) {
        ValueEnforcer.notNull((Object)iAS4IncomingAttachmentFactory, (String)"IAF");
        this.m_aIncomingAttachmentFactory = iAS4IncomingAttachmentFactory;
        return this;
    }

    @Nullable
    public final IAS4IncomingSecurityConfiguration getIncomingSecurityConfiguration() {
        return this.m_aIncomingSecurityConfig;
    }

    @Nonnull
    public final AS4RequestHandler setIncomingSecurityConfiguration(@Nonnull IAS4IncomingSecurityConfiguration iAS4IncomingSecurityConfiguration) {
        ValueEnforcer.notNull((Object)iAS4IncomingSecurityConfiguration, (String)"ICS");
        this.m_aIncomingSecurityConfig = iAS4IncomingSecurityConfiguration;
        return this;
    }

    @Nullable
    public final IAS4IncomingReceiverConfiguration getIncomingReceiverConfiguration() {
        return this.m_aIncomingReceiverConfig;
    }

    @Nonnull
    public final AS4RequestHandler setIncomingReceiverConfiguration(@Nonnull IAS4IncomingReceiverConfiguration iAS4IncomingReceiverConfiguration) {
        ValueEnforcer.notNull((Object)iAS4IncomingReceiverConfiguration, (String)"ICS");
        this.m_aIncomingReceiverConfig = iAS4IncomingReceiverConfiguration;
        return this;
    }

    @Nonnull
    public final IAS4IncomingProfileSelector getIncomingProfileSelector() {
        return this.m_aIncomingProfileSelector;
    }

    @Nonnull
    public final AS4RequestHandler setIncomingProfileSelector(@Nonnull IAS4IncomingProfileSelector iAS4IncomingProfileSelector) {
        ValueEnforcer.notNull((Object)iAS4IncomingProfileSelector, (String)"IncomingProfileSelector");
        this.m_aIncomingProfileSelector = iAS4IncomingProfileSelector;
        return this;
    }

    @Nonnull
    public final Locale getLocale() {
        return this.m_aLocale;
    }

    @Nonnull
    public final AS4RequestHandler setLocale(@Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"Locale");
        this.m_aLocale = locale;
        return this;
    }

    @Nullable
    public final IAS4IncomingDumper getIncomingDumper() {
        return this.m_aIncomingDumper;
    }

    @Nonnull
    public final AS4RequestHandler setIncomingDumper(@Nullable IAS4IncomingDumper iAS4IncomingDumper) {
        this.m_aIncomingDumper = iAS4IncomingDumper;
        return this;
    }

    @Nullable
    public final IAS4OutgoingDumper getOutgoingDumper() {
        return this.m_aOutgoingDumper;
    }

    @Nonnull
    public final AS4RequestHandler setOutgoingDumper(@Nullable IAS4OutgoingDumper iAS4OutgoingDumper) {
        this.m_aOutgoingDumper = iAS4OutgoingDumper;
        return this;
    }

    @Nullable
    public final IAS4RetryCallback getRetryCallback() {
        return this.m_aRetryCallback;
    }

    @Nonnull
    public final AS4RequestHandler setRetryCallback(@Nullable IAS4RetryCallback iAS4RetryCallback) {
        this.m_aRetryCallback = iAS4RetryCallback;
        return this;
    }

    @Nullable
    public final IAS4SoapProcessingFinalizedCallback getSoapProcessingFinalizedCallback() {
        return this.m_aSoapProcessingFinalizedCB;
    }

    @Nonnull
    public final AS4RequestHandler setSoapProcessingFinalizedCallback(@Nullable IAS4SoapProcessingFinalizedCallback iAS4SoapProcessingFinalizedCallback) {
        this.m_aSoapProcessingFinalizedCB = iAS4SoapProcessingFinalizedCallback;
        return this;
    }

    @Nonnull
    public final Supplier<? extends ICommonsList<IAS4IncomingMessageProcessorSPI>> getProcessorSupplier() {
        return this.m_aProcessorSupplier;
    }

    @Nonnull
    public final <T extends IAS4IncomingMessageProcessorSPI> T getProcessorOfType(@Nonnull Class<T> clazz) {
        for (IAS4IncomingMessageProcessorSPI iAS4IncomingMessageProcessorSPI : this.m_aProcessorSupplier.get()) {
            if (!clazz.isInstance(iAS4IncomingMessageProcessorSPI)) continue;
            return (T)((IAS4IncomingMessageProcessorSPI)clazz.cast(iAS4IncomingMessageProcessorSPI));
        }
        return null;
    }

    @Nonnull
    public final AS4RequestHandler setProcessorSupplier(@Nonnull Supplier<? extends ICommonsList<IAS4IncomingMessageProcessorSPI>> supplier) {
        ValueEnforcer.notNull(supplier, (String)"ProcessorSupplier");
        this.m_aProcessorSupplier = supplier;
        return this;
    }

    @Nullable
    public final IAS4RequestHandlerErrorConsumer getErrorConsumer() {
        return this.m_aErrorConsumer;
    }

    @Nonnull
    public final AS4RequestHandler setErrorConsumer(@Nullable IAS4RequestHandlerErrorConsumer iAS4RequestHandlerErrorConsumer) {
        this.m_aErrorConsumer = iAS4RequestHandlerErrorConsumer;
        return this;
    }

    private void _invokeSPIsForIncoming(@Nonnull HttpHeaderMap httpHeaderMap, @Nullable Ebms3UserMessage ebms3UserMessage, @Nullable Ebms3SignalMessage ebms3SignalMessage, @Nullable Node node, @Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nullable IPMode iPMode, @Nonnull IAS4IncomingMessageState iAS4IncomingMessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList2, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList3, @Nonnull SPIInvocationResult sPIInvocationResult) {
        ValueEnforcer.isTrue((ebms3UserMessage != null || ebms3SignalMessage != null ? 1 : 0) != 0, (String)"User OR Signal Message must be present");
        ValueEnforcer.isFalse((ebms3UserMessage != null && ebms3SignalMessage != null ? 1 : 0) != 0, (String)"Only one of User OR Signal Message may be present");
        boolean bl = ebms3UserMessage != null;
        String string = bl ? ebms3UserMessage.getMessageInfo().getMessageId() : ebms3SignalMessage.getMessageInfo().getMessageId();
        ICommonsList<IAS4IncomingMessageProcessorSPI> iCommonsList4 = this.m_aProcessorSupplier.get();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Trying to invoke the following " + iCommonsList4.size() + " SPIs on message ID '" + string + "': " + String.valueOf(iCommonsList4));
        }
        if (iCommonsList4.isEmpty()) {
            LOGGER.error("No IAS4ServletMessageProcessorSPI is available to process an incoming message");
            if (GlobalDebug.isProductionMode()) {
                iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.errorBuilder(this.m_aLocale).refToMessageInError(string).errorDetail("The phase4 implementation is marked as in production, but has no capabilities to process an incoming message. Unfortunately, the message needs to be rejected for that reason.").build());
                return;
            }
        }
        for (IAS4IncomingMessageProcessorSPI iAS4IncomingMessageProcessorSPI : iCommonsList4) {
            String string2;
            if (iAS4IncomingMessageProcessorSPI == null) continue;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Invoking AS4 message processor " + String.valueOf(iAS4IncomingMessageProcessorSPI) + " for incoming message");
                }
                string2 = new CommonsArrayList();
                AS4MessageProcessorResult aS4MessageProcessorResult = bl ? iAS4IncomingMessageProcessorSPI.processAS4UserMessage(this.m_aMessageMetadata, httpHeaderMap, ebms3UserMessage, iPMode, node, iCommonsList, iAS4IncomingMessageState, (ICommonsList<Ebms3Error>)string2) : iAS4IncomingMessageProcessorSPI.processAS4SignalMessage(this.m_aMessageMetadata, httpHeaderMap, ebms3SignalMessage, iPMode, iAS4IncomingMessageState, (ICommonsList<Ebms3Error>)string2);
                if (aS4MessageProcessorResult == null) {
                    throw new IllegalStateException("No result object present from AS4 message processor " + String.valueOf(iAS4IncomingMessageProcessorSPI) + " - this is a programming error");
                }
                if (string2.isNotEmpty() || aS4MessageProcessorResult.isFailure()) {
                    if (aS4MessageProcessorResult.isFailure() && string2.isEmpty()) {
                        string2.add((Object)EEbmsError.EBMS_OTHER.errorBuilder(this.m_aLocale).errorDetail("An undefined generic error occurred in phase4").build());
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("AS4 message processor " + String.valueOf(iAS4IncomingMessageProcessorSPI) + " had processing errors - breaking. Details: " + String.valueOf(string2));
                    }
                    if (aS4MessageProcessorResult.isSuccess()) {
                        LOGGER.warn("Processing errors are present but success was returned by a previous AS4 message processor " + String.valueOf(iAS4IncomingMessageProcessorSPI) + " - considering the whole processing to be failed instead");
                    }
                    iCommonsList2.addAll((Collection)((Object)string2));
                    sPIInvocationResult.setSuccess(false);
                    return;
                }
                Object object = aS4MessageProcessorResult.getAsyncResponseURL();
                if (StringHelper.isNotEmpty((String)object)) {
                    if (sPIInvocationResult.hasAsyncResponseURL()) {
                        String string3 = "Invoked AS4 message processor SPI " + String.valueOf(iAS4IncomingMessageProcessorSPI) + " on '" + string + "' failed: the previous processor already returned an async response URL; it is not possible to handle two URLs. Please check your SPI implementations.";
                        LOGGER.error(string3);
                        iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(this.m_aLocale).refToMessageInError(string).errorDetail(string3).build());
                        return;
                    }
                    sPIInvocationResult.setAsyncResponseURL((String)object);
                    LOGGER.info("Using asynchronous response URL '" + (String)object + "' for message ID '" + string + "'");
                }
                if (!bl) {
                    assert (aS4MessageProcessorResult instanceof AS4SignalMessageProcessorResult);
                    if (ebms3SignalMessage.getReceipt() == null) {
                        object = ((AS4SignalMessageProcessorResult)aS4MessageProcessorResult).getPullReturnUserMessage();
                        if (sPIInvocationResult.hasPullReturnUserMsg()) {
                            if (object != null) {
                                String string4 = "Invoked AS4 message processor SPI " + String.valueOf(iAS4IncomingMessageProcessorSPI) + " on '" + string + "' failed: the previous processor already returned a usermessage; it is not possible to return two usermessage. Please check your SPI implementations.";
                                LOGGER.warn(string4);
                                iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(this.m_aLocale).refToMessageInError(string).errorDetail(string4).build());
                                return;
                            }
                        } else {
                            if (object == null) {
                                String string5 = "Invoked AS4 message processor SPI " + String.valueOf(iAS4IncomingMessageProcessorSPI) + " on '" + string + "' returned a failure: no UserMessage contained in the MPC";
                                LOGGER.error(string5);
                                iCommonsList2.add((Object)EEbmsError.EBMS_EMPTY_MESSAGE_PARTITION_CHANNEL.errorBuilder(this.m_aLocale).refToMessageInError(string).errorDetail(string5).build());
                                return;
                            }
                            sPIInvocationResult.setPullReturnUserMsg((Ebms3UserMessage)object);
                        }
                    } else if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("The AS4 EbmsSignalMessage already has a Receipt");
                    }
                }
                aS4MessageProcessorResult.addAllAttachmentsTo((Collection<? super WSS4JAttachment>)iCommonsList3);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Successfully invoked AS4 message processor " + String.valueOf(iAS4IncomingMessageProcessorSPI));
            }
            catch (AS4DecompressException aS4DecompressException) {
                LOGGER.error("Failed to decompress AS4 payload", (Throwable)aS4DecompressException);
                iCommonsList2.add((Object)EEbmsError.EBMS_DECOMPRESSION_FAILURE.errorBuilder(this.m_aLocale).refToMessageInError(string).errorDetail("Failed to decompress AS4 payload", aS4DecompressException).build());
                return;
            }
            catch (Exception exception) {
                string2 = "Error processing incoming AS4 message with processor '" + String.valueOf(iAS4IncomingMessageProcessorSPI) + "'";
                LOGGER.error(string2, (Throwable)exception);
                iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.errorBuilder(this.m_aLocale).refToMessageInError(string).errorDetail(string2, exception).build());
                return;
            }
        }
        sPIInvocationResult.setSuccess(true);
    }

    private void _invokeSPIsForResponse(@Nonnull IAS4IncomingMessageState iAS4IncomingMessageState, @Nullable IAS4ResponseFactory iAS4ResponseFactory, @Nullable HttpEntity iCommonsList, @Nonnull IMimeType iMimeType, @Nullable String string) {
        ICommonsList<IAS4IncomingMessageProcessorSPI> iCommonsList2;
        boolean bl = iAS4ResponseFactory != null;
        byte[] byArray = null;
        if (iAS4ResponseFactory != null) {
            ICommonsList<IAS4IncomingMessageProcessorSPI> iCommonsList3 = iCommonsList2 = iCommonsList != null ? iCommonsList : iAS4ResponseFactory.getHttpEntityForSending(iMimeType);
            if (iCommonsList2.isRepeatable()) {
                int n = (int)iCommonsList2.getContentLength();
                if (n < 0) {
                    n = 16384;
                }
                try (Object object = new NonBlockingByteArrayOutputStream(n);){
                    iCommonsList2.writeTo((OutputStream)object);
                    byArray = object.getBufferOrCopy();
                }
                catch (IOException iOException) {
                    LOGGER.error("Error dumping response entity", (Throwable)iOException);
                }
            } else {
                LOGGER.warn("AS4 Response entity is not repeatable and therefore not read for SPIs");
            }
        } else {
            LOGGER.info("No response factory present");
        }
        iCommonsList2 = this.m_aProcessorSupplier.get();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Trying to invoke the following " + iCommonsList2.size() + " SPIs on AS4 message ID '" + iAS4IncomingMessageState.getMessageID() + "' and AS4 response message ID '" + string + ": " + String.valueOf(iCommonsList2));
        }
        for (Object object : iCommonsList2) {
            if (object == null) continue;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Invoking AS4 message processor " + String.valueOf(object) + " for response");
                }
                object.processAS4ResponseMessage(this.m_aMessageMetadata, iAS4IncomingMessageState, string, byArray, bl);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Finished invoking AS4 message processor " + String.valueOf(object) + " for response");
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new IllegalStateException("Error invoking AS4 message processor " + String.valueOf(object) + " for response", exception);
            }
        }
    }

    @Nonnull
    private static AS4UserMessage _createReversedUserMessage(@Nonnull ESoapVersion eSoapVersion, @Nonnull @Nonempty String string, @Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList) {
        Ebms3MessageInfo ebms3MessageInfo = MessageHelperMethods.createEbms3MessageInfo(string, ebms3UserMessage.getMessageInfo().getMessageId());
        Ebms3PayloadInfo ebms3PayloadInfo = MessageHelperMethods.createEbms3PayloadInfo(false, iCommonsList);
        Ebms3PartyInfo ebms3PartyInfo = MessageHelperMethods.createEbms3ReversePartyInfo(ebms3UserMessage.getPartyInfo());
        Ebms3CollaborationInfo ebms3CollaborationInfo = ebms3UserMessage.getCollaborationInfo();
        Ebms3MessageProperties ebms3MessageProperties = new Ebms3MessageProperties();
        Ebms3Property ebms3Property = null;
        Ebms3Property ebms3Property2 = null;
        for (Ebms3Property ebms3Property3 : ebms3UserMessage.getMessageProperties().getProperty()) {
            if (ebms3Property3.getName().equals("originalSender")) {
                ebms3Property2 = ebms3Property3;
                continue;
            }
            if (!ebms3Property3.getName().equals("finalRecipient")) continue;
            ebms3Property = ebms3Property3;
        }
        if (ebms3Property2 != null && ebms3Property != null) {
            ebms3Property.setName("originalSender");
            ebms3Property2.setName("finalRecipient");
            ebms3MessageProperties.addProperty(ebms3Property.clone());
            ebms3MessageProperties.addProperty(ebms3Property2.clone());
        }
        return AS4UserMessage.create(ebms3MessageInfo, ebms3PayloadInfo, ebms3CollaborationInfo, ebms3PartyInfo, ebms3MessageProperties, null, eSoapVersion);
    }

    private static boolean _isSendErrorAsResponse(@Nullable PModeLeg pModeLeg) {
        if (pModeLeg != null && pModeLeg.hasErrorHandling() && pModeLeg.getErrorHandling().isReportAsResponseDefined()) {
            return pModeLeg.getErrorHandling().isReportAsResponse();
        }
        return true;
    }

    private static boolean _isSendReceiptAsResponse(@Nullable PModeLeg pModeLeg) {
        if (pModeLeg != null && pModeLeg.hasSecurity()) {
            return pModeLeg.getSecurity().isSendReceipt() && EPModeSendReceiptReplyPattern.RESPONSE.equals((Object)pModeLeg.getSecurity().getSendReceiptReplyPattern());
        }
        return true;
    }

    @Nonnull
    private Document _signResponseIfNeeded(@Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4SigningParams aS4SigningParams, @Nonnull Document document, @Nonnull ESoapVersion eSoapVersion, @Nonnull @Nonempty String string) throws WSSecurityException {
        Document document2 = aS4SigningParams.isSigningEnabled() ? AS4Signer.createSignedMessage(this.m_aCryptoFactorySign, document, eSoapVersion, string, iCommonsList, this.m_aResHelper, true, aS4SigningParams.getClone()) : document;
        return document2;
    }

    private static boolean _isSendNonRepudiationInformation(@Nonnull PModeLeg pModeLeg) {
        if (pModeLeg.hasSecurity() && pModeLeg.getSecurity().isSendReceiptNonRepudiationDefined()) {
            return pModeLeg.getSecurity().isSendReceiptNonRepudiation();
        }
        return false;
    }

    @Nonnull
    private IAS4ResponseFactory _createResponseReceiptMessage(@Nonnull IAS4IncomingMessageState iAS4IncomingMessageState, @Nullable Document document, @Nonnull ESoapVersion eSoapVersion, @Nonnull @Nonempty String string, @Nonnull PModeLeg pModeLeg, @Nullable Ebms3UserMessage ebms3UserMessage, @Nullable ICommonsList<WSS4JAttachment> iCommonsList) throws WSSecurityException {
        AS4ReceiptMessage aS4ReceiptMessage = AS4ReceiptMessage.create(eSoapVersion, string, ebms3UserMessage, document, AS4RequestHandler._isSendNonRepudiationInformation(pModeLeg), null);
        ESoapVersion eSoapVersion2 = pModeLeg.getProtocol().getSoapVersion();
        if (eSoapVersion2 != eSoapVersion) {
            LOGGER.warn("Received message with " + String.valueOf((Object)eSoapVersion) + " but the Response PMode leg requires " + String.valueOf((Object)eSoapVersion2));
        }
        Document document2 = aS4ReceiptMessage.getAsSoapDocument();
        AS4SigningParams aS4SigningParams = this.m_aIncomingSecurityConfig.getSigningParamsCloneOrNew().setFromPMode(pModeLeg.getSecurity());
        Document document3 = this._signResponseIfNeeded(iCommonsList, aS4SigningParams, document2, eSoapVersion2, aS4ReceiptMessage.getMessagingID());
        return new AS4ResponseFactoryXML(this.m_aMessageMetadata, iAS4IncomingMessageState, string, document3, eSoapVersion2.getMimeType());
    }

    @Nonnull
    private IAS4ResponseFactory _createResponseErrorMessage(@Nonnull IAS4IncomingMessageState iAS4IncomingMessageState, @Nonnull ESoapVersion eSoapVersion, @Nonnull @Nonempty String string, @Nullable PModeLeg pModeLeg, @Nonnull @Nonempty ICommonsList<Ebms3Error> iCommonsList) {
        ESoapVersion eSoapVersion2;
        AS4ErrorMessage aS4ErrorMessage = AS4ErrorMessage.create(eSoapVersion, MessageHelperMethods.createEbms3MessageInfo(string, iAS4IncomingMessageState.getMessageID()), iCommonsList);
        if (this.m_aErrorConsumer != null) {
            this.m_aErrorConsumer.onAS4ErrorMessage(iAS4IncomingMessageState, iCommonsList, aS4ErrorMessage);
        }
        if (pModeLeg != null) {
            eSoapVersion2 = pModeLeg.getProtocol().getSoapVersion();
            if (eSoapVersion2 != eSoapVersion) {
                LOGGER.warn("Received message with " + String.valueOf((Object)eSoapVersion) + " but the Response PMode leg requires " + String.valueOf((Object)eSoapVersion2));
            }
        } else {
            eSoapVersion2 = eSoapVersion;
        }
        Document document = aS4ErrorMessage.getAsSoapDocument();
        if (pModeLeg != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Trying to sign AS4 Error response");
            }
            try {
                Document document2;
                AS4SigningParams aS4SigningParams = this.m_aIncomingSecurityConfig.getSigningParamsCloneOrNew().setFromPMode(pModeLeg.getSecurity());
                document = document2 = this._signResponseIfNeeded(null, aS4SigningParams, document, eSoapVersion2, aS4ErrorMessage.getMessagingID());
            }
            catch (WSSecurityException wSSecurityException) {
                LOGGER.warn("Tried to sign the AS4 Error message but failed. Returning the unsigned AS4 Error instead.", (Throwable)wSSecurityException);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cannot sign AS4 Error response, because no PMode Leg was provided");
        }
        return new AS4ResponseFactoryXML(this.m_aMessageMetadata, iAS4IncomingMessageState, string, document, eSoapVersion2.getMimeType());
    }

    @Nonnull
    private AS4MimeMessage _createMimeMessageForResponse(@Nonnull Document document, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull ESoapVersion eSoapVersion, @Nonnull AS4CryptParams aS4CryptParams) throws WSSecurityException, MessagingException {
        AS4MimeMessage aS4MimeMessage;
        if (aS4CryptParams.isCryptEnabled(arg_0 -> ((Logger)LOGGER).warn(arg_0))) {
            if (iCommonsList.isNotEmpty()) {
                aS4MimeMessage = AS4Encryptor.encryptToMimeMessage(eSoapVersion, document, iCommonsList, this.m_aCryptoFactoryCrypt, true, this.m_aResHelper, aS4CryptParams);
            } else {
                LOGGER.info("AS4 encryption is enabled but no response attachments are present");
                aS4MimeMessage = AS4MimeMessageHelper.generateMimeMessage(eSoapVersion, document, iCommonsList);
            }
        } else {
            aS4MimeMessage = AS4MimeMessageHelper.generateMimeMessage(eSoapVersion, document, iCommonsList);
        }
        if (aS4MimeMessage == null) {
            throw new IllegalStateException("Failed to create MimeMessage!");
        }
        return aS4MimeMessage;
    }

    @Nonnull
    private IAS4ResponseFactory _createResponseUserMessage(@Nonnull IAS4IncomingMessageState iAS4IncomingMessageState, @Nonnull ESoapVersion eSoapVersion, @Nonnull AS4UserMessage aS4UserMessage, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4SigningParams aS4SigningParams, @Nonnull AS4CryptParams aS4CryptParams) throws WSSecurityException, MessagingException {
        IAS4ResponseFactory iAS4ResponseFactory;
        String string = aS4UserMessage.getEbms3UserMessage().getMessageInfo().getMessageId();
        Document document = this._signResponseIfNeeded(iCommonsList, aS4SigningParams, aS4UserMessage.getAsSoapDocument(), eSoapVersion, aS4UserMessage.getMessagingID());
        if (iCommonsList.isEmpty()) {
            iAS4ResponseFactory = new AS4ResponseFactoryXML(this.m_aMessageMetadata, iAS4IncomingMessageState, string, document, eSoapVersion.getMimeType());
        } else {
            AS4MimeMessage aS4MimeMessage = this._createMimeMessageForResponse(document, iCommonsList, eSoapVersion, aS4CryptParams);
            iAS4ResponseFactory = new AS4ResponseFactoryMIME(this.m_aMessageMetadata, iAS4IncomingMessageState, string, aS4MimeMessage);
        }
        return iAS4ResponseFactory;
    }

    @Nullable
    private IAS4ResponseFactory _handleSoapMessage(@Nonnull HttpHeaderMap httpHeaderMap, @Nonnull Document document, @Nonnull ESoapVersion eSoapVersion, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull ICommonsList<Ebms3Error> iCommonsList2) throws WSSecurityException, MessagingException, Phase4Exception {
        Object object;
        String string;
        IAS4Profile iAS4Profile;
        Object object2;
        SoapHeaderElementProcessorRegistry soapHeaderElementProcessorRegistry = SoapHeaderElementProcessorRegistry.createDefault(this.m_aPModeResolver, this.m_aCryptoFactorySign, this.m_aCryptoFactoryCrypt, null, this.m_aIncomingSecurityConfig, this.m_aIncomingReceiverConfig);
        IAS4IncomingMessageState iAS4IncomingMessageState = AS4IncomingHandler.processEbmsMessage(this.m_aResHelper, this.m_aLocale, soapHeaderElementProcessorRegistry, httpHeaderMap, document, eSoapVersion, iCommonsList, this.m_aIncomingProfileSelector, iCommonsList2, this.m_aMessageMetadata);
        IPMode iPMode = iAS4IncomingMessageState.getPMode();
        PModeLeg pModeLeg = iAS4IncomingMessageState.getEffectivePModeLeg();
        String string2 = iAS4IncomingMessageState.getMessageID();
        ICommonsList<WSS4JAttachment> iCommonsList3 = iAS4IncomingMessageState.hasDecryptedAttachments() ? iAS4IncomingMessageState.getDecryptedAttachments() : iAS4IncomingMessageState.getOriginalAttachments();
        Node node = iAS4IncomingMessageState.getSoapBodyPayloadNode();
        Ebms3UserMessage ebms3UserMessage = iAS4IncomingMessageState.getEbmsUserMessage();
        Ebms3SignalMessage ebms3SignalMessage = iAS4IncomingMessageState.getEbmsSignalMessage();
        if (iAS4IncomingMessageState.isSoapHeaderElementProcessingSuccessful()) {
            boolean bl;
            object2 = iAS4IncomingMessageState.getProfileID();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Now checking for duplicate message with message ID '" + string2 + "' and profile ID '" + (String)object2 + "'");
            }
            if (bl = MetaAS4Manager.getIncomingDuplicateMgr().registerAndCheck(string2, (String)object2, iPMode == null ? null : (String)iPMode.getID()).isBreak()) {
                String string3 = "Not invoking SPIs, because message with Message ID '" + string2 + "' was already handled (this is a duplicate)";
                LOGGER.error(string3);
                iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.errorBuilder(this.m_aLocale).refToMessageInError(string2).errorDetail(string3).build());
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Message is not a duplicate");
            }
        }
        object2 = new SPIInvocationResult();
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        boolean bl = true;
        if (iCommonsList2.isNotEmpty()) {
            bl = false;
        }
        if ((iAS4Profile = iAS4IncomingMessageState.getAS4Profile()) == null) {
            if (iAS4IncomingMessageState.isPingMessage()) {
                bl = false;
            }
        } else if (iAS4IncomingMessageState.isPingMessage()) {
            bl = iAS4Profile.isInvokeSPIForPingMessage();
        }
        if (iAS4IncomingMessageState.isPingMessage() && !bl) {
            LOGGER.info("Received an AS4 Ping message - meaning it will NOT be handled by the custom handlers.");
        }
        if (bl) {
            if (iPMode == null || iPMode.getMEPBinding().isSynchronous() || iPMode.getMEPBinding().isAsynchronousInitiator() || iAS4IncomingMessageState.getEffectivePModeLegNumber() <= 0 || iPMode.getMEPBinding() == EMEPBinding.PUSH_PUSH && iAS4IncomingMessageState.getEffectivePModeLegNumber() == 2) {
                this._invokeSPIsForIncoming(httpHeaderMap, ebms3UserMessage, ebms3SignalMessage, node, iCommonsList3, iPMode, iAS4IncomingMessageState, iCommonsList2, (ICommonsList<WSS4JAttachment>)commonsArrayList, (SPIInvocationResult)object2);
                if (object2.isFailure()) {
                    LOGGER.warn("Error invoking synchronous SPIs");
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Successfully invoked synchronous SPIs");
                }
                if (this.m_aSoapProcessingFinalizedCB != null) {
                    this.m_aSoapProcessingFinalizedCB.onProcessingFinalized(true);
                }
            } else {
                string = () -> this.lambda$_handleSoapMessage$1(httpHeaderMap, ebms3UserMessage, ebms3SignalMessage, node, iCommonsList3, iPMode, iAS4IncomingMessageState, eSoapVersion, pModeLeg, (ICommonsList)commonsArrayList, string2);
                object = PhotonWorkerPool.getInstance().runThrowing("phase4 async processing", (IThrowingRunnable)string);
                if (this.m_aSoapProcessingFinalizedCB != null) {
                    ((CompletableFuture)object).thenRun(() -> this.m_aSoapProcessingFinalizedCB.onProcessingFinalized(false));
                }
            }
        }
        if (iAS4IncomingMessageState.isSoapHeaderElementProcessingSuccessful() && iAS4IncomingMessageState.getEbmsError() != null) {
            string = null;
            object = null;
        } else if (iCommonsList2.isNotEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating AS4 error message with these " + iCommonsList2.size() + " errors: " + String.valueOf(iCommonsList2.getAllMapped(ebms3Error -> StringHelper.getConcatenatedOnDemand((String)ebms3Error.getDescriptionValue(), (String)" / ", (String)ebms3Error.getErrorDetail()))));
            }
            if (AS4RequestHandler._isSendErrorAsResponse(pModeLeg)) {
                string = MessageHelperMethods.createRandomMessageID();
                object = this._createResponseErrorMessage(iAS4IncomingMessageState, eSoapVersion, string, pModeLeg, iCommonsList2);
            } else {
                LOGGER.warn("Not sending back the AS4 Error response, because it is prohibited in the PMode");
                string = null;
                object = null;
            }
        } else if (ebms3SignalMessage != null && ebms3SignalMessage.getReceipt() != null) {
            string = null;
            object = null;
        } else if (iPMode.getMEP().isOneWay() || iPMode.getMEPBinding().isAsynchronous()) {
            if (iPMode.getMEPBinding().equals((Object)EMEPBinding.PULL) || iPMode.getMEPBinding().equals((Object)EMEPBinding.PULL_PUSH) && ((SPIInvocationResult)object2).hasPullReturnUserMsg() || iPMode.getMEPBinding().equals((Object)EMEPBinding.PUSH_PULL) && ((SPIInvocationResult)object2).hasPullReturnUserMsg()) {
                AS4UserMessage aS4UserMessage = new AS4UserMessage(eSoapVersion, ((SPIInvocationResult)object2).getPullReturnUserMsg());
                string = aS4UserMessage.getEbms3UserMessage().getMessageInfo().getMessageId();
                object = new AS4ResponseFactoryXML(this.m_aMessageMetadata, iAS4IncomingMessageState, string, aS4UserMessage.getAsSoapDocument(), eSoapVersion.getMimeType());
            } else if (ebms3UserMessage != null) {
                boolean bl2 = AS4RequestHandler._isSendReceiptAsResponse(pModeLeg);
                if (bl2) {
                    string = MessageHelperMethods.createRandomMessageID();
                    object = this._createResponseReceiptMessage(iAS4IncomingMessageState, document, eSoapVersion, string, pModeLeg, ebms3UserMessage, (ICommonsList<WSS4JAttachment>)commonsArrayList);
                } else {
                    LOGGER.info("Not sending back the Receipt response, because sending Receipt response is prohibited in PMode");
                    string = null;
                    object = null;
                }
            } else {
                string = null;
                object = null;
            }
        } else {
            PModeLeg pModeLeg2 = iPMode.getLeg2();
            if (pModeLeg2 == null) {
                throw new Phase4Exception("PMode has no leg2!");
            }
            if (MEPHelper.isValidResponseTypeLeg2(iPMode.getMEP(), iPMode.getMEPBinding(), EAS4MessageType.USER_MESSAGE)) {
                string = MessageHelperMethods.createRandomMessageID();
                AS4UserMessage aS4UserMessage = AS4RequestHandler._createReversedUserMessage(eSoapVersion, string, ebms3UserMessage, (ICommonsList<WSS4JAttachment>)commonsArrayList);
                AS4SigningParams aS4SigningParams = this.m_aIncomingSecurityConfig.getSigningParamsCloneOrNew().setFromPMode(pModeLeg2.getSecurity());
                String string4 = ebms3UserMessage.getPartyInfo().getTo().getPartyIdAtIndex(0).getValue();
                AS4CryptParams aS4CryptParams = this.m_aIncomingSecurityConfig.getCryptParamsCloneOrNew().setFromPMode(pModeLeg2.getSecurity()).setAlias(string4);
                object = this._createResponseUserMessage(iAS4IncomingMessageState, pModeLeg2.getProtocol().getSoapVersion(), aS4UserMessage, (ICommonsList<WSS4JAttachment>)commonsArrayList, aS4SigningParams, aS4CryptParams);
            } else {
                string = null;
                object = null;
            }
        }
        this._invokeSPIsForResponse(iAS4IncomingMessageState, (IAS4ResponseFactory)object, null, eSoapVersion.getMimeType(), string);
        return object;
    }

    public void handleRequest(@Nonnull @WillClose InputStream inputStream, @Nonnull HttpHeaderMap httpHeaderMap2, @Nonnull IAS4ResponseAbstraction iAS4ResponseAbstraction) throws Phase4Exception, IOException, MessagingException, WSSecurityException {
        AS4IncomingHandler.IAS4ParsedMessageCallback iAS4ParsedMessageCallback = (httpHeaderMap, document, eSoapVersion, iCommonsList) -> {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            IAS4ResponseFactory iAS4ResponseFactory = this._handleSoapMessage(httpHeaderMap, document, eSoapVersion, (ICommonsList<WSS4JAttachment>)iCommonsList, (ICommonsList<Ebms3Error>)commonsArrayList);
            if (iAS4ResponseFactory != null) {
                IAS4OutgoingDumper iAS4OutgoingDumper = this.m_aOutgoingDumper != null ? this.m_aOutgoingDumper : AS4DumpManager.getOutgoingDumper();
                iAS4ResponseFactory.applyToResponse(iAS4ResponseAbstraction, iAS4OutgoingDumper);
            } else {
                iAS4ResponseAbstraction.setStatus(204);
            }
            AS4HttpDebug.debug(() -> "RECEIVE-END with " + (iAS4ResponseFactory != null ? "EBMS message" : "no content"));
        };
        AS4IncomingHandler.parseAS4Message(this.m_aIncomingAttachmentFactory, this.m_aResHelper, this.m_aMessageMetadata, inputStream, httpHeaderMap2, iAS4ParsedMessageCallback, this.m_aIncomingDumper);
    }

    private /* synthetic */ void lambda$_handleSoapMessage$1(HttpHeaderMap httpHeaderMap, Ebms3UserMessage ebms3UserMessage, Ebms3SignalMessage ebms3SignalMessage, Node node, ICommonsList iCommonsList, IPMode iPMode, IAS4IncomingMessageState iAS4IncomingMessageState, ESoapVersion eSoapVersion, PModeLeg pModeLeg, ICommonsList iCommonsList2, String string) throws Exception {
        IAS4ResponseFactory iAS4ResponseFactory;
        Object object;
        Object object2;
        AS4SigningParams aS4SigningParams;
        Object object3;
        String string2;
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        CommonsArrayList commonsArrayList2 = new CommonsArrayList();
        SPIInvocationResult sPIInvocationResult = new SPIInvocationResult();
        this._invokeSPIsForIncoming(httpHeaderMap, ebms3UserMessage, ebms3SignalMessage, node, (ICommonsList<WSS4JAttachment>)iCommonsList, iPMode, iAS4IncomingMessageState, (ICommonsList<Ebms3Error>)commonsArrayList, (ICommonsList<WSS4JAttachment>)commonsArrayList2, sPIInvocationResult);
        if (sPIInvocationResult.isSuccess()) {
            assert (commonsArrayList.isEmpty());
            string2 = MessageHelperMethods.createRandomMessageID();
            object3 = AS4RequestHandler._createReversedUserMessage(eSoapVersion, string2, ebms3UserMessage, (ICommonsList<WSS4JAttachment>)commonsArrayList2);
            aS4SigningParams = this.m_aIncomingSecurityConfig.getSigningParamsCloneOrNew().setFromPMode(pModeLeg.getSecurity());
            object2 = ebms3UserMessage.getPartyInfo().getTo().getPartyIdAtIndex(0).getValue();
            object = this.m_aIncomingSecurityConfig.getCryptParamsCloneOrNew().setFromPMode(pModeLeg.getSecurity()).setAlias((String)object2);
            iAS4ResponseFactory = this._createResponseUserMessage(iAS4IncomingMessageState, pModeLeg.getProtocol().getSoapVersion(), (AS4UserMessage)object3, (ICommonsList<WSS4JAttachment>)iCommonsList2, aS4SigningParams, (AS4CryptParams)object);
        } else {
            object3 = AS4ErrorMessage.create(eSoapVersion, iAS4IncomingMessageState.getMessageID(), (ICommonsList<Ebms3Error>)commonsArrayList);
            string2 = ((AS4ErrorMessage)object3).getEbms3SignalMessage().getMessageInfo().getMessageId();
            if (this.m_aErrorConsumer != null && commonsArrayList.isNotEmpty()) {
                this.m_aErrorConsumer.onAS4ErrorMessage(iAS4IncomingMessageState, (ICommonsList<Ebms3Error>)commonsArrayList, (AS4ErrorMessage)object3);
            }
            iAS4ResponseFactory = new AS4ResponseFactoryXML(this.m_aMessageMetadata, iAS4IncomingMessageState, string2, object3.getAsSoapDocument(), eSoapVersion.getMimeType());
        }
        object3 = sPIInvocationResult.getAsyncResponseURL();
        if (StringHelper.isEmpty((String)object3)) {
            throw new IllegalStateException("No asynchronous response URL present - please check your SPI implementation");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Responding asynchronous to: " + (String)object3);
        }
        aS4SigningParams = iAS4ResponseFactory.getHttpEntityForSending(eSoapVersion.getMimeType());
        aS4SigningParams = this.m_aResHelper.createRepeatableHttpEntity((HttpEntity)aS4SigningParams);
        this._invokeSPIsForResponse(iAS4IncomingMessageState, iAS4ResponseFactory, (HttpEntity)aS4SigningParams, eSoapVersion.getMimeType(), string2);
        object = new BasicHttpPoster();
        HttpHeaderMap httpHeaderMap2 = null;
        HttpRetrySettings httpRetrySettings = new HttpRetrySettings();
        object2 = (Document)((BasicHttpPoster)object).sendGenericMessageWithRetries((String)object3, httpHeaderMap2, (HttpEntity)aS4SigningParams, string, httpRetrySettings, new ResponseHandlerXml(), this.m_aOutgoingDumper, this.m_aRetryCallback);
        AS4HttpDebug.debug(() -> AS4RequestHandler.lambda$_handleSoapMessage$0((Document)object2));
    }

    private static /* synthetic */ String lambda$_handleSoapMessage$0(Document document) {
        return "SEND-RESPONSE [async sent] received: " + (document == null ? "null" : XMLWriter.getNodeAsString((Node)document, (IXMLWriterSettings)AS4HttpDebug.getDebugXMLWriterSettings()));
    }

    private static final class SPIInvocationResult
    implements ISuccessIndicator {
        private boolean m_bSuccess = false;
        private Ebms3UserMessage m_aPullReturnUserMsg;
        private String m_sAsyncResponseURL;

        private SPIInvocationResult() {
        }

        public boolean isSuccess() {
            return this.m_bSuccess;
        }

        void setSuccess(boolean bl) {
            this.m_bSuccess = bl;
        }

        void setPullReturnUserMsg(@Nonnull Ebms3UserMessage ebms3UserMessage) {
            this.m_aPullReturnUserMsg = ebms3UserMessage;
        }

        @Nullable
        public Ebms3UserMessage getPullReturnUserMsg() {
            return this.m_aPullReturnUserMsg;
        }

        public boolean hasPullReturnUserMsg() {
            return this.m_aPullReturnUserMsg != null;
        }

        void setAsyncResponseURL(@Nonnull String string) {
            this.m_sAsyncResponseURL = string;
        }

        @Nullable
        public String getAsyncResponseURL() {
            return this.m_sAsyncResponseURL;
        }

        public boolean hasAsyncResponseURL() {
            return StringHelper.isNotEmpty((String)this.m_sAsyncResponseURL);
        }
    }

    private static interface IAS4ResponseFactory {
        @Nonnull
        public HttpEntity getHttpEntityForSending(@Nonnull IMimeType var1);

        public void applyToResponse(@Nonnull IAS4ResponseAbstraction var1, @Nullable IAS4OutgoingDumper var2);
    }

    private static final class AS4ResponseFactoryXML
    implements IAS4ResponseFactory {
        private final IAS4IncomingMessageMetadata m_aIncomingMessageMetadata;
        private final IAS4IncomingMessageState m_aIncomingState;
        private final String m_sResponseMessageID;
        private final Document m_aDoc;
        private final IMimeType m_aMimeType;

        public AS4ResponseFactoryXML(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull IAS4IncomingMessageState iAS4IncomingMessageState, @Nonnull @Nonempty String string, @Nonnull Document document, @Nonnull IMimeType iMimeType) {
            ValueEnforcer.notNull((Object)iAS4IncomingMessageMetadata, (String)"IncomingMessageMetadata");
            ValueEnforcer.notNull((Object)iAS4IncomingMessageState, (String)"IncomingState");
            ValueEnforcer.notEmpty((CharSequence)string, (String)"ResponseMessageID");
            ValueEnforcer.notNull((Object)document, (String)"Doc");
            ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
            this.m_aIncomingMessageMetadata = iAS4IncomingMessageMetadata;
            this.m_aIncomingState = iAS4IncomingMessageState;
            this.m_sResponseMessageID = string;
            this.m_aDoc = document;
            this.m_aMimeType = iMimeType;
        }

        @Override
        @Nonnull
        public HttpEntity getHttpEntityForSending(@Nonnull IMimeType iMimeType) {
            return new HttpXMLEntity(this.m_aDoc, this.m_aMimeType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void applyToResponse(@Nonnull IAS4ResponseAbstraction iAS4ResponseAbstraction, @Nullable IAS4OutgoingDumper iAS4OutgoingDumper) {
            block6: {
                String string = AS4XMLHelper.serializeXML(this.m_aDoc);
                Charset charset = AS4XMLHelper.XWS.getCharset();
                byte[] byArray = string.getBytes(charset);
                iAS4ResponseAbstraction.setContent(byArray, charset);
                iAS4ResponseAbstraction.setMimeType(this.m_aMimeType);
                if (iAS4OutgoingDumper != null) {
                    try {
                        OutputStream outputStream = iAS4OutgoingDumper.onBeginRequest(EAS4MessageMode.RESPONSE, this.m_aIncomingMessageMetadata, this.m_aIncomingState, this.m_sResponseMessageID, null, 0);
                        if (outputStream == null) break block6;
                        try {
                            outputStream.write(byArray);
                        }
                        finally {
                            StreamHelper.close((AutoCloseable)outputStream);
                            iAS4OutgoingDumper.onEndRequest(EAS4MessageMode.RESPONSE, this.m_aIncomingMessageMetadata, this.m_aIncomingState, this.m_sResponseMessageID, null);
                        }
                    }
                    catch (IOException iOException) {
                        LOGGER.warn("IOException in dumping of outgoing XML response", (Throwable)iOException);
                    }
                }
            }
        }
    }

    private static final class AS4ResponseFactoryMIME
    implements IAS4ResponseFactory {
        private final IAS4IncomingMessageMetadata m_aIncomingMessageMetadata;
        private final IAS4IncomingMessageState m_aIncomingState;
        private final String m_sResponseMessageID;
        private final AS4MimeMessage m_aMimeMsg;
        private final HttpHeaderMap m_aHttpHeaders;

        public AS4ResponseFactoryMIME(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull IAS4IncomingMessageState iAS4IncomingMessageState, @Nonnull @Nonempty String string, @Nonnull AS4MimeMessage aS4MimeMessage) throws MessagingException {
            ValueEnforcer.notNull((Object)iAS4IncomingMessageMetadata, (String)"IncomingMessageMetadata");
            ValueEnforcer.notNull((Object)iAS4IncomingMessageState, (String)"IncomingState");
            ValueEnforcer.notEmpty((CharSequence)string, (String)"ResponseMessageID");
            ValueEnforcer.notNull((Object)((Object)aS4MimeMessage), (String)"MimeMsg");
            this.m_aIncomingMessageMetadata = iAS4IncomingMessageMetadata;
            this.m_aIncomingState = iAS4IncomingMessageState;
            this.m_sResponseMessageID = string;
            this.m_aMimeMsg = aS4MimeMessage;
            this.m_aHttpHeaders = AS4MimeMessageHelper.getAndRemoveAllHeaders(this.m_aMimeMsg);
            if (!aS4MimeMessage.isRepeatable()) {
                LOGGER.warn("The response MIME message is not repeatable");
            }
        }

        @Nonnull
        public HttpMimeMessageEntity getHttpEntityForSending(@Nonnull IMimeType iMimeType) {
            return HttpMimeMessageEntity.create(this.m_aMimeMsg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void applyToResponse(@Nonnull IAS4ResponseAbstraction iAS4ResponseAbstraction, @Nullable IAS4OutgoingDumper iAS4OutgoingDumper) {
            block6: {
                HasInputStream hasInputStream = HasInputStream.multiple(() -> {
                    try {
                        return this.m_aMimeMsg.getInputStream();
                    }
                    catch (MessagingException | IOException throwable) {
                        throw new IllegalStateException("Failed to get MIME input stream", throwable);
                    }
                });
                iAS4ResponseAbstraction.setContent(this.m_aHttpHeaders, (IHasInputStream)hasInputStream);
                String string = this.m_aHttpHeaders.getFirstHeaderValue("Content-Type");
                MimeType mimeType = MimeTypeParser.safeParseMimeType((String)string);
                iAS4ResponseAbstraction.setMimeType((IMimeType)(mimeType != null ? mimeType : MT_MULTIPART_RELATED));
                if (iAS4OutgoingDumper != null) {
                    try {
                        OutputStream outputStream = iAS4OutgoingDumper.onBeginRequest(EAS4MessageMode.RESPONSE, this.m_aIncomingMessageMetadata, this.m_aIncomingState, this.m_sResponseMessageID, this.m_aHttpHeaders, 0);
                        if (outputStream == null) break block6;
                        try {
                            StreamHelper.copyByteStream().from(hasInputStream.getBufferedInputStream()).closeFrom(true).to(outputStream).closeTo(true).build();
                        }
                        finally {
                            iAS4OutgoingDumper.onEndRequest(EAS4MessageMode.RESPONSE, this.m_aIncomingMessageMetadata, this.m_aIncomingState, this.m_sResponseMessageID, null);
                        }
                    }
                    catch (IOException iOException) {
                        LOGGER.warn("IOException in dumping of outgoing MIME response", (Throwable)iOException);
                    }
                }
            }
        }
    }
}

