/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.incoming;

import com.helger.annotation.WillClose;
import com.helger.annotation.WillNotClose;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.io.stream.HasInputStream;
import com.helger.base.spi.ServiceLoaderHelper;
import com.helger.base.state.ESuccess;
import com.helger.base.string.StringHelper;
import com.helger.base.wrapper.Wrapper;
import com.helger.collection.CollectionFind;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.list.ErrorList;
import com.helger.http.header.HttpHeaderMap;
import com.helger.mime.IMimeType;
import com.helger.mime.MimeType;
import com.helger.mime.parse.MimeTypeParser;
import com.helger.phase4.attachment.AS4DecompressException;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.attachment.IAS4IncomingAttachmentFactory;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.dump.AS4DumpManager;
import com.helger.phase4.dump.IAS4IncomingDumper;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3PartInfo;
import com.helger.phase4.ebms3header.Ebms3Property;
import com.helger.phase4.ebms3header.Ebms3PullRequest;
import com.helger.phase4.ebms3header.Ebms3Receipt;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.incoming.AS4IncomingMessageState;
import com.helger.phase4.incoming.AS4RequestHandler;
import com.helger.phase4.incoming.IAS4IncomingMessageMetadata;
import com.helger.phase4.incoming.IAS4IncomingMessageState;
import com.helger.phase4.incoming.IAS4IncomingProfileSelector;
import com.helger.phase4.incoming.IAS4IncomingReceiverConfiguration;
import com.helger.phase4.incoming.IAS4SignalMessageConsumer;
import com.helger.phase4.incoming.IAS4UserMessageConsumer;
import com.helger.phase4.incoming.crypto.IAS4IncomingSecurityConfiguration;
import com.helger.phase4.incoming.soap.AS4SingleSoapHeader;
import com.helger.phase4.incoming.soap.ISoapHeaderElementProcessor;
import com.helger.phase4.incoming.soap.SoapHeaderElementProcessorRegistry;
import com.helger.phase4.incoming.spi.IAS4IncomingMessageProcessingStatusSPI;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.AS4Helper;
import com.helger.phase4.model.ESoapVersion;
import com.helger.phase4.model.error.EEbmsError;
import com.helger.phase4.model.message.MessageHelperMethods;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.model.pmode.resolve.IAS4PModeResolver;
import com.helger.phase4.profile.IAS4Profile;
import com.helger.phase4.profile.IAS4ProfileValidator;
import com.helger.phase4.util.AS4ResourceHelper;
import com.helger.phase4.util.AS4XMLHelper;
import com.helger.phase4.util.Phase4Exception;
import com.helger.web.multipart.MultipartProgressNotifier;
import com.helger.web.multipart.MultipartStream;
import com.helger.xml.ChildElementIterator;
import com.helger.xml.XMLHelper;
import com.helger.xml.sax.WrappedCollectingSAXErrorHandler;
import com.helger.xml.serialize.read.DOMReader;
import com.helger.xml.serialize.read.DOMReaderSettings;
import com.helger.xml.serialize.read.IDOMReaderSettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;

public final class AS4IncomingHandler {
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(AS4IncomingHandler.class);

    private AS4IncomingHandler() {
    }

    public static void parseAS4Message(@Nonnull IAS4IncomingAttachmentFactory iAS4IncomingAttachmentFactory, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, @Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull @WillClose InputStream inputStream, @Nonnull HttpHeaderMap httpHeaderMap, @Nonnull IAS4ParsedMessageCallback iAS4ParsedMessageCallback, @Nullable IAS4IncomingDumper iAS4IncomingDumper) throws Phase4Exception, IOException, MessagingException, WSSecurityException {
        ValueEnforcer.notNull((Object)iAS4IncomingAttachmentFactory, (String)"IncomingAttachmentFactory");
        ValueEnforcer.notNull((Object)aS4ResourceHelper, (String)"ResHelper");
        ValueEnforcer.notNull((Object)iAS4IncomingMessageMetadata, (String)"IncomingMessageMetadata");
        ValueEnforcer.notNull((Object)inputStream, (String)"PayloadIS");
        ValueEnforcer.notNull((Object)httpHeaderMap, (String)"aHttpHeaders");
        ValueEnforcer.notNull((Object)iAS4ParsedMessageCallback, (String)"Callback");
        LOGGER.info("phase4 --- parsemessage:start");
        String string = httpHeaderMap.getFirstHeaderValue("Content-Type");
        if (StringHelper.isEmpty((String)string)) {
            throw new Phase4Exception("Content-Type header is missing").setRetryFeasible(false);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received Content-Type string: '" + string + "'");
        }
        MimeType mimeType = MimeTypeParser.safeParseMimeType((String)string);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received Content-Type object: " + String.valueOf(mimeType));
        }
        if (mimeType == null) {
            throw new Phase4Exception("Failed to parse Content-Type '" + string + "'").setRetryFeasible(false);
        }
        IMimeType iMimeType = mimeType.getCopyWithoutParameters();
        IAS4IncomingDumper iAS4IncomingDumper2 = iAS4IncomingDumper != null ? iAS4IncomingDumper : AS4DumpManager.getIncomingDumper();
        Document document = null;
        ESoapVersion eSoapVersion = null;
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        Wrapper wrapper = new Wrapper();
        Throwable throwable = null;
        List list = ServiceLoaderHelper.getAllSPIImplementations(IAS4IncomingMessageProcessingStatusSPI.class);
        for (Object object2 : list) {
            try {
                object2.onMessageProcessingStarted(iAS4IncomingMessageMetadata);
            }
            catch (Exception exception) {
                LOGGER.error("IAS4IncomingMessageProcessingStatusSPI.onMessageProcessingStarted failed. SPI=" + String.valueOf(object2) + "; MessageMetadata=" + String.valueOf(iAS4IncomingMessageMetadata), (Throwable)exception);
            }
        }
        try {
            MultipartStream multipartStream;
            Object object;
            Object object2;
            ErrorList errorList = new ErrorList();
            if (iMimeType.equals((Object)AS4RequestHandler.MT_MULTIPART_RELATED)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received MIME message");
                }
                if (StringHelper.isEmpty((String)(object2 = mimeType.getParameterValueWithName("boundary")))) {
                    throw new Phase4Exception("Content-Type '" + string + "' misses 'boundary' parameter").setRetryFeasible(false);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("MIME Boundary: '" + (String)object2 + "'");
                }
                object = AS4DumpManager.getIncomingDumpAwareInputStream(iAS4IncomingDumper2, inputStream, iAS4IncomingMessageMetadata, httpHeaderMap, (Wrapper<OutputStream>)wrapper);
                try {
                    multipartStream = new MultipartStream((InputStream)object, ((String)object2).getBytes(StandardCharsets.ISO_8859_1), (MultipartProgressNotifier)null);
                    int n = 0;
                    while (true) {
                        boolean bl;
                        boolean bl2 = bl = n == 0 ? multipartStream.skipPreamble() : multipartStream.readBoundary();
                        if (!bl) {
                            break;
                        }
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Found MIME part #" + n);
                        }
                        try (MultipartStream.MultipartItemInputStream multipartItemInputStream = multipartStream.createInputStream();){
                            MimeBodyPart mimeBodyPart = new MimeBodyPart((InputStream)multipartItemInputStream);
                            if (n == 0) {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Parsing first MIME part as SOAP document");
                                }
                                document = DOMReader.readXMLDOM((InputStream)mimeBodyPart.getInputStream(), (IDOMReaderSettings)new DOMReaderSettings().setErrorHandler((ErrorHandler)new WrappedCollectingSAXErrorHandler(errorList)));
                                var25_32 = MimeTypeParser.safeParseMimeType((String)mimeBodyPart.getContentType());
                                if (var25_32 != null) {
                                    var25_32 = var25_32.getCopyWithoutParameters();
                                }
                                if ((eSoapVersion = ESoapVersion.getFromMimeTypeOrNull((IMimeType)var25_32)) != null && LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Determined SOAP version " + String.valueOf((Object)eSoapVersion) + " from Content-Type");
                                }
                                if (eSoapVersion == null && document != null && (eSoapVersion = ESoapVersion.getFromNamespaceURIOrNull(XMLHelper.getNamespaceURI((Node)document))) != null && LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Determined SOAP version " + String.valueOf((Object)eSoapVersion) + " from XML root element namespace URI");
                                }
                            } else {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Parsing MIME part #" + n + " as attachment");
                                }
                                var25_32 = iAS4IncomingAttachmentFactory.createAttachment(mimeBodyPart, aS4ResourceHelper);
                                commonsArrayList.add((Object)var25_32);
                            }
                        }
                        ++n;
                    }
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Read MIME message with " + commonsArrayList.size() + " attachment(s)");
                }
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received plain message");
                }
                document = DOMReader.readXMLDOM((InputStream)AS4DumpManager.getIncomingDumpAwareInputStream(iAS4IncomingDumper2, inputStream, iAS4IncomingMessageMetadata, httpHeaderMap, (Wrapper<OutputStream>)wrapper), (IDOMReaderSettings)new DOMReaderSettings().setErrorHandler((ErrorHandler)new WrappedCollectingSAXErrorHandler(errorList)));
                if (LOGGER.isDebugEnabled()) {
                    if (document != null) {
                        LOGGER.debug("Successfully parsed payload as XML");
                    } else {
                        LOGGER.debug("Failed to parse payload as XML");
                    }
                }
                if (document != null) {
                    object2 = XMLHelper.getNamespaceURI((Node)document);
                    eSoapVersion = ESoapVersion.getFromNamespaceURIOrNull((String)object2);
                    if (eSoapVersion != null) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Determined SOAP version " + String.valueOf((Object)eSoapVersion) + " from XML root element namespace URI '" + (String)object2 + "'");
                        }
                    } else {
                        LOGGER.warn("Failed to determine SOAP version from XML root element namespace URI '" + (String)object2 + "'");
                    }
                }
                if (eSoapVersion == null) {
                    eSoapVersion = ESoapVersion.getFromMimeTypeOrNull(iMimeType);
                    if (eSoapVersion != null) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Determined SOAP version " + String.valueOf((Object)eSoapVersion) + " from Content-Type '" + iMimeType.getAsString() + "'");
                        }
                    } else {
                        LOGGER.warn("Failed to determine SOAP version from Content-Type '" + iMimeType.getAsString() + "'");
                    }
                }
            }
            if (document == null || errorList.containsAtLeastOneError()) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append((String)(eSoapVersion == null ? "Failed to parse incoming message!" : "Failed to parse incoming SOAP " + eSoapVersion.getVersion() + " document!"));
                if (errorList.isNotEmpty()) {
                    ((StringBuilder)object2).append(" Technical details:");
                    object = errorList.iterator();
                    while (object.hasNext()) {
                        multipartStream = (IError)object.next();
                        ((StringBuilder)object2).append('\n').append(multipartStream.getAsStringLocaleIndepdent());
                    }
                }
                throw new Phase4Exception(((StringBuilder)object2).toString()).setRetryFeasible(false);
            }
            if (eSoapVersion == null) {
                throw new Phase4Exception("Failed to determine SOAP version of XML document!").setRetryFeasible(false);
            }
            iAS4ParsedMessageCallback.handle(httpHeaderMap, document, eSoapVersion, (ICommonsList<WSS4JAttachment>)commonsArrayList);
        }
        catch (Phase4Exception | MessagingException | IOException | WSSecurityException throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (iAS4IncomingDumper2 != null && wrapper.isSet()) {
                try {
                    iAS4IncomingDumper2.onEndRequest(iAS4IncomingMessageMetadata, (Exception)throwable);
                }
                catch (Exception exception) {
                    LOGGER.error("IncomingDumper.onEndRequest failed. Dumper=" + String.valueOf(iAS4IncomingDumper2) + "; MessageMetadata=" + String.valueOf(iAS4IncomingMessageMetadata), (Throwable)exception);
                }
            }
            for (IAS4IncomingMessageProcessingStatusSPI iAS4IncomingMessageProcessingStatusSPI : list) {
                try {
                    iAS4IncomingMessageProcessingStatusSPI.onMessageProcessingEnded(iAS4IncomingMessageMetadata, (Exception)throwable);
                }
                catch (Exception exception) {
                    LOGGER.error("IAS4IncomingMessageProcessingStatusSPI.onMessageProcessingEnded failed. SPI=" + String.valueOf(iAS4IncomingMessageProcessingStatusSPI) + "; MessageMetadata=" + String.valueOf(iAS4IncomingMessageMetadata), (Throwable)exception);
                }
            }
            LOGGER.info("phase4 --- parsemessage:end");
        }
    }

    private static void _processSoapHeaderElements(@Nonnull SoapHeaderElementProcessorRegistry soapHeaderElementProcessorRegistry, @Nonnull Document document, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4IncomingMessageState aS4IncomingMessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList2) throws Phase4Exception {
        Object object;
        QName qName;
        ESoapVersion eSoapVersion = aS4IncomingMessageState.getSoapVersion();
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        ICommonsOrderedMap<QName, ISoapHeaderElementProcessor> iCommonsOrderedMap = XMLHelper.getFirstChildElementOfName((Node)document.getDocumentElement(), (String)eSoapVersion.getNamespaceURI(), (String)eSoapVersion.getHeaderElementName());
        if (iCommonsOrderedMap == null) {
            throw new Phase4Exception("SOAP document is missing a Header element {" + eSoapVersion.getNamespaceURI() + "}" + eSoapVersion.getHeaderElementName()).setRetryFeasible(false);
        }
        for (Object object2 : new ChildElementIterator((Node)iCommonsOrderedMap)) {
            qName = XMLHelper.getQName((Element)object2);
            object = object2.getAttributeNS(eSoapVersion.getNamespaceURI(), "mustUnderstand");
            boolean bl = eSoapVersion.getMustUnderstandValue(true).equals(object);
            commonsArrayList.add((Object)new AS4SingleSoapHeader((Element)object2, qName, bl));
        }
        iCommonsOrderedMap = soapHeaderElementProcessorRegistry.getAllElementProcessors();
        if (iCommonsOrderedMap.isEmpty()) {
            LOGGER.error("No SOAP Header element processor is registered");
        }
        for (Object object2 : iCommonsOrderedMap.entrySet()) {
            qName = (QName)object2.getKey();
            object = (AS4SingleSoapHeader)commonsArrayList.findFirst(aS4SingleSoapHeader -> qName.equals(aS4SingleSoapHeader.getQName()));
            if (object == null) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Message contains no SOAP header element with QName " + qName.toString());
                continue;
            }
            ISoapHeaderElementProcessor iSoapHeaderElementProcessor = (ISoapHeaderElementProcessor)object2.getValue();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Processing SOAP header element " + qName.toString() + " with processor " + String.valueOf(iSoapHeaderElementProcessor));
            }
            CommonsArrayList commonsArrayList2 = new CommonsArrayList();
            try {
                if (iSoapHeaderElementProcessor.processHeaderElement(document, ((AS4SingleSoapHeader)object).getNode(), iCommonsList, aS4IncomingMessageState, (ICommonsList<Ebms3Error>)commonsArrayList2).isSuccess()) {
                    ((AS4SingleSoapHeader)object).setProcessed(true);
                    continue;
                }
                LOGGER.error("Failed to process SOAP header element " + qName.toString() + " with processor " + String.valueOf(iSoapHeaderElementProcessor) + "; error details: " + String.valueOf(commonsArrayList2));
                iCommonsList2.addAll((Collection)commonsArrayList2);
            }
            catch (Exception exception) {
                String string = "Error processing SOAP header element " + qName.toString() + " with processor " + String.valueOf(iSoapHeaderElementProcessor);
                LOGGER.error(string, (Throwable)exception);
                iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.errorBuilder(aS4IncomingMessageState.getLocale()).refToMessageInError(aS4IncomingMessageState.getMessageID()).errorDetail(string, exception).build());
            }
            break;
        }
        if (iCommonsList2.isEmpty()) {
            for (Object object2 : commonsArrayList) {
                if (!((AS4SingleSoapHeader)object2).isMustUnderstand() || ((AS4SingleSoapHeader)object2).isProcessed()) continue;
                throw new Phase4Exception("Required SOAP header element " + ((AS4SingleSoapHeader)object2).getQName().toString() + " could not be handled").setRetryFeasible(false);
            }
        }
    }

    private static void _decompressAttachments(@Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull IAS4IncomingMessageState iAS4IncomingMessageState) {
        for (WSS4JAttachment wSS4JAttachment : (ICommonsList)iCommonsList.getClone()) {
            Ebms3Property ebms3Property2;
            EAS4CompressionMode eAS4CompressionMode = iAS4IncomingMessageState.getAttachmentCompressionMode(wSS4JAttachment.getId());
            if (eAS4CompressionMode == null) continue;
            IHasInputStream iHasInputStream = wSS4JAttachment.getInputStreamProvider();
            wSS4JAttachment.setSourceStreamProvider((IHasInputStream)new HasInputStream(() -> {
                try {
                    InputStream inputStream = iHasInputStream.getInputStream();
                    if (inputStream == null) {
                        throw new IllegalStateException("Failed to create InputStream from " + String.valueOf(iHasInputStream));
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Decompressing attachment with ID '" + wSS4JAttachment.getId() + "' using " + String.valueOf((Object)eAS4CompressionMode));
                    }
                    return eAS4CompressionMode.getDecompressStream(inputStream);
                }
                catch (IOException iOException) {
                    throw new AS4DecompressException(iOException);
                }
            }, iHasInputStream.isReadMultiple()));
            wSS4JAttachment.setCompressionMode(eAS4CompressionMode);
            String string = StringHelper.trimStart((String)wSS4JAttachment.getId(), (String)"attachment=");
            Ebms3PartInfo ebms3PartInfo2 = (Ebms3PartInfo)CollectionFind.findFirst(ebms3UserMessage.getPayloadInfo().getPartInfo(), ebms3PartInfo -> ebms3PartInfo.getHref() != null && (ebms3PartInfo.getHref().equals(string) || ebms3PartInfo.getHref().equals(MessageHelperMethods.PREFIX_CID + string)));
            if (ebms3PartInfo2 == null || ebms3PartInfo2.getPartProperties() == null || (ebms3Property2 = (Ebms3Property)CollectionFind.findFirst(ebms3PartInfo2.getPartProperties().getProperty(), ebms3Property -> ebms3Property.getName().equalsIgnoreCase("MimeType"))) == null) continue;
            String string2 = ebms3Property2.getValue();
            if (MimeTypeParser.safeParseMimeType((String)string2) == null) {
                LOGGER.warn("Value '" + string2 + "' of property 'MimeType' is not a valid MIME type");
            }
            wSS4JAttachment.overwriteMimeType(string2);
        }
    }

    @Nonnull
    public static IAS4IncomingMessageState processEbmsMessage(@Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, @Nonnull Locale locale, @Nonnull SoapHeaderElementProcessorRegistry soapHeaderElementProcessorRegistry, @Nonnull HttpHeaderMap httpHeaderMap, @Nonnull Document document, @Nonnull ESoapVersion eSoapVersion, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull IAS4IncomingProfileSelector iAS4IncomingProfileSelector, @Nonnull ICommonsList<Ebms3Error> iCommonsList2, @Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata) throws Phase4Exception {
        ValueEnforcer.notNull((Object)aS4ResourceHelper, (String)"ResHelper");
        ValueEnforcer.notNull((Object)locale, (String)"Locale");
        ValueEnforcer.notNull((Object)httpHeaderMap, (String)"HttpHeaders");
        ValueEnforcer.notNull((Object)document, (String)"SoapDocument");
        ValueEnforcer.notNull((Object)((Object)eSoapVersion), (String)"SoapVersion");
        ValueEnforcer.notNull(iCommonsList, (String)"IncomingAttachments");
        ValueEnforcer.notNull((Object)iAS4IncomingProfileSelector, (String)"AS4ProfileSelector");
        ValueEnforcer.notNull(iCommonsList2, (String)"EbmsErrorMessagesTarget");
        ValueEnforcer.notNull((Object)iAS4IncomingMessageMetadata, (String)"MessageMetadata");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received the following SOAP " + eSoapVersion.getVersion() + " document:");
            LOGGER.debug(AS4XMLHelper.serializeXML(document));
            if (iCommonsList.isEmpty()) {
                LOGGER.debug("Without any incoming attachments");
            } else {
                LOGGER.debug("Including the following " + iCommonsList.size() + " attachments:");
                LOGGER.debug(iCommonsList.toString());
            }
        }
        AS4IncomingMessageState aS4IncomingMessageState = new AS4IncomingMessageState(eSoapVersion, aS4ResourceHelper, locale);
        AS4IncomingHandler._processSoapHeaderElements(soapHeaderElementProcessorRegistry, document, iCommonsList, aS4IncomingMessageState, iCommonsList2);
        boolean bl = iCommonsList2.isEmpty();
        aS4IncomingMessageState.setSoapHeaderElementProcessingSuccessful(bl);
        if (bl) {
            Document document2;
            IAS4ProfileValidator iAS4ProfileValidator;
            IAS4Profile iAS4Profile;
            Object object;
            Ebms3Receipt ebms3Receipt;
            Ebms3PullRequest ebms3PullRequest;
            Ebms3UserMessage ebms3UserMessage = aS4IncomingMessageState.getEbmsUserMessage();
            Ebms3SignalMessage ebms3SignalMessage = aS4IncomingMessageState.getEbmsSignalMessage();
            Ebms3Error ebms3Error = aS4IncomingMessageState.getEbmsError();
            int n = (ebms3UserMessage != null ? 1 : 0) + ((ebms3PullRequest = aS4IncomingMessageState.getEbmsPullRequest()) != null ? 1 : 0) + ((ebms3Receipt = aS4IncomingMessageState.getEbmsReceipt()) != null ? 1 : 0) + (ebms3Error != null ? 1 : 0);
            if (n != 1) {
                object = "Expected a UserMessage(" + (ebms3UserMessage != null ? 1 : 0) + "), a PullRequest(" + (ebms3PullRequest != null ? 1 : 0) + "), a Receipt(" + (ebms3Receipt != null ? 1 : 0) + ") or an Error(" + (ebms3Error != null ? 1 : 0) + ")";
                LOGGER.error((String)object);
                iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_NOT_RECOGNIZED.errorBuilder(locale).refToMessageInError(aS4IncomingMessageState.getMessageID()).errorDetail((String)object).build());
            }
            object = iAS4IncomingProfileSelector.getAS4ProfileID(aS4IncomingMessageState);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Determined AS4 profile ID '" + (String)object + "' for current message");
            }
            IPMode iPMode = aS4IncomingMessageState.getPMode();
            PModeLeg pModeLeg = aS4IncomingMessageState.getEffectivePModeLeg();
            if (StringHelper.isNotEmpty((String)object)) {
                iAS4Profile = MetaAS4Manager.getProfileMgr().getProfileOfID((String)object);
                if (iAS4Profile == null) {
                    throw new IllegalStateException("The configured AS4 profile '" + (String)object + "' does not exist.");
                }
                aS4IncomingMessageState.setAS4Profile(iAS4Profile);
                iAS4ProfileValidator = iAS4Profile.getValidator();
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("AS4 state contains no AS4 profile ID - therefore no consistency checks are performed");
                }
                iAS4Profile = null;
                iAS4ProfileValidator = null;
            }
            if (ebms3UserMessage != null) {
                if (iPMode == null) {
                    throw new Phase4Exception("No AS4 P-Mode configuration found for UserMessage!");
                }
                if (pModeLeg == null) {
                    throw new Phase4Exception("No AS4 P-Mode leg could be determined!");
                }
                if (iAS4ProfileValidator != null) {
                    if (iAS4IncomingProfileSelector.validateAgainstProfile()) {
                        var23_23 = new ErrorList();
                        iAS4ProfileValidator.validatePMode(iPMode, var23_23, IAS4ProfileValidator.EAS4ProfileValidationMode.USER_MESSAGE);
                        iAS4ProfileValidator.validateUserMessage(ebms3UserMessage, var23_23);
                        iAS4ProfileValidator.validateInitiatorIdentity(ebms3UserMessage, aS4IncomingMessageState.getSigningCertificate(), iAS4IncomingMessageMetadata, var23_23);
                        if (var23_23.containsAtLeastOneError()) {
                            LOGGER.error("Error validating incoming AS4 UserMessage with the profile '" + iAS4Profile.getDisplayName() + "'");
                            for (IError iError : var23_23) {
                                String string = iError.getAsString(locale);
                                if (iError.isError()) {
                                    LOGGER.error(string);
                                    iCommonsList2.add((Object)EEbmsError.EBMS_PROCESSING_MODE_MISMATCH.errorBuilder(locale).refToMessageInError(aS4IncomingMessageState.getMessageID()).errorDetail(string, iError.getLinkedException()).build());
                                    continue;
                                }
                                LOGGER.warn(string);
                            }
                            return aS4IncomingMessageState;
                        }
                    } else {
                        LOGGER.warn("The AS4 profile '" + (String)object + "' has a validation configured, but the usage was disabled using the IAS4IncomingProfileSelector");
                    }
                }
                var23_23 = aS4IncomingMessageState.hasDecryptedAttachments() ? aS4IncomingMessageState.getDecryptedAttachments() : aS4IncomingMessageState.getOriginalAttachments();
                AS4IncomingHandler._decompressAttachments((ICommonsList<WSS4JAttachment>)var23_23, ebms3UserMessage, aS4IncomingMessageState);
            } else {
                if (ebms3PullRequest != null && iPMode == null) {
                    throw new Phase4Exception("No AS4 P-Mode configuration found for PullRequest!");
                }
                if (iAS4ProfileValidator != null) {
                    if (iAS4IncomingProfileSelector.validateAgainstProfile()) {
                        var23_23 = new ErrorList();
                        if (iPMode != null) {
                            iAS4ProfileValidator.validatePMode(iPMode, var23_23, IAS4ProfileValidator.EAS4ProfileValidationMode.SIGNAL_MESSAGE);
                        }
                        iAS4ProfileValidator.validateSignalMessage(ebms3SignalMessage, var23_23);
                        if (var23_23.containsAtLeastOneError()) {
                            LOGGER.error("Error validating incoming AS4 SignalMessage with the profile '" + iAS4Profile.getDisplayName() + "'");
                            for (IError iError : var23_23) {
                                String string = iError.getAsString(locale);
                                if (iError.isError()) {
                                    LOGGER.error(string);
                                    iCommonsList2.add((Object)EEbmsError.EBMS_PROCESSING_MODE_MISMATCH.errorBuilder(locale).refToMessageInError(aS4IncomingMessageState.getMessageID()).errorDetail(string).build());
                                    continue;
                                }
                                LOGGER.warn(string);
                            }
                            return aS4IncomingMessageState;
                        }
                    } else {
                        LOGGER.warn("The AS4 profile '" + (String)object + "' has a validation configured, but the usage was disabled using the AS4ProfileSelector");
                    }
                }
            }
            boolean bl2 = aS4IncomingMessageState.hasDecryptedSoapDocument();
            Document document3 = document2 = bl2 ? aS4IncomingMessageState.getDecryptedSoapDocument() : document;
            assert (document2 != null);
            Element element = XMLHelper.getFirstChildElementOfName((Node)document2.getDocumentElement(), (String)eSoapVersion.getNamespaceURI(), (String)eSoapVersion.getBodyElementName());
            if (element == null) {
                throw new Phase4Exception((bl2 ? "Decrypted" : "Original") + " SOAP document is missing a Body element").setRetryFeasible(false);
            }
            aS4IncomingMessageState.setSoapBodyPayloadNode(element.getFirstChild());
            boolean bl3 = AS4Helper.isPingMessage(iPMode);
            aS4IncomingMessageState.setPingMessage(bl3);
        }
        return aS4IncomingMessageState;
    }

    @Nullable
    private static IAS4IncomingMessageState _parseMessage(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull IAS4CryptoFactory iAS4CryptoFactory2, @Nonnull IAS4PModeResolver iAS4PModeResolver, @Nonnull IAS4IncomingAttachmentFactory iAS4IncomingAttachmentFactory, @Nonnull IAS4IncomingProfileSelector iAS4IncomingProfileSelector, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, @Nullable IPMode iPMode, @Nonnull Locale locale, @Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpResponse httpResponse, @Nonnull byte[] byArray, @Nullable IAS4IncomingDumper iAS4IncomingDumper, @Nonnull IAS4IncomingSecurityConfiguration iAS4IncomingSecurityConfiguration, @Nonnull IAS4IncomingReceiverConfiguration iAS4IncomingReceiverConfiguration) throws Phase4Exception {
        Wrapper wrapper = new Wrapper();
        IAS4ParsedMessageCallback iAS4ParsedMessageCallback = (httpHeaderMap, document, eSoapVersion, iCommonsList) -> {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            SoapHeaderElementProcessorRegistry soapHeaderElementProcessorRegistry = SoapHeaderElementProcessorRegistry.createDefault(iAS4PModeResolver, iAS4CryptoFactory, iAS4CryptoFactory2, iPMode, iAS4IncomingSecurityConfiguration, iAS4IncomingReceiverConfiguration);
            IAS4IncomingMessageState iAS4IncomingMessageState = AS4IncomingHandler.processEbmsMessage(aS4ResourceHelper, locale, soapHeaderElementProcessorRegistry, httpHeaderMap, document, eSoapVersion, (ICommonsList<WSS4JAttachment>)iCommonsList, iAS4IncomingProfileSelector, (ICommonsList<Ebms3Error>)commonsArrayList, iAS4IncomingMessageMetadata);
            if (!iAS4IncomingMessageState.isSoapHeaderElementProcessingSuccessful()) {
                throw new Phase4Exception("Error processing AS4 message", iAS4IncomingMessageState.getSoapWSS4JException()).setRetryFeasible(false);
            }
            wrapper.set((Object)iAS4IncomingMessageState);
        };
        HttpHeaderMap httpHeaderMap2 = new HttpHeaderMap();
        for (Header header : httpResponse.getHeaders()) {
            httpHeaderMap2.addHeader(header.getName(), header.getValue());
        }
        try (NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray);){
            AS4IncomingHandler.parseAS4Message(iAS4IncomingAttachmentFactory, aS4ResourceHelper, iAS4IncomingMessageMetadata, (InputStream)nonBlockingByteArrayInputStream, httpHeaderMap2, iAS4ParsedMessageCallback, iAS4IncomingDumper);
        }
        catch (Phase4Exception phase4Exception) {
            throw phase4Exception;
        }
        catch (Exception exception) {
            throw new Phase4Exception("Error parsing AS4 message", exception);
        }
        return (IAS4IncomingMessageState)wrapper.get();
    }

    @Nullable
    public static Ebms3SignalMessage parseSignalMessage(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull IAS4CryptoFactory iAS4CryptoFactory2, @Nonnull IAS4PModeResolver iAS4PModeResolver, @Nonnull IAS4IncomingAttachmentFactory iAS4IncomingAttachmentFactory, @Nonnull IAS4IncomingProfileSelector iAS4IncomingProfileSelector, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, @Nullable IPMode iPMode, @Nonnull Locale locale, @Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpResponse httpResponse, @Nonnull byte[] byArray, @Nullable IAS4IncomingDumper iAS4IncomingDumper, @Nonnull IAS4IncomingSecurityConfiguration iAS4IncomingSecurityConfiguration, @Nonnull IAS4IncomingReceiverConfiguration iAS4IncomingReceiverConfiguration, @Nullable IAS4SignalMessageConsumer iAS4SignalMessageConsumer) throws Phase4Exception {
        IAS4IncomingMessageState iAS4IncomingMessageState = AS4IncomingHandler._parseMessage(iAS4CryptoFactory, iAS4CryptoFactory2, iAS4PModeResolver, iAS4IncomingAttachmentFactory, iAS4IncomingProfileSelector, aS4ResourceHelper, iPMode, locale, iAS4IncomingMessageMetadata, httpResponse, byArray, iAS4IncomingDumper, iAS4IncomingSecurityConfiguration, iAS4IncomingReceiverConfiguration);
        if (iAS4IncomingMessageState == null) {
            return null;
        }
        Ebms3SignalMessage ebms3SignalMessage = iAS4IncomingMessageState.getEbmsSignalMessage();
        if (ebms3SignalMessage == null) {
            if (iAS4IncomingMessageState.getEbmsUserMessage() != null) {
                LOGGER.warn("A Message state is present, but it contains a UserMessage instead of a SignalMessage.");
            } else {
                LOGGER.warn("A Message state is present, but it contains neither a UserMessage nor a SignalMessage.");
            }
        } else if (iAS4SignalMessageConsumer != null) {
            iAS4SignalMessageConsumer.handleSignalMessage(ebms3SignalMessage, iAS4IncomingMessageMetadata, iAS4IncomingMessageState);
        }
        return ebms3SignalMessage;
    }

    @Nullable
    public static Ebms3UserMessage parseUserMessage(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull IAS4CryptoFactory iAS4CryptoFactory2, @Nonnull IAS4PModeResolver iAS4PModeResolver, @Nonnull IAS4IncomingAttachmentFactory iAS4IncomingAttachmentFactory, @Nonnull IAS4IncomingProfileSelector iAS4IncomingProfileSelector, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, @Nullable IPMode iPMode, @Nonnull Locale locale, @Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpResponse httpResponse, @Nonnull byte[] byArray, @Nullable IAS4IncomingDumper iAS4IncomingDumper, @Nonnull IAS4IncomingSecurityConfiguration iAS4IncomingSecurityConfiguration, @Nonnull IAS4IncomingReceiverConfiguration iAS4IncomingReceiverConfiguration, @Nullable IAS4UserMessageConsumer iAS4UserMessageConsumer) throws Phase4Exception {
        IAS4IncomingMessageState iAS4IncomingMessageState = AS4IncomingHandler._parseMessage(iAS4CryptoFactory, iAS4CryptoFactory2, iAS4PModeResolver, iAS4IncomingAttachmentFactory, iAS4IncomingProfileSelector, aS4ResourceHelper, iPMode, locale, iAS4IncomingMessageMetadata, httpResponse, byArray, iAS4IncomingDumper, iAS4IncomingSecurityConfiguration, iAS4IncomingReceiverConfiguration);
        if (iAS4IncomingMessageState == null) {
            return null;
        }
        Ebms3UserMessage ebms3UserMessage = iAS4IncomingMessageState.getEbmsUserMessage();
        if (ebms3UserMessage == null) {
            if (iAS4IncomingMessageState.getEbmsSignalMessage() != null) {
                LOGGER.warn("A Message state is present, but it contains a SignalMessage instead of a UserMessage.");
            } else {
                LOGGER.warn("A Message state is present, but it contains neither a SignalMessage nor a UserMessage.");
            }
        } else if (iAS4UserMessageConsumer != null) {
            iAS4UserMessageConsumer.handleUserMessage(ebms3UserMessage, iAS4IncomingMessageMetadata, iAS4IncomingMessageState);
        }
        return ebms3UserMessage;
    }

    @Nonnull
    public static ESuccess parseUserOrSignalMessage(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull IAS4CryptoFactory iAS4CryptoFactory2, @Nonnull IAS4PModeResolver iAS4PModeResolver, @Nonnull IAS4IncomingAttachmentFactory iAS4IncomingAttachmentFactory, @Nonnull IAS4IncomingProfileSelector iAS4IncomingProfileSelector, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, @Nullable IPMode iPMode, @Nonnull Locale locale, @Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpResponse httpResponse, @Nonnull byte[] byArray, @Nullable IAS4IncomingDumper iAS4IncomingDumper, @Nonnull IAS4IncomingSecurityConfiguration iAS4IncomingSecurityConfiguration, @Nonnull IAS4IncomingReceiverConfiguration iAS4IncomingReceiverConfiguration, @Nullable IAS4UserMessageConsumer iAS4UserMessageConsumer, @Nullable IAS4SignalMessageConsumer iAS4SignalMessageConsumer) throws Phase4Exception {
        IAS4IncomingMessageState iAS4IncomingMessageState = AS4IncomingHandler._parseMessage(iAS4CryptoFactory, iAS4CryptoFactory2, iAS4PModeResolver, iAS4IncomingAttachmentFactory, iAS4IncomingProfileSelector, aS4ResourceHelper, iPMode, locale, iAS4IncomingMessageMetadata, httpResponse, byArray, iAS4IncomingDumper, iAS4IncomingSecurityConfiguration, iAS4IncomingReceiverConfiguration);
        if (iAS4IncomingMessageState == null) {
            return ESuccess.FAILURE;
        }
        Ebms3UserMessage ebms3UserMessage = iAS4IncomingMessageState.getEbmsUserMessage();
        if (ebms3UserMessage != null) {
            if (iAS4UserMessageConsumer != null) {
                iAS4UserMessageConsumer.handleUserMessage(ebms3UserMessage, iAS4IncomingMessageMetadata, iAS4IncomingMessageState);
            }
        } else {
            Ebms3SignalMessage ebms3SignalMessage = iAS4IncomingMessageState.getEbmsSignalMessage();
            if (ebms3SignalMessage != null) {
                if (iAS4SignalMessageConsumer != null) {
                    iAS4SignalMessageConsumer.handleSignalMessage(ebms3SignalMessage, iAS4IncomingMessageMetadata, iAS4IncomingMessageState);
                }
            } else {
                LOGGER.warn("A Message state is present, but it contains neither a SignalMessage nor a UserMessage.");
            }
        }
        return ESuccess.SUCCESS;
    }

    public static interface IAS4ParsedMessageCallback {
        public void handle(@Nonnull HttpHeaderMap var1, @Nonnull Document var2, @Nonnull ESoapVersion var3, @Nonnull ICommonsList<WSS4JAttachment> var4) throws WSSecurityException, MessagingException, Phase4Exception;
    }
}

