/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xmldsig.keyselect;

import com.helger.security.keystore.ConstantKeySelectorResult;
import com.helger.xmldsig.keyselect.AbstractKeySelector;
import jakarta.annotation.Nonnull;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.X509Data;

public final class ContainedX509KeySelector
extends AbstractKeySelector {
    @Override
    @Nonnull
    public KeySelectorResult select(@Nonnull KeyInfo keyInfo, KeySelector.Purpose purpose, @Nonnull AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        for (XMLStructure xMLStructure : keyInfo.getContent()) {
            if (!(xMLStructure instanceof X509Data)) continue;
            X509Data x509Data = (X509Data)xMLStructure;
            for (Object obj : x509Data.getContent()) {
                if (!(obj instanceof X509Certificate)) continue;
                X509Certificate x509Certificate = (X509Certificate)obj;
                PublicKey publicKey = x509Certificate.getPublicKey();
                if (!ContainedX509KeySelector.algorithmEquals(algorithmMethod.getAlgorithm(), publicKey.getAlgorithm())) continue;
                return new ConstantKeySelectorResult((Key)publicKey);
            }
        }
        throw new KeySelectorException("No key found!");
    }
}

