/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xmldsig.keyselect;

import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import javax.xml.crypto.KeySelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKeySelector
extends KeySelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractKeySelector.class);

    public static boolean algorithmEquals(@Nonnull String string, @Nonnull String string2) {
        if (string2.equalsIgnoreCase("DSA") && (string.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1") || string.equalsIgnoreCase("http://www.w3.org/2009/xmldsig11#dsa-sha256"))) {
            return true;
        }
        if (string2.equalsIgnoreCase("RSA") && (string.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1") || string.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#sha1-rsa-MGF1") || string.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160") || string.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#rsa-sha224") || string.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#sha224-rsa-MGF1") || string.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256") || string.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1") || string.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384") || string.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1") || string.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512") || string.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1") || string.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#sha3-224-rsa-MGF1") || string.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#sha3-256-rsa-MGF1") || string.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#sha3-384-rsa-MGF1") || string.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#sha3-512-rsa-MGF1"))) {
            return true;
        }
        if (string2.equalsIgnoreCase("EC") && (string.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#ecdsa-ripemd160") || string.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1") || string.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224") || string.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256") || string.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384") || string.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512"))) {
            return true;
        }
        LOGGER.warn("Algorithm mismatch between JCA/JCE public key algorithm name ('" + string2 + "') and signature algorithm URI ('" + string + "')");
        return false;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

