/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xmldsig;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.xmldsig.XMLDSigSetup;
import com.helger.xmldsig.XMLDSigValidationResult;
import com.helger.xmldsig.keyselect.ContainedX509KeySelector;
import jakarta.annotation.Nonnull;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public final class XMLDSigValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLDSigValidator.class);

    private XMLDSigValidator() {
    }

    public static boolean containsSignature(@Nonnull Document document) {
        ValueEnforcer.notNull((Object)document, (String)"Document");
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        return nodeList.getLength() > 0;
    }

    @Nonnull
    public static XMLDSigValidationResult validateSignature(@Nonnull Document document) throws XMLSignatureException {
        ValueEnforcer.notNull((Object)document, (String)"Document");
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nodeList.getLength() != 1) {
            throw new IllegalArgumentException("Cannot find exactly one Signature element");
        }
        Element element = (Element)nodeList.item(0);
        return XMLDSigValidator.validateSignature(document, element);
    }

    @Nonnull
    public static XMLDSigValidationResult validateSignature(@Nonnull Document document, @Nonnull Element element) throws XMLSignatureException {
        return XMLDSigValidator.validateSignature(document, element, new ContainedX509KeySelector());
    }

    @Nonnull
    public static XMLDSigValidationResult validateSignature(@Nonnull Document document, @Nonnull Element element, @Nonnull KeySelector keySelector) throws XMLSignatureException {
        XMLSignature xMLSignature;
        ValueEnforcer.notNull((Object)document, (String)"Document");
        ValueEnforcer.notNull((Object)element, (String)"SignatureElement");
        ValueEnforcer.notNull((Object)keySelector, (String)"KeySelector");
        XMLSignatureFactory xMLSignatureFactory = XMLDSigSetup.getXMLSignatureFactory();
        DOMValidateContext dOMValidateContext = new DOMValidateContext(keySelector, (Node)element);
        try {
            xMLSignature = xMLSignatureFactory.unmarshalXMLSignature(dOMValidateContext);
        }
        catch (MarshalException marshalException) {
            LOGGER.error("Failed to read XML signature: " + marshalException.getClass().getName() + " - " + marshalException.getMessage());
            return XMLDSigValidationResult.createSignatureError();
        }
        if (xMLSignature.validate(dOMValidateContext)) {
            return XMLDSigValidationResult.createSuccess();
        }
        if (!xMLSignature.getSignatureValue().validate(dOMValidateContext)) {
            return XMLDSigValidationResult.createSignatureError();
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        Iterator<Reference> iterator = xMLSignature.getSignedInfo().getReferences().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Reference reference = iterator.next();
            if (!reference.validate(dOMValidateContext)) {
                commonsArrayList.add((Object)n);
            }
            ++n;
        }
        return XMLDSigValidationResult.createReferenceErrors((List<Integer>)commonsArrayList);
    }
}

