/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xmldsig;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.IValidityIndicator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.List;

public class XMLDSigValidationResult
implements IValidityIndicator,
Serializable {
    private final boolean m_bValidOverall;
    private final boolean m_bSignatureValid;
    private final ICommonsList<Integer> m_aInvalidReferences;

    private XMLDSigValidationResult() {
        this.m_bValidOverall = true;
        this.m_bSignatureValid = true;
        this.m_aInvalidReferences = null;
    }

    private XMLDSigValidationResult(boolean bl) {
        this.m_bValidOverall = false;
        this.m_bSignatureValid = bl;
        this.m_aInvalidReferences = null;
    }

    public XMLDSigValidationResult(@Nonnull @Nonempty List<Integer> list) {
        ValueEnforcer.notEmpty(list, (String)"InvalidReferences");
        this.m_bValidOverall = false;
        this.m_bSignatureValid = true;
        this.m_aInvalidReferences = new CommonsArrayList(list);
    }

    public boolean isValid() {
        return this.m_bValidOverall;
    }

    public boolean isSignatureValid() {
        return this.m_bSignatureValid;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Integer> getInvalidReferenceIndices() {
        return new CommonsArrayList(this.m_aInvalidReferences);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("valid", this.m_bValidOverall).append("signatureValid", this.m_bSignatureValid).append("invalidReferences", this.m_aInvalidReferences).getToString();
    }

    @Nonnull
    public static XMLDSigValidationResult createSuccess() {
        return new XMLDSigValidationResult();
    }

    @Nonnull
    public static XMLDSigValidationResult createSignatureError() {
        return new XMLDSigValidationResult(false);
    }

    @Nonnull
    public static XMLDSigValidationResult createReferenceErrors(@Nonnull @Nonempty List<Integer> list) {
        return new XMLDSigValidationResult(list);
    }
}

