/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xmldsig;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.xmldsig.XMLDSigSetup;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public class XMLDSigCreator {
    public static final String DEFAULT_NS_PREFIX = "dsig";
    private final XMLSignatureFactory m_aSignatureFactory = XMLDSigSetup.getXMLSignatureFactory();

    @Nonnull
    public final XMLSignatureFactory getSignatureFactory() {
        return this.m_aSignatureFactory;
    }

    @Nullable
    @OverrideOnDemand
    protected String getDefaultReferenceURI() {
        return "";
    }

    @Nonnull
    @OverrideOnDemand
    protected String getDigestMethod() throws Exception {
        return "http://www.w3.org/2000/09/xmldsig#sha1";
    }

    @Nonnull
    @OverrideOnDemand
    protected DigestMethod createDigestMethod() throws Exception {
        return this.m_aSignatureFactory.newDigestMethod(this.getDigestMethod(), null);
    }

    @Nonnull
    @OverrideOnDemand
    protected String getDefaultTransform() throws Exception {
        return "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
    }

    @Nonnull
    @OverrideOnDemand
    protected Transform createDefaultTransform() throws Exception {
        return this.m_aSignatureFactory.newTransform(this.getDefaultTransform(), (TransformParameterSpec)null);
    }

    @Nonnull
    @OverrideOnDemand
    protected List<Transform> createTransformList() throws Exception {
        return new CommonsArrayList((Object)this.createDefaultTransform());
    }

    @Nullable
    @OverrideOnDemand
    protected String getDefaultReferenceType() throws Exception {
        return null;
    }

    @Nullable
    @OverrideOnDemand
    protected String getDefaultReferenceID() throws Exception {
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    protected Reference createDefaultReference() throws Exception {
        return this.m_aSignatureFactory.newReference(this.getDefaultReferenceURI(), this.createDigestMethod(), this.createTransformList(), this.getDefaultReferenceType(), this.getDefaultReferenceID());
    }

    @Nonnull
    @ReturnsMutableCopy
    protected ICommonsList<Reference> createReferenceList() throws Exception {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        commonsArrayList.addIfNotNull((Object)this.createDefaultReference());
        return commonsArrayList;
    }

    @Nonnull
    @OverrideOnDemand
    protected String getCanonicalizationMethod() throws Exception {
        return "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    }

    @Nonnull
    @OverrideOnDemand
    protected CanonicalizationMethod createCanonicalizationMethod() throws Exception {
        return this.m_aSignatureFactory.newCanonicalizationMethod(this.getCanonicalizationMethod(), (C14NMethodParameterSpec)null);
    }

    @Nonnull
    @OverrideOnDemand
    protected String getSignatureMethod() throws Exception {
        return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    }

    @Nonnull
    @OverrideOnDemand
    protected SignatureMethod createSignatureMethod() throws Exception {
        return this.m_aSignatureFactory.newSignatureMethod(this.getSignatureMethod(), null);
    }

    @Nonnull
    public SignedInfo createSignedInfo() throws Exception {
        return this.m_aSignatureFactory.newSignedInfo(this.createCanonicalizationMethod(), this.createSignatureMethod(), (List<? extends Reference>)this.createReferenceList());
    }

    @Nonnull
    public KeyInfo createKeyInfo(@Nonnull X509Certificate x509Certificate) throws KeyException {
        KeyInfoFactory keyInfoFactory = this.m_aSignatureFactory.getKeyInfoFactory();
        CommonsArrayList commonsArrayList = new CommonsArrayList(new Object[]{x509Certificate.getSubjectX500Principal().getName(), x509Certificate});
        X509Data x509Data = keyInfoFactory.newX509Data((List<?>)commonsArrayList);
        KeyValue keyValue = keyInfoFactory.newKeyValue(x509Certificate.getPublicKey());
        return keyInfoFactory.newKeyInfo((List<? extends XMLStructure>)new CommonsArrayList((Object[])new XMLStructure[]{x509Data, keyValue}));
    }

    @Nonnull
    @OverrideOnDemand
    public XMLSignature createXMLSignature(@Nonnull X509Certificate x509Certificate) throws Exception {
        return this.createXMLSignature(x509Certificate, null, null, null);
    }

    @Nonnull
    @OverrideOnDemand
    public XMLSignature createXMLSignature(@Nonnull X509Certificate x509Certificate, @Nullable List<? extends XMLObject> list, @Nullable String string, @Nullable String string2) throws Exception {
        ValueEnforcer.notNull((Object)x509Certificate, (String)"certificate");
        SignedInfo signedInfo = this.createSignedInfo();
        KeyInfo keyInfo = this.createKeyInfo(x509Certificate);
        return this.m_aSignatureFactory.newXMLSignature(signedInfo, keyInfo, list, string, string2);
    }

    public void applyXMLDSigAsFirstChild(@Nonnull PrivateKey privateKey, @Nonnull X509Certificate x509Certificate, @Nonnull Document document) throws Exception {
        ValueEnforcer.notNull((Object)privateKey, (String)"privateKey");
        ValueEnforcer.notNull((Object)x509Certificate, (String)"certificate");
        ValueEnforcer.notNull((Object)document, (String)"document");
        ValueEnforcer.notNull((Object)document.getDocumentElement(), (String)"Document is missing a document element");
        if (document.getDocumentElement().getChildNodes().getLength() == 0) {
            throw new IllegalArgumentException("Document element has no children!");
        }
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nodeList.getLength() > 0) {
            throw new IllegalArgumentException("Document already contains an XMLDSig Signature element!");
        }
        XMLSignature xMLSignature = this.createXMLSignature(x509Certificate);
        DOMSignContext dOMSignContext = new DOMSignContext(privateKey, (Node)document.getDocumentElement(), document.getDocumentElement().getFirstChild());
        dOMSignContext.setDefaultNamespacePrefix(DEFAULT_NS_PREFIX);
        xMLSignature.sign(dOMSignContext);
    }
}

