/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.writer;

import com.helger.annotation.WillClose;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.nonblocking.NonBlockingStringWriter;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.ICommonsList;
import com.helger.css.ICSSWriteable;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSNamespaceRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.writer.CSSWriterSettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

@NotThreadSafe
public class CSSWriter {
    public static final boolean DEFAULT_OPTIMIZED_OUTPUT = false;
    private final CSSWriterSettings m_aSettings;
    private boolean m_bWriteHeaderText;
    private String m_sHeaderText = "THIS FILE IS GENERATED - DO NOT EDIT";
    private boolean m_bWriteFooterText;
    private String m_sFooterText;
    private String m_sContentCharset;

    public CSSWriter() {
        this(new CSSWriterSettings());
    }

    public CSSWriter(boolean bl) {
        this(new CSSWriterSettings(bl));
    }

    public CSSWriter(@Nonnull CSSWriterSettings cSSWriterSettings) {
        ValueEnforcer.notNull((Object)cSSWriterSettings, (String)"Settings");
        this.m_aSettings = cSSWriterSettings;
        this.m_bWriteHeaderText = !cSSWriterSettings.isOptimizedOutput();
        this.m_bWriteFooterText = !cSSWriterSettings.isOptimizedOutput();
    }

    public boolean isWriteHeaderText() {
        return this.m_bWriteHeaderText;
    }

    @Nonnull
    public CSSWriter setWriteHeaderText(boolean bl) {
        this.m_bWriteHeaderText = bl;
        return this;
    }

    @Nullable
    public String getHeaderText() {
        return this.m_sHeaderText;
    }

    @Nonnull
    public CSSWriter setHeaderText(@Nullable String string) {
        this.m_sHeaderText = string;
        return this;
    }

    public boolean isWriteFooterText() {
        return this.m_bWriteFooterText;
    }

    @Nonnull
    public CSSWriter setWriteFooterText(boolean bl) {
        this.m_bWriteFooterText = bl;
        return this;
    }

    @Nullable
    public String getFooterText() {
        return this.m_sFooterText;
    }

    @Nonnull
    public CSSWriter setFooterText(@Nullable String string) {
        this.m_sFooterText = string;
        return this;
    }

    @Nullable
    public String getContentCharset() {
        return this.m_sContentCharset;
    }

    @Nonnull
    public CSSWriter setContentCharset(@Nullable String string) {
        this.m_sContentCharset = string;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject(value="Design")
    public CSSWriterSettings getSettings() {
        return this.m_aSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCSS(@Nonnull CascadingStyleSheet cascadingStyleSheet, @Nonnull @WillClose Writer writer) throws IOException {
        ValueEnforcer.notNull((Object)cascadingStyleSheet, (String)"CSS");
        ValueEnforcer.notNull((Object)writer, (String)"Writer");
        try {
            ICommonsList<CSSNamespaceRule> iCommonsList;
            Object object2;
            boolean bl = this.m_aSettings.isOptimizedOutput();
            String string = this.m_aSettings.getNewLineString();
            if (this.m_bWriteHeaderText && StringHelper.isNotEmpty((String)this.m_sHeaderText)) {
                writer.write("/*");
                writer.write(string);
                for (Object object2 : StringHelper.getExploded((String)"\n", (String)this.m_sHeaderText)) {
                    writer.write(" * " + object2);
                    writer.write(string);
                }
                writer.write(" */");
                writer.write(string);
            }
            if (StringHelper.isNotEmpty((String)this.m_sContentCharset)) {
                writer.write("@charset \"" + this.m_sContentCharset + "\";");
                if (!bl) {
                    writer.write(string);
                }
            }
            int n = 0;
            object2 = cascadingStyleSheet.getAllImportRules();
            if (object2.isNotEmpty()) {
                iCommonsList = object2.iterator();
                while (iCommonsList.hasNext()) {
                    Iterator iterator = (CSSImportRule)iCommonsList.next();
                    writer.write(iterator.getAsCSSString(this.m_aSettings));
                    ++n;
                }
            }
            if ((iCommonsList = cascadingStyleSheet.getAllNamespaceRules()).isNotEmpty()) {
                for (Object object3 : iCommonsList) {
                    writer.write(object3.getAsCSSString(this.m_aSettings));
                    ++n;
                }
            }
            for (Object object3 : cascadingStyleSheet.getAllRules()) {
                String string2 = object3.getAsCSSString(this.m_aSettings);
                if (!StringHelper.isNotEmpty((String)string2)) continue;
                if (!bl && n > 0) {
                    writer.write(string);
                }
                writer.write(string2);
                ++n;
            }
            if (this.m_bWriteFooterText && StringHelper.isNotEmpty((String)this.m_sFooterText)) {
                writer.write("/*");
                writer.write(string);
                for (Object object3 : StringHelper.getExploded((char)'\n', (String)this.m_sFooterText)) {
                    writer.write(" * " + (String)object3);
                    writer.write(string);
                }
                writer.write(" */");
                writer.write(string);
            }
        }
        finally {
            StreamHelper.close((AutoCloseable)writer);
        }
    }

    @Nonnull
    public String getCSSAsString(@Nonnull CascadingStyleSheet cascadingStyleSheet) {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();
        try {
            this.writeCSS(cascadingStyleSheet, (Writer)nonBlockingStringWriter);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Totally unexpected", iOException);
        }
        return nonBlockingStringWriter.getAsString();
    }

    public void writeCSS(@Nonnull ICSSWriteable iCSSWriteable, @Nonnull @WillClose Writer writer) throws IOException {
        ValueEnforcer.notNull((Object)iCSSWriteable, (String)"CSS");
        ValueEnforcer.notNull((Object)writer, (String)"Writer");
        try {
            writer.write(iCSSWriteable.getAsCSSString(this.m_aSettings));
        }
        finally {
            StreamHelper.close((AutoCloseable)writer);
        }
    }

    @Nonnull
    public String getCSSAsString(@Nonnull ICSSWriteable iCSSWriteable) {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();
        try {
            this.writeCSS(iCSSWriteable, (Writer)nonBlockingStringWriter);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Totally unexpected", iOException);
        }
        return nonBlockingStringWriter.getAsString();
    }
}

