/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cache.regex.RegExHelper;
import com.helger.css.ECSSVendorPrefix;
import com.helger.css.property.AbstractCSSProperty;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import com.helger.css.utils.CSSNumberHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class CSSPropertyNumbers
extends AbstractCSSProperty {
    private final boolean m_bWithPercentage;
    private final int m_nMinArgCount;
    private final int m_nMaxArgCount;

    public CSSPropertyNumbers(@Nonnull ECSSProperty eCSSProperty, boolean bl, @Nonnegative int n, @Nonnegative int n2) {
        this(eCSSProperty, null, bl, n, n2);
    }

    public CSSPropertyNumbers(@Nonnull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, boolean bl, @Nonnegative int n, @Nonnegative int n2) {
        this(eCSSProperty, null, iCSSPropertyCustomizer, bl, n, n2);
    }

    public CSSPropertyNumbers(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, boolean bl, @Nonnegative int n, @Nonnegative int n2) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer);
        ValueEnforcer.isGT0((int)n, (String)"MinNumbers");
        ValueEnforcer.isGT0((int)n2, (String)"MaxNumbers");
        ValueEnforcer.isTrue((n <= n2 ? 1 : 0) != 0, () -> "MaxArgCount (" + n2 + ") must be >= MinArgCount (" + n + ")");
        this.m_bWithPercentage = bl;
        this.m_nMinArgCount = n;
        this.m_nMaxArgCount = n2;
    }

    @Override
    public int getMinimumArgumentCount() {
        return this.m_nMinArgCount;
    }

    @Override
    public int getMaximumArgumentCount() {
        return this.m_nMaxArgCount;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String string) {
        if (super.isValidValue(string)) {
            return true;
        }
        if (string == null) {
            return false;
        }
        String[] stringArray = RegExHelper.getSplitToArray((CharSequence)string.trim(), (String)"\\s+");
        if (stringArray.length < this.m_nMinArgCount || stringArray.length > this.m_nMaxArgCount) {
            return false;
        }
        for (String string2 : stringArray) {
            if (CSSNumberHelper.isValueWithUnit(string2.trim(), this.m_bWithPercentage)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public CSSPropertyNumbers getClone(@Nonnull ECSSProperty eCSSProperty) {
        return new CSSPropertyNumbers(eCSSProperty, this.getVendorPrefix(), this.getCustomizer(), this.m_bWithPercentage, this.m_nMinArgCount, this.m_nMaxArgCount);
    }

    @Override
    @Nonnull
    public CSSPropertyNumbers getClone(@Nullable ECSSVendorPrefix eCSSVendorPrefix) {
        return new CSSPropertyNumbers(this.getProp(), eCSSVendorPrefix, this.getCustomizer(), this.m_bWithPercentage, this.m_nMinArgCount, this.m_nMaxArgCount);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        CSSPropertyNumbers cSSPropertyNumbers = (CSSPropertyNumbers)object;
        return this.m_bWithPercentage == cSSPropertyNumbers.m_bWithPercentage && this.m_nMinArgCount == cSSPropertyNumbers.m_nMinArgCount && this.m_nMaxArgCount == cSSPropertyNumbers.m_nMaxArgCount;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_bWithPercentage).append(this.m_nMinArgCount).append(this.m_nMaxArgCount).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("WithPercentage", this.m_bWithPercentage).append("MinArgCount", this.m_nMinArgCount).append("MaxArgCount", this.m_nMaxArgCount).getToString();
    }
}

