/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.cache.regex.RegExHelper;
import com.helger.css.ECSSVendorPrefix;
import com.helger.css.property.AbstractCSSPropertyEnums;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import com.helger.css.utils.CSSColorHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class CSSPropertyEnumOrColors
extends AbstractCSSPropertyEnums {
    public CSSPropertyEnumOrColors(@Nonnull ECSSProperty eCSSProperty, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        this(eCSSProperty, (ICSSPropertyCustomizer)null, n, n2, stringArray);
    }

    public CSSPropertyEnumOrColors(@Nonnull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        this(eCSSProperty, (ECSSVendorPrefix)null, iCSSPropertyCustomizer, n, n2, stringArray);
    }

    public CSSPropertyEnumOrColors(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer, n, n2, stringArray);
    }

    public CSSPropertyEnumOrColors(@Nonnull ECSSProperty eCSSProperty, @Nonnegative int n, @Nonnegative int n2, @Nonnull @Nonempty Iterable<String> iterable) {
        this(eCSSProperty, null, n, n2, iterable);
    }

    public CSSPropertyEnumOrColors(@Nonnull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, @Nonnull @Nonempty Iterable<String> iterable) {
        this(eCSSProperty, (ECSSVendorPrefix)null, iCSSPropertyCustomizer, n, n2, iterable);
    }

    public CSSPropertyEnumOrColors(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2, @Nonnull @Nonempty Iterable<String> iterable) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer, n, n2, iterable);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = RegExHelper.getSplitToArray((CharSequence)string.trim(), (String)"\\s+");
        if (stringArray.length < this.getMinimumArgumentCount() || stringArray.length > this.getMaximumArgumentCount()) {
            return false;
        }
        for (String string2 : stringArray) {
            String string3 = string2.trim();
            if (super.isValidValue(string3) || CSSColorHelper.isColorValue(string3)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public CSSPropertyEnumOrColors getClone(@Nonnull ECSSProperty eCSSProperty) {
        return new CSSPropertyEnumOrColors(eCSSProperty, this.getVendorPrefix(), this.getCustomizer(), this.getMinimumArgumentCount(), this.getMaximumArgumentCount(), (Iterable<String>)this.directGetEnumValues());
    }

    @Override
    @Nonnull
    public CSSPropertyEnumOrColors getClone(@Nullable ECSSVendorPrefix eCSSVendorPrefix) {
        return new CSSPropertyEnumOrColors(this.getProp(), eCSSVendorPrefix, this.getCustomizer(), this.getMinimumArgumentCount(), this.getMaximumArgumentCount(), (Iterable<String>)this.directGetEnumValues());
    }
}

