/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSDeclarationList;
import jakarta.annotation.Nonnull;

@NotThreadSafe
public class CSSDeclarationContainer
extends CSSDeclarationList {
    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.getDeclarationCount();
        if (n2 == 0) {
            stringBuilder.append(bl ? "{}" : " {}");
        } else if (n2 == 1) {
            stringBuilder.append(bl ? "{" : " { ");
            stringBuilder.append(super.getAsCSSString(iCSSWriterSettings, n));
            stringBuilder.append(bl ? "}" : " }");
        } else {
            stringBuilder.append((String)(bl ? "{" : " {" + iCSSWriterSettings.getNewLineString()));
            stringBuilder.append(super.getAsCSSString(iCSSWriterSettings, n));
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n));
            }
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }
}

