/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.peppol.utils;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.string.StringHelper;
import com.helger.xml.serialize.read.DOMReader;
import com.helger.xml.serialize.write.EXMLSerializeDocType;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import com.helger.xsds.peppol.smp1.ExtensionType;
import jakarta.annotation.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Immutable
public final class SMPExtensionConverter {
    private static final XMLWriterSettings XWS = new XMLWriterSettings().setSerializeDocType(EXMLSerializeDocType.IGNORE).setIndent(EXMLSerializeIndent.NONE);
    private static final SMPExtensionConverter INSTANCE = new SMPExtensionConverter();

    private SMPExtensionConverter() {
    }

    @Nullable
    public static String convertToString(@Nullable ExtensionType extensionType) {
        if (extensionType != null && extensionType.getAny() != null) {
            return XMLWriter.getNodeAsString((Node)extensionType.getAny(), (IXMLWriterSettings)XWS);
        }
        return null;
    }

    @Nullable
    public static ExtensionType convert(@Nullable String string) {
        Document document;
        if (StringHelper.isNotEmpty((String)string) && (document = DOMReader.readXMLDOM((String)string)) != null) {
            ExtensionType extensionType = new ExtensionType();
            extensionType.setAny(document.getDocumentElement());
            return extensionType;
        }
        return null;
    }
}

