/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.peppol;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.string.StringHelper;
import com.helger.base.wrapper.Wrapper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsList;
import com.helger.datetime.helper.PDTFactory;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.peppolid.factory.PeppolIdentifierFactory;
import com.helger.security.certificate.CertificateHelper;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.exception.SMPClientNotFoundException;
import com.helger.smpclient.exception.SMPClientParticipantNotFoundException;
import com.helger.smpclient.httpclient.AbstractGenericSMPClient;
import com.helger.smpclient.httpclient.SMPHttpResponseHandlerSigned;
import com.helger.smpclient.httpclient.SMPHttpResponseHandlerUnsigned;
import com.helger.smpclient.peppol.ISMPExtendedServiceMetadataProvider;
import com.helger.smpclient.peppol.ISMPServiceGroupProvider;
import com.helger.smpclient.peppol.PeppolWildcardSelector;
import com.helger.smpclient.peppol.marshal.SMPMarshallerServiceGroupType;
import com.helger.smpclient.peppol.marshal.SMPMarshallerSignedServiceMetadataType;
import com.helger.smpclient.peppol.utils.W3CEndpointReferenceHelper;
import com.helger.smpclient.redirect.ISMPFollowRedirectCallback;
import com.helger.smpclient.url.ISMPURLProvider;
import com.helger.smpclient.url.SMPDNSResolutionException;
import com.helger.xsds.peppol.id1.ParticipantIdentifierType;
import com.helger.xsds.peppol.id1.ProcessIdentifierType;
import com.helger.xsds.peppol.smp1.EndpointType;
import com.helger.xsds.peppol.smp1.ProcessType;
import com.helger.xsds.peppol.smp1.ServiceGroupType;
import com.helger.xsds.peppol.smp1.ServiceInformationType;
import com.helger.xsds.peppol.smp1.ServiceMetadataReferenceType;
import com.helger.xsds.peppol.smp1.ServiceMetadataType;
import com.helger.xsds.peppol.smp1.SignedServiceMetadataType;
import com.helger.xsds.xmldsig.X509DataType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.xml.bind.JAXBElement;
import java.net.URI;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.function.Consumer;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPClientReadOnly
extends AbstractGenericSMPClient<SMPClientReadOnly>
implements ISMPServiceGroupProvider,
ISMPExtendedServiceMetadataProvider {
    public static final String URL_PART_COMPLETE = "complete";
    public static final String URL_PART_LIST = "list";
    public static final String URL_PART_SERVICES = "services";
    private static final Logger LOGGER = LoggerFactory.getLogger(SMPClientReadOnly.class);

    public SMPClientReadOnly(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) throws SMPDNSResolutionException {
        this(iSMPURLProvider.getSMPURIOfParticipant(iParticipantIdentifier, iSMLInfo));
    }

    public SMPClientReadOnly(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string) throws SMPDNSResolutionException {
        this(iSMPURLProvider.getSMPURIOfParticipant(iParticipantIdentifier, string));
    }

    public SMPClientReadOnly(@Nonnull URI uRI) {
        super(uRI, true);
    }

    @Override
    @Nonnull
    public ServiceGroupType getServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SMPClient getServiceGroup@" + string);
        }
        HttpGet httpGet = new HttpGet(string);
        SMPMarshallerServiceGroupType sMPMarshallerServiceGroupType = new SMPMarshallerServiceGroupType();
        sMPMarshallerServiceGroupType.setUseSchema(this.isXMLSchemaValidation());
        this.customizeMarshaller(sMPMarshallerServiceGroupType);
        ServiceGroupType serviceGroupType = this.executeGenericRequest((HttpUriRequestBase)httpGet, new SMPHttpResponseHandlerUnsigned<ServiceGroupType>(sMPMarshallerServiceGroupType));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received response: " + String.valueOf(serviceGroupType));
        }
        return serviceGroupType;
    }

    @Override
    @Nullable
    public ServiceGroupType getServiceGroupOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException {
        try {
            return this.getServiceGroup(iParticipantIdentifier);
        }
        catch (SMPClientNotFoundException | SMPClientParticipantNotFoundException sMPClientException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found no ServiceGroup");
            }
            return null;
        }
    }

    @Nonnull
    public static ICommonsList<IDocumentTypeIdentifier> getAllDocumentTypes(@Nullable ServiceGroupType serviceGroupType) {
        return SMPClientReadOnly.getAllDocumentTypes(serviceGroupType, (IIdentifierFactory)PeppolIdentifierFactory.INSTANCE, null);
    }

    @Nonnull
    public static ICommonsList<IDocumentTypeIdentifier> getAllDocumentTypes(@Nullable ServiceGroupType serviceGroupType, @Nonnull IIdentifierFactory iIdentifierFactory, @Nullable Consumer<String> consumer) {
        ValueEnforcer.notNull((Object)iIdentifierFactory, (String)"IdentifierFactory");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (serviceGroupType != null && serviceGroupType.getParticipantIdentifier() != null && serviceGroupType.getServiceMetadataReferenceCollection() != null) {
            String string = "/" + CIdentifier.getURIEncoded((ParticipantIdentifierType)serviceGroupType.getParticipantIdentifier()) + "/services/";
            for (ServiceMetadataReferenceType serviceMetadataReferenceType : serviceGroupType.getServiceMetadataReferenceCollection().getServiceMetadataReference()) {
                String string2;
                IDocumentTypeIdentifier iDocumentTypeIdentifier;
                String string3 = serviceMetadataReferenceType.getHref();
                String string4 = CIdentifier.createPercentDecoded((String)string3);
                boolean bl = false;
                int n = StringHelper.getIndexOfIgnoreCase((String)string4, (String)string, (Locale)Locale.US);
                if (n >= 0 && (iDocumentTypeIdentifier = iIdentifierFactory.parseDocumentTypeIdentifier(string2 = string4.substring(n + string.length()))) != null) {
                    commonsArrayList.add((Object)iDocumentTypeIdentifier);
                    bl = true;
                }
                if (bl) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Failed to parse '" + string3 + "' as a document type identifier");
                }
                if (consumer == null) continue;
                consumer.accept(string3);
            }
        }
        return commonsArrayList;
    }

    @Override
    @Nonnull
    public SignedServiceMetadataType getServiceMetadata(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nullable ISMPFollowRedirectCallback iSMPFollowRedirectCallback) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeID");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded() + "/services/" + iDocumentTypeIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SMPClient getServiceMetadata@" + string);
        }
        boolean bl = this.isXMLSchemaValidation();
        boolean bl2 = this.isVerifySignature();
        boolean bl3 = this.isSecureValidation();
        KeyStore keyStore = this.getTrustStore();
        if (bl2 && keyStore == null) {
            LOGGER.error("Peppol SMP client Verify Signature is enabled, but no TrustStore is provided. This will not work.");
        }
        HttpGet httpGet = new HttpGet(string);
        SMPMarshallerSignedServiceMetadataType sMPMarshallerSignedServiceMetadataType = new SMPMarshallerSignedServiceMetadataType();
        sMPMarshallerSignedServiceMetadataType.setUseSchema(bl);
        this.customizeMarshaller(sMPMarshallerSignedServiceMetadataType);
        HttpGet httpGet2 = new SMPHttpResponseHandlerSigned(sMPMarshallerSignedServiceMetadataType, keyStore);
        httpGet2.setVerifySignature(bl2);
        httpGet2.setSecureValidation(bl3);
        SignedServiceMetadataType signedServiceMetadataType = this.executeGenericRequest((HttpUriRequestBase)httpGet, httpGet2);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received response: " + String.valueOf(signedServiceMetadataType));
        }
        if (signedServiceMetadataType.getServiceMetadata() != null && signedServiceMetadataType.getServiceMetadata().getRedirect() != null) {
            httpGet = signedServiceMetadataType.getServiceMetadata().getRedirect();
            boolean bl4 = this.isFollowSMPRedirects();
            if (iSMPFollowRedirectCallback != null) {
                iSMPFollowRedirectCallback.onFollowSMPRedirect(bl4, httpGet.getHref());
            }
            if (bl4) {
                LOGGER.info("Following an SMP Redirect from '" + string + "' to '" + httpGet.getHref() + "'");
                httpGet2 = new HttpGet(httpGet.getHref());
                SMPMarshallerSignedServiceMetadataType sMPMarshallerSignedServiceMetadataType2 = new SMPMarshallerSignedServiceMetadataType();
                sMPMarshallerSignedServiceMetadataType2.setUseSchema(bl);
                this.customizeMarshaller(sMPMarshallerSignedServiceMetadataType2);
                SMPHttpResponseHandlerSigned<SignedServiceMetadataType> sMPHttpResponseHandlerSigned = new SMPHttpResponseHandlerSigned<SignedServiceMetadataType>(sMPMarshallerSignedServiceMetadataType2, keyStore);
                sMPHttpResponseHandlerSigned.setVerifySignature(bl2);
                sMPHttpResponseHandlerSigned.setSecureValidation(bl3);
                signedServiceMetadataType = this.executeGenericRequest((HttpUriRequestBase)httpGet2, sMPHttpResponseHandlerSigned);
                boolean bl5 = false;
                for (Object e : signedServiceMetadataType.getSignature().getKeyInfo().getContent()) {
                    X509DataType x509DataType;
                    Object object;
                    if (!(e instanceof JAXBElement) || !((object = ((JAXBElement)e).getValue()) instanceof X509DataType) || !SMPClientReadOnly.containsRedirectSubject(x509DataType = (X509DataType)object, httpGet.getCertificateUID())) continue;
                    bl5 = true;
                    break;
                }
                if (!bl5) {
                    throw new SMPClientException("The X509 certificate of the SMP Redirect did not contain the expected certificate subject.");
                }
            } else {
                LOGGER.info("An SMP Redirect was found, but following SMP redirects is disabled");
            }
        }
        return signedServiceMetadataType;
    }

    @Override
    @Nullable
    public SignedServiceMetadataType getServiceMetadataOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nullable ISMPFollowRedirectCallback iSMPFollowRedirectCallback) throws SMPClientException {
        try {
            return this.getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier, iSMPFollowRedirectCallback);
        }
        catch (SMPClientNotFoundException | SMPClientParticipantNotFoundException sMPClientException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found no ServiceMetadata");
            }
            return null;
        }
    }

    private static boolean _hasSameContent(@Nonnull ProcessIdentifierType processIdentifierType, @Nonnull IProcessIdentifier iProcessIdentifier) {
        return EqualsHelper.equals((Object)processIdentifierType.getScheme(), (Object)iProcessIdentifier.getScheme()) && EqualsHelper.equals((Object)processIdentifierType.getValue(), (Object)iProcessIdentifier.getValue());
    }

    @Nullable
    public static EndpointType getEndpoint(@Nonnull SignedServiceMetadataType signedServiceMetadataType, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) {
        ValueEnforcer.notNull((Object)signedServiceMetadataType, (String)"SignedServiceMetadata");
        return SMPClientReadOnly.getEndpoint(signedServiceMetadataType.getServiceMetadata(), iProcessIdentifier, iSMPTransportProfile);
    }

    @Nullable
    public static EndpointType getEndpointAt(@Nonnull SignedServiceMetadataType signedServiceMetadataType, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile, @Nonnull LocalDateTime localDateTime) {
        ValueEnforcer.notNull((Object)signedServiceMetadataType, (String)"SignedServiceMetadata");
        return SMPClientReadOnly.getEndpointAt(signedServiceMetadataType.getServiceMetadata(), iProcessIdentifier, iSMPTransportProfile, localDateTime);
    }

    @Nullable
    public static EndpointType getEndpoint(@Nonnull ServiceMetadataType serviceMetadataType, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) {
        return SMPClientReadOnly.getEndpointAt(serviceMetadataType, iProcessIdentifier, iSMPTransportProfile, PDTFactory.getCurrentLocalDateTime());
    }

    public static boolean isEndpointValidAt(@Nonnull EndpointType endpointType, @Nonnull LocalDateTime localDateTime) {
        ValueEnforcer.notNull((Object)endpointType, (String)"Endpoint");
        ValueEnforcer.notNull((Object)localDateTime, (String)"CheckDT");
        LocalDateTime localDateTime2 = endpointType.getServiceActivationDateLocal();
        if (localDateTime2 != null && localDateTime.isBefore(localDateTime2)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SMP endpoint activation date " + String.valueOf(localDateTime2) + " is after the check DT " + String.valueOf(localDateTime));
            }
            return false;
        }
        LocalDateTime localDateTime3 = endpointType.getServiceExpirationDateLocal();
        if (localDateTime3 != null && localDateTime.isAfter(localDateTime3)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SMP endpoint expiration date " + String.valueOf(localDateTime3) + " is before the check DT " + String.valueOf(localDateTime));
            }
            return false;
        }
        return true;
    }

    @Nullable
    public static EndpointType getEndpointAt(@Nonnull ServiceMetadataType serviceMetadataType, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile, @Nonnull LocalDateTime localDateTime) {
        ValueEnforcer.notNull((Object)serviceMetadataType, (String)"ServiceMetadata");
        ServiceInformationType serviceInformationType = serviceMetadataType.getServiceInformation();
        if (serviceInformationType == null) {
            return null;
        }
        ValueEnforcer.notNull((Object)serviceInformationType.getProcessList(), (String)"ServiceMetadata.ServiceInformation.ProcessList");
        ValueEnforcer.notNull((Object)iProcessIdentifier, (String)"ProcessID");
        ValueEnforcer.notNull((Object)iSMPTransportProfile, (String)"TransportProfile");
        ValueEnforcer.notNull((Object)localDateTime, (String)"CheckDT");
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        for (ProcessType processType : serviceInformationType.getProcessList().getProcess()) {
            String string = CIdentifier.getURIEncoded((ProcessIdentifierType)processType.getProcessIdentifier());
            if (!commonsHashSet.add((Object)string)) {
                LOGGER.warn("The Process ID '" + string + "' is contained more then once within a ServiceMetadataType");
            }
            if (!SMPClientReadOnly._hasSameContent(processType.getProcessIdentifier(), iProcessIdentifier)) continue;
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            CommonsHashSet commonsHashSet2 = new CommonsHashSet();
            for (EndpointType endpointType : processType.getServiceEndpointList().getEndpoint()) {
                String string2 = endpointType.getTransportProfile();
                if (!commonsHashSet2.add((Object)string2)) {
                    LOGGER.warn("The Transport Profile '" + string2 + "' is contained more then once within the Process '" + string + "'");
                }
                if (!iSMPTransportProfile.getID().equals(string2) || !SMPClientReadOnly.isEndpointValidAt(endpointType, localDateTime)) continue;
                commonsArrayList.add((Object)endpointType);
            }
            if (commonsArrayList.size() <= 0) {
                LOGGER.warn("Found " + commonsArrayList.size() + " endpoints for process " + String.valueOf(iProcessIdentifier) + " and transport profile '" + iSMPTransportProfile.getID() + "' valid at " + String.valueOf(localDateTime) + (String)(commonsArrayList.isEmpty() ? "" : ": " + commonsArrayList.toString() + " - using the first one"));
            }
            EndpointType endpointType = (EndpointType)commonsArrayList.getFirstOrNull();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found matching SMP endpoint: " + String.valueOf(endpointType));
            }
            return endpointType;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found no matching SMP endpoint");
        }
        return null;
    }

    @Nullable
    public static String getEndpointAddress(@Nullable EndpointType endpointType) {
        return endpointType == null || endpointType.getEndpointReference() == null ? null : W3CEndpointReferenceHelper.getAddress(endpointType.getEndpointReference());
    }

    @Nullable
    public static String getEndpointCertificateString(@Nullable EndpointType endpointType) {
        return endpointType == null ? null : endpointType.getCertificate();
    }

    @Nullable
    public static X509Certificate getEndpointCertificate(@Nullable EndpointType endpointType) throws CertificateException {
        String string = SMPClientReadOnly.getEndpointCertificateString(endpointType);
        return CertificateHelper.convertStringToCertficate((String)string);
    }

    @Nullable
    public SignedServiceMetadataType getSchemeSpecificServiceMetadata(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeID");
        String string = iDocumentTypeIdentifier.getScheme();
        if (StringHelper.isEmpty((String)string)) {
            LOGGER.error("The provided Document Type ID has no scheme ID");
            return null;
        }
        switch (string) {
            case "busdox-docid-qns": {
                return this.getServiceMetadataOrNull(iParticipantIdentifier, iDocumentTypeIdentifier);
            }
            case "peppol-doctype-wildcard": {
                ServiceGroupType serviceGroupType = this.getServiceGroupOrNull(iParticipantIdentifier);
                if (serviceGroupType == null) {
                    return null;
                }
                ICommonsList<IDocumentTypeIdentifier> iCommonsList = SMPClientReadOnly.getAllDocumentTypes(serviceGroupType);
                LOGGER.info("Found " + iCommonsList.size() + " supported document types for '" + iParticipantIdentifier.getURIEncoded() + "'");
                Wrapper wrapper = new Wrapper();
                if (PeppolWildcardSelector.findPeppolDoctypeWildcardMatch(iCommonsList, iDocumentTypeIdentifier, arg_0 -> ((Wrapper)wrapper).set(arg_0)).isSuccess()) {
                    LOGGER.info("Found matching document type ID '" + ((IDocumentTypeIdentifier)wrapper.get()).getURIEncoded() + "' for '" + iParticipantIdentifier.getURIEncoded() + "'");
                    return this.getServiceMetadataOrNull(iParticipantIdentifier, (IDocumentTypeIdentifier)wrapper.get());
                }
                LOGGER.error("Failed to resolve Wildcard Best Match of '" + iDocumentTypeIdentifier.getURIEncoded() + "' in " + String.valueOf(iCommonsList.getAllMapped(IIdentifier::getURIEncoded)));
                return null;
            }
        }
        LOGGER.error("The provided Document Type ID uses the unsupported scheme ID '" + string + "'");
        return null;
    }

    @Override
    @Nullable
    public SignedServiceMetadataType getSchemeSpecificServiceMetadataOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeID");
        String string = iDocumentTypeIdentifier.getScheme();
        if (StringHelper.isEmpty((String)string)) {
            LOGGER.error("The provided Document Type ID has no scheme ID");
            return null;
        }
        switch (string) {
            case "busdox-docid-qns": {
                return this.getServiceMetadataOrNull(iParticipantIdentifier, iDocumentTypeIdentifier);
            }
            case "peppol-doctype-wildcard": {
                ServiceGroupType serviceGroupType = this.getServiceGroupOrNull(iParticipantIdentifier);
                if (serviceGroupType == null) {
                    return null;
                }
                ICommonsList<IDocumentTypeIdentifier> iCommonsList = SMPClientReadOnly.getAllDocumentTypes(serviceGroupType);
                LOGGER.info("Found " + iCommonsList.size() + " supported document types for '" + iParticipantIdentifier.getURIEncoded() + "'");
                Wrapper wrapper = new Wrapper();
                if (PeppolWildcardSelector.findPeppolDoctypeWildcardMatch(iCommonsList, iDocumentTypeIdentifier, arg_0 -> ((Wrapper)wrapper).set(arg_0)).isSuccess()) {
                    LOGGER.info("Found matching document type ID '" + ((IDocumentTypeIdentifier)wrapper.get()).getURIEncoded() + "' for '" + iParticipantIdentifier.getURIEncoded() + "'");
                    return this.getServiceMetadataOrNull(iParticipantIdentifier, (IDocumentTypeIdentifier)wrapper.get());
                }
                LOGGER.error("Failed to resolve Wildcard Best Match of '" + iDocumentTypeIdentifier.getURIEncoded() + "' in " + String.valueOf(iCommonsList.getAllMapped(IIdentifier::getURIEncoded)));
                return null;
            }
        }
        LOGGER.error("The provided Document Type ID uses the unsupported scheme ID '" + string + "'");
        return null;
    }

    @Nonnull
    public static ServiceGroupType getServiceGroupByDNS(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull ISMLInfo iSMLInfo, @Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException, SMPDNSResolutionException {
        return new SMPClientReadOnly(iSMPURLProvider, iParticipantIdentifier, iSMLInfo).getServiceGroup(iParticipantIdentifier);
    }

    @Nonnull
    public static SignedServiceMetadataType getServiceRegistrationByDNS(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull ISMLInfo iSMLInfo, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException, SMPDNSResolutionException {
        return new SMPClientReadOnly(iSMPURLProvider, iParticipantIdentifier, iSMLInfo).getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier);
    }
}

