/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.httpclient;

import com.helger.base.debug.GlobalDebug;
import com.helger.httpclient.HttpClientHelper;
import com.helger.smpclient.exception.SMPClientBadResponseException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;

public abstract class AbstractSMPResponseHandler<T>
implements HttpClientResponseHandler<T> {
    @Nullable
    public abstract T handleEntity(@Nonnull HttpEntity var1) throws IOException, SMPClientBadResponseException;

    @Nullable
    public T handleResponse(@Nonnull ClassicHttpResponse classicHttpResponse) throws IOException {
        HttpEntity httpEntity = classicHttpResponse.getEntity();
        if (classicHttpResponse.getCode() >= 300) {
            if (GlobalDebug.isDebugMode()) {
                String string = HttpClientHelper.entityToString((HttpEntity)httpEntity, (Charset)StandardCharsets.UTF_8);
                throw new HttpResponseException(classicHttpResponse.getCode(), classicHttpResponse.getReasonPhrase() + "\n" + string);
            }
            throw new HttpResponseException(classicHttpResponse.getCode(), classicHttpResponse.getReasonPhrase());
        }
        try {
            return httpEntity == null ? null : (T)this.handleEntity(httpEntity);
        }
        catch (SMPClientBadResponseException sMPClientBadResponseException) {
            throw new ClientProtocolException((Throwable)sMPClientBadResponseException);
        }
    }
}

