/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.extension;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.jaxb.adapter.JAXBHelper;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.xml.serialize.read.DOMReader;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import com.helger.xsds.bdxr.smp2.ec.ExtensionContentType;
import com.helger.xsds.bdxr.smp2.ec.SMPExtensionType;
import com.helger.xsds.peppol.smp1.ExtensionType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@NotThreadSafe
@MustImplementEqualsAndHashcode
public class SMPExtension {
    public static final String JSON_ID = "ID";
    public static final String JSON_NAME = "Name";
    public static final String JSON_AGENCY_ID = "AgencyID";
    public static final String JSON_AGENCY_NAME = "AgencyName";
    public static final String JSON_AGENCY_URI = "AgencyURI";
    public static final String JSON_VERSION_ID = "VersionID";
    public static final String JSON_URI = "URI";
    public static final String JSON_REASON_CODE = "ReasonCode";
    public static final String JSON_REASON = "Reason";
    public static final String JSON_ANY = "Any";
    public static final IXMLWriterSettings XWS = new XMLWriterSettings().setIndent(EXMLSerializeIndent.NONE);
    private String m_sExtensionID;
    private String m_sExtensionName;
    private String m_sExtensionAgencyID;
    private String m_sExtensionAgencyName;
    private String m_sExtensionAgencyURI;
    private String m_sExtensionVersionID;
    private String m_sExtensionURI;
    private String m_sExtensionReasonCode;
    private String m_sExtensionReason;
    private Element m_aAny;

    @Nullable
    public String getExtensionID() {
        return this.m_sExtensionID;
    }

    @Nonnull
    public SMPExtension setExtensionID(@Nullable String string) {
        this.m_sExtensionID = string;
        return this;
    }

    @Nullable
    public String getExtensionName() {
        return this.m_sExtensionName;
    }

    @Nonnull
    public SMPExtension setExtensionName(@Nullable String string) {
        this.m_sExtensionName = string;
        return this;
    }

    @Nullable
    public String getExtensionAgencyID() {
        return this.m_sExtensionAgencyID;
    }

    @Nonnull
    public SMPExtension setExtensionAgencyID(@Nullable String string) {
        this.m_sExtensionAgencyID = string;
        return this;
    }

    @Nullable
    public String getExtensionAgencyName() {
        return this.m_sExtensionAgencyName;
    }

    @Nonnull
    public SMPExtension setExtensionAgencyName(@Nullable String string) {
        this.m_sExtensionAgencyName = string;
        return this;
    }

    @Nullable
    public String getExtensionAgencyURI() {
        return this.m_sExtensionAgencyURI;
    }

    @Nonnull
    public SMPExtension setExtensionAgencyURI(@Nullable String string) {
        this.m_sExtensionAgencyURI = string;
        return this;
    }

    @Nullable
    public String getExtensionVersionID() {
        return this.m_sExtensionVersionID;
    }

    @Nonnull
    public SMPExtension setExtensionVersionID(@Nullable String string) {
        this.m_sExtensionVersionID = string;
        return this;
    }

    @Nullable
    public String getExtensionURI() {
        return this.m_sExtensionURI;
    }

    @Nonnull
    public SMPExtension setExtensionURI(@Nullable String string) {
        this.m_sExtensionURI = string;
        return this;
    }

    @Nullable
    public String getExtensionReasonCode() {
        return this.m_sExtensionReasonCode;
    }

    @Nonnull
    public SMPExtension setExtensionReasonCode(@Nullable String string) {
        this.m_sExtensionReasonCode = string;
        return this;
    }

    @Nullable
    public String getExtensionReason() {
        return this.m_sExtensionReason;
    }

    @Nonnull
    public SMPExtension setExtensionReason(@Nullable String string) {
        this.m_sExtensionReason = string;
        return this;
    }

    @Nullable
    public Element getAny() {
        return this.m_aAny;
    }

    @Nonnull
    public SMPExtension setAny(@Nullable Element element) {
        this.m_aAny = element;
        return this;
    }

    @Nullable
    public IJsonObject getAsJsonObject() {
        JsonObject jsonObject = new JsonObject();
        if (this.m_sExtensionID != null) {
            jsonObject.add((Object)JSON_ID, (Object)this.m_sExtensionID);
        }
        if (this.m_sExtensionName != null) {
            jsonObject.add((Object)JSON_NAME, (Object)this.m_sExtensionName);
        }
        if (this.m_sExtensionAgencyID != null) {
            jsonObject.add((Object)JSON_AGENCY_ID, (Object)this.m_sExtensionAgencyID);
        }
        if (this.m_sExtensionAgencyName != null) {
            jsonObject.add((Object)JSON_AGENCY_NAME, (Object)this.m_sExtensionAgencyName);
        }
        if (this.m_sExtensionAgencyURI != null) {
            jsonObject.add((Object)JSON_AGENCY_URI, (Object)this.m_sExtensionAgencyURI);
        }
        if (this.m_sExtensionVersionID != null) {
            jsonObject.add((Object)JSON_VERSION_ID, (Object)this.m_sExtensionVersionID);
        }
        if (this.m_sExtensionURI != null) {
            jsonObject.add((Object)JSON_URI, (Object)this.m_sExtensionURI);
        }
        if (this.m_sExtensionReasonCode != null) {
            jsonObject.add((Object)JSON_REASON_CODE, (Object)this.m_sExtensionReasonCode);
        }
        if (this.m_sExtensionReason != null) {
            jsonObject.add((Object)JSON_REASON, (Object)this.m_sExtensionReason);
        }
        if (this.m_aAny != null) {
            String string = XMLWriter.getNodeAsString((Node)this.m_aAny, (IXMLWriterSettings)XWS);
            jsonObject.add((Object)JSON_ANY, (Object)string);
        }
        return jsonObject.isEmpty() ? null : jsonObject;
    }

    @Nullable
    @ReturnsMutableCopy
    public ExtensionType getAsPeppolExtension() {
        if (this.m_aAny == null) {
            return null;
        }
        ExtensionType extensionType = new ExtensionType();
        extensionType.setAny(this.m_aAny);
        return extensionType;
    }

    @Nonnull
    public com.helger.xsds.bdxr.smp1.ExtensionType getAsBDXRExtension() {
        com.helger.xsds.bdxr.smp1.ExtensionType extensionType = new com.helger.xsds.bdxr.smp1.ExtensionType();
        extensionType.setExtensionID(this.m_sExtensionID);
        extensionType.setExtensionName(this.m_sExtensionName);
        extensionType.setExtensionAgencyID(this.m_sExtensionAgencyID);
        extensionType.setExtensionAgencyName(this.m_sExtensionAgencyName);
        extensionType.setExtensionAgencyURI(this.m_sExtensionAgencyURI);
        extensionType.setExtensionVersionID(this.m_sExtensionVersionID);
        extensionType.setExtensionURI(this.m_sExtensionURI);
        extensionType.setExtensionReasonCode(this.m_sExtensionReasonCode);
        extensionType.setExtensionReason(this.m_sExtensionReason);
        extensionType.setAny((Object)this.m_aAny);
        return extensionType;
    }

    @Nonnull
    public SMPExtensionType getAsBDXR2Extension() {
        SMPExtensionType sMPExtensionType = new SMPExtensionType();
        if (this.m_sExtensionID != null) {
            sMPExtensionType.setID(this.m_sExtensionID);
        }
        if (this.m_sExtensionName != null) {
            sMPExtensionType.setName(this.m_sExtensionName);
        }
        if (this.m_sExtensionAgencyID != null) {
            sMPExtensionType.setExtensionAgencyID(this.m_sExtensionAgencyID);
        }
        if (this.m_sExtensionAgencyName != null) {
            sMPExtensionType.setExtensionAgencyName(this.m_sExtensionAgencyName);
        }
        if (this.m_sExtensionVersionID != null) {
            sMPExtensionType.setExtensionVersionID(this.m_sExtensionVersionID);
        }
        if (this.m_sExtensionAgencyURI != null) {
            sMPExtensionType.setExtensionAgencyURI(this.m_sExtensionAgencyURI);
        }
        if (this.m_sExtensionURI != null) {
            sMPExtensionType.setExtensionURI(this.m_sExtensionURI);
        }
        if (this.m_sExtensionReasonCode != null) {
            sMPExtensionType.setExtensionReasonCode(this.m_sExtensionReasonCode);
        }
        if (this.m_sExtensionReason != null) {
            sMPExtensionType.setExtensionReason(this.m_sExtensionReason);
        }
        if (this.m_aAny != null) {
            ExtensionContentType extensionContentType = new ExtensionContentType();
            extensionContentType.setAny((Object)this.m_aAny);
            sMPExtensionType.setExtensionContent(extensionContentType);
        }
        return sMPExtensionType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SMPExtension sMPExtension = (SMPExtension)object;
        return EqualsHelper.equals((Object)this.m_sExtensionID, (Object)sMPExtension.m_sExtensionID) && EqualsHelper.equals((Object)this.m_sExtensionName, (Object)sMPExtension.m_sExtensionName) && EqualsHelper.equals((Object)this.m_sExtensionAgencyID, (Object)sMPExtension.m_sExtensionAgencyID) && EqualsHelper.equals((Object)this.m_sExtensionAgencyName, (Object)sMPExtension.m_sExtensionAgencyName) && EqualsHelper.equals((Object)this.m_sExtensionAgencyURI, (Object)sMPExtension.m_sExtensionAgencyURI) && EqualsHelper.equals((Object)this.m_sExtensionVersionID, (Object)sMPExtension.m_sExtensionVersionID) && EqualsHelper.equals((Object)this.m_sExtensionURI, (Object)sMPExtension.m_sExtensionURI) && EqualsHelper.equals((Object)this.m_sExtensionReasonCode, (Object)sMPExtension.m_sExtensionReasonCode) && EqualsHelper.equals((Object)this.m_sExtensionReason, (Object)sMPExtension.m_sExtensionReason) && JAXBHelper.equalDOMNodes((Node)this.m_aAny, (Node)sMPExtension.m_aAny);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sExtensionID).append((Object)this.m_sExtensionName).append((Object)this.m_sExtensionAgencyID).append((Object)this.m_sExtensionAgencyName).append((Object)this.m_sExtensionAgencyURI).append((Object)this.m_sExtensionVersionID).append((Object)this.m_sExtensionURI).append((Object)this.m_sExtensionReasonCode).append((Object)this.m_sExtensionReason).append(JAXBHelper.getHashCode((Node)this.m_aAny)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ExtensionID", (Object)this.m_sExtensionID).append("ExtensionName", (Object)this.m_sExtensionName).append("ExtensionAgencyID", (Object)this.m_sExtensionAgencyID).append("ExtensionAgencyName", (Object)this.m_sExtensionAgencyName).append("ExtensionAgencyURI", (Object)this.m_sExtensionAgencyURI).append("ExtensionVersionID", (Object)this.m_sExtensionVersionID).append("ExtensionURI", (Object)this.m_sExtensionURI).append("ExtensionReasonCode", (Object)this.m_sExtensionReasonCode).append("ExtensionReason", (Object)this.m_sExtensionReason).append(JSON_ANY, (Object)this.m_aAny).getToString();
    }

    @Nullable
    public static SMPExtension ofJson(@Nullable IJsonObject iJsonObject) {
        Document document;
        if (iJsonObject == null || iJsonObject.isEmpty()) {
            return null;
        }
        SMPExtension sMPExtension = new SMPExtension();
        sMPExtension.setExtensionID(iJsonObject.getAsString((Object)JSON_ID));
        sMPExtension.setExtensionName(iJsonObject.getAsString((Object)JSON_NAME));
        sMPExtension.setExtensionAgencyID(iJsonObject.getAsString((Object)JSON_AGENCY_ID));
        sMPExtension.setExtensionAgencyName(iJsonObject.getAsString((Object)JSON_AGENCY_NAME));
        sMPExtension.setExtensionAgencyURI(iJsonObject.getAsString((Object)JSON_AGENCY_URI));
        sMPExtension.setExtensionVersionID(iJsonObject.getAsString((Object)JSON_VERSION_ID));
        sMPExtension.setExtensionURI(iJsonObject.getAsString((Object)JSON_URI));
        sMPExtension.setExtensionReasonCode(iJsonObject.getAsString((Object)JSON_REASON_CODE));
        sMPExtension.setExtensionReason(iJsonObject.getAsString((Object)JSON_REASON));
        String string = iJsonObject.getAsString((Object)JSON_ANY);
        if (StringHelper.isNotEmpty((String)string) && (document = DOMReader.readXMLDOM((String)string)) != null) {
            sMPExtension.setAny(document.getDocumentElement());
        }
        return sMPExtension;
    }

    @Nullable
    public static SMPExtension ofXML(@Nullable String string) {
        Element element;
        Document document;
        if (StringHelper.isNotEmpty((String)string) && (document = DOMReader.readXMLDOM((String)string)) != null && (element = document.getDocumentElement()) != null) {
            SMPExtension sMPExtension = new SMPExtension();
            sMPExtension.setAny(element);
            return sMPExtension;
        }
        return null;
    }

    @Nullable
    public static SMPExtension ofBDXR1(@Nullable com.helger.xsds.bdxr.smp1.ExtensionType extensionType) {
        if (extensionType == null) {
            return null;
        }
        SMPExtension sMPExtension = new SMPExtension();
        sMPExtension.setExtensionID(extensionType.getExtensionID());
        sMPExtension.setExtensionName(extensionType.getExtensionName());
        sMPExtension.setExtensionAgencyID(extensionType.getExtensionAgencyID());
        sMPExtension.setExtensionAgencyName(extensionType.getExtensionAgencyName());
        sMPExtension.setExtensionAgencyURI(extensionType.getExtensionAgencyURI());
        sMPExtension.setExtensionVersionID(extensionType.getExtensionVersionID());
        sMPExtension.setExtensionURI(extensionType.getExtensionURI());
        sMPExtension.setExtensionReasonCode(extensionType.getExtensionReasonCode());
        sMPExtension.setExtensionReason(extensionType.getExtensionReason());
        Object object = extensionType.getAny();
        if (object instanceof Element) {
            Element element = (Element)object;
            sMPExtension.setAny(element);
        }
        return sMPExtension;
    }

    @Nullable
    public static SMPExtension ofBDXR2(@Nullable SMPExtensionType sMPExtensionType) {
        Object object;
        if (sMPExtensionType == null) {
            return null;
        }
        SMPExtension sMPExtension = new SMPExtension();
        sMPExtension.setExtensionID(sMPExtensionType.getIDValue());
        sMPExtension.setExtensionName(sMPExtensionType.getNameValue());
        sMPExtension.setExtensionAgencyID(sMPExtensionType.getExtensionAgencyIDValue());
        sMPExtension.setExtensionAgencyName(sMPExtensionType.getExtensionAgencyNameValue());
        sMPExtension.setExtensionAgencyURI(sMPExtensionType.getExtensionAgencyURIValue());
        sMPExtension.setExtensionVersionID(sMPExtensionType.getExtensionVersionIDValue());
        sMPExtension.setExtensionURI(sMPExtensionType.getExtensionURIValue());
        sMPExtension.setExtensionReasonCode(sMPExtensionType.getExtensionReasonCodeValue());
        sMPExtension.setExtensionReason(sMPExtensionType.getExtensionReasonValue());
        ExtensionContentType extensionContentType = sMPExtensionType.getExtensionContent();
        if (extensionContentType != null && (object = extensionContentType.getAny()) instanceof Element) {
            Element element = (Element)object;
            sMPExtension.setAny(element);
        }
        return sMPExtension;
    }
}

