/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.bdxr1;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.security.certificate.CertificateHelper;
import com.helger.smpclient.bdxr1.BDXRClientReadOnly;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.redirect.ISMPFollowRedirectCallback;
import com.helger.xsds.bdxr.smp1.EndpointType;
import com.helger.xsds.bdxr.smp1.SignedServiceMetadataType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public interface IBDXRServiceMetadataProvider {
    @Nullable
    default public SignedServiceMetadataType getServiceMetadataOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        return this.getServiceMetadataOrNull(iParticipantIdentifier, iDocumentTypeIdentifier, null);
    }

    @Nullable
    public SignedServiceMetadataType getServiceMetadataOrNull(@Nonnull IParticipantIdentifier var1, @Nonnull IDocumentTypeIdentifier var2, @Nullable ISMPFollowRedirectCallback var3) throws SMPClientException;

    @Nullable
    default public EndpointType getEndpoint(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeID");
        ValueEnforcer.notNull((Object)iProcessIdentifier, (String)"ProcessID");
        ValueEnforcer.notNull((Object)iSMPTransportProfile, (String)"TransportProfile");
        SignedServiceMetadataType signedServiceMetadataType = this.getServiceMetadataOrNull(iParticipantIdentifier, iDocumentTypeIdentifier);
        return signedServiceMetadataType == null ? null : BDXRClientReadOnly.getEndpoint(signedServiceMetadataType, iProcessIdentifier, iSMPTransportProfile);
    }

    @Nullable
    default public String getEndpointAddress(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException {
        EndpointType endpointType = this.getEndpoint(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile);
        return BDXRClientReadOnly.getEndpointAddress(endpointType);
    }

    @Nullable
    default public byte[] getEndpointCertificateBytes(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException {
        EndpointType endpointType = this.getEndpoint(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile);
        return BDXRClientReadOnly.getEndpointCertificateBytes(endpointType);
    }

    @Nullable
    default public X509Certificate getEndpointCertificate(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException, CertificateException {
        byte[] byArray = this.getEndpointCertificateBytes(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile);
        return CertificateHelper.convertByteArrayToCertficateDirect((byte[])byArray);
    }
}

