/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.smlclient.tls;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.id.IHasID;
import com.helger.base.lang.EnumHelper;
import com.helger.collection.commons.ICommonsList;
import com.helger.http.tls.ETLSVersion;
import com.helger.http.tls.ITLSConfigurationMode;
import com.helger.http.tls.TLSConfigurationMode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum ETLSConfigurationMode_CEF_SML implements IHasID<String>,
ITLSConfigurationMode
{
    HIGH("high", new ETLSVersion[]{ETLSVersion.TLS_12}, new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"}),
    MEDIUM("medium", new ETLSVersion[]{ETLSVersion.TLS_12}, new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA"});

    private final String m_sID;
    private final TLSConfigurationMode m_aMode;

    private ETLSConfigurationMode_CEF_SML(@Nonnull @Nonempty String string2, ETLSVersion[] eTLSVersionArray, String[] stringArray) {
        this.m_sID = string2;
        this.m_aMode = new TLSConfigurationMode(eTLSVersionArray, stringArray);
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllCipherSuites() {
        return this.m_aMode.getAllCipherSuites();
    }

    @Nonnull
    @ReturnsMutableCopy
    public String[] getAllCipherSuitesAsArray() {
        return this.m_aMode.getAllCipherSuitesAsArray();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ETLSVersion> getAllTLSVersions() {
        return this.m_aMode.getAllTLSVersions();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllTLSVersionIDs() {
        return this.m_aMode.getAllTLSVersionIDs();
    }

    @Nonnull
    @ReturnsMutableCopy
    public String[] getAllTLSVersionIDsAsArray() {
        return this.m_aMode.getAllTLSVersionIDsAsArray();
    }

    @Nullable
    public static ETLSConfigurationMode_CEF_SML getFromIDOrNull(@Nullable String string) {
        return (ETLSConfigurationMode_CEF_SML)EnumHelper.getFromIDOrNull(ETLSConfigurationMode_CEF_SML.class, (Object)string);
    }
}

