/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.smlclient.bdmsl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.peppolid.IParticipantIdentifier;
import jakarta.annotation.Nonnull;
import java.io.Serializable;

@Immutable
public class ParticipantListItem
implements Serializable {
    private final String m_sSMPID;
    private final IParticipantIdentifier m_aParticipantID;

    public ParticipantListItem(@Nonnull @Nonempty String string, @Nonnull IParticipantIdentifier iParticipantIdentifier) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SMPID");
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        this.m_sSMPID = string;
        this.m_aParticipantID = iParticipantIdentifier;
    }

    @Nonnull
    @Nonempty
    public String getSMPID() {
        return this.m_sSMPID;
    }

    @Nonnull
    public IParticipantIdentifier getParticipantID() {
        return this.m_aParticipantID;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ParticipantListItem participantListItem = (ParticipantListItem)object;
        return this.m_sSMPID.equals(participantListItem.m_sSMPID) && this.m_aParticipantID.equals((Object)participantListItem.m_aParticipantID);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sSMPID).append((Object)this.m_aParticipantID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("SMPID", (Object)this.m_sSMPID).append("ParticipantID", (Object)this.m_aParticipantID).getToString();
    }
}

