/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.smlclient;

import com.helger.annotation.Nonempty;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppol.smlclient.smp.BadRequestFault;
import com.helger.peppol.smlclient.smp.InternalErrorFault;
import com.helger.peppol.smlclient.smp.ManageServiceMetadataService;
import com.helger.peppol.smlclient.smp.ManageServiceMetadataServiceSoap;
import com.helger.peppol.smlclient.smp.NotFoundFault;
import com.helger.peppol.smlclient.smp.PublisherEndpointType;
import com.helger.peppol.smlclient.smp.ServiceMetadataPublisherServiceType;
import com.helger.peppol.smlclient.smp.UnauthorizedFault;
import com.helger.wsclient.WSClientConfig;
import jakarta.annotation.Nonnull;
import jakarta.xml.ws.BindingProvider;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageServiceMetadataServiceCaller
extends WSClientConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManageServiceMetadataServiceCaller.class);

    public ManageServiceMetadataServiceCaller(@Nonnull ISMLInfo iSMLInfo) {
        this(iSMLInfo.getManageServiceMetaDataEndpointAddress());
    }

    public ManageServiceMetadataServiceCaller(@Nonnull URL uRL) {
        super(uRL);
    }

    @Nonnull
    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected ManageServiceMetadataServiceSoap createWSPort() {
        ManageServiceMetadataService manageServiceMetadataService = new ManageServiceMetadataService();
        ManageServiceMetadataServiceSoap manageServiceMetadataServiceSoap = manageServiceMetadataService.getManageServiceMetadataServicePort();
        this.applyWSSettingsToBindingProvider((BindingProvider)manageServiceMetadataServiceSoap);
        return manageServiceMetadataServiceSoap;
    }

    @OverrideOnDemand
    protected void validatePhysicalAddress(@Nonnull @Nonempty String string) {
    }

    @OverrideOnDemand
    protected void validateLogicalAddress(@Nonnull @Nonempty String string) {
    }

    public void create(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3) throws BadRequestFault, InternalErrorFault, UnauthorizedFault {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SMPID");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"SMPAddressPhysical");
        ValueEnforcer.notEmpty((CharSequence)string3, (String)"SMPAddressLogical");
        this.validatePhysicalAddress(string2);
        this.validateLogicalAddress(string3);
        ServiceMetadataPublisherServiceType serviceMetadataPublisherServiceType = new ServiceMetadataPublisherServiceType();
        serviceMetadataPublisherServiceType.setServiceMetadataPublisherID(string);
        PublisherEndpointType publisherEndpointType = new PublisherEndpointType();
        publisherEndpointType.setLogicalAddress(string3);
        publisherEndpointType.setPhysicalAddress(string2);
        serviceMetadataPublisherServiceType.setPublisherEndpoint(publisherEndpointType);
        this.create(serviceMetadataPublisherServiceType);
    }

    public void create(@Nonnull ServiceMetadataPublisherServiceType serviceMetadataPublisherServiceType) throws BadRequestFault, InternalErrorFault, UnauthorizedFault {
        ValueEnforcer.notNull((Object)serviceMetadataPublisherServiceType, (String)"ServiceMetadata");
        ValueEnforcer.notEmpty((CharSequence)serviceMetadataPublisherServiceType.getServiceMetadataPublisherID(), (String)"ServiceMetadata.ServiceMetadataPublisherID");
        ValueEnforcer.notNull((Object)serviceMetadataPublisherServiceType.getPublisherEndpoint(), (String)"ServiceMetadata.PublisherEndpoint");
        ValueEnforcer.notEmpty((CharSequence)serviceMetadataPublisherServiceType.getPublisherEndpoint().getPhysicalAddress(), (String)"ServiceMetadata.PublisherEndpoint.PhysicalAddress");
        ValueEnforcer.notEmpty((CharSequence)serviceMetadataPublisherServiceType.getPublisherEndpoint().getLogicalAddress(), (String)"ServiceMetadata.PublisherEndpoint.LogicalAddress");
        LOGGER.info("Trying to create new SMP '" + serviceMetadataPublisherServiceType.getServiceMetadataPublisherID() + "' with physical address '" + serviceMetadataPublisherServiceType.getPublisherEndpoint().getPhysicalAddress() + "' and logical address '" + serviceMetadataPublisherServiceType.getPublisherEndpoint().getLogicalAddress() + "'");
        this.createWSPort().create(serviceMetadataPublisherServiceType);
    }

    public void update(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3) throws InternalErrorFault, NotFoundFault, UnauthorizedFault, BadRequestFault {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SMPID");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"SMPAddressPhysical");
        ValueEnforcer.notEmpty((CharSequence)string3, (String)"SMPAddressLogical");
        this.validatePhysicalAddress(string2);
        this.validateLogicalAddress(string3);
        ServiceMetadataPublisherServiceType serviceMetadataPublisherServiceType = new ServiceMetadataPublisherServiceType();
        serviceMetadataPublisherServiceType.setServiceMetadataPublisherID(string);
        PublisherEndpointType publisherEndpointType = new PublisherEndpointType();
        publisherEndpointType.setLogicalAddress(string3);
        publisherEndpointType.setPhysicalAddress(string2);
        serviceMetadataPublisherServiceType.setPublisherEndpoint(publisherEndpointType);
        this.update(serviceMetadataPublisherServiceType);
    }

    public void update(@Nonnull ServiceMetadataPublisherServiceType serviceMetadataPublisherServiceType) throws InternalErrorFault, NotFoundFault, UnauthorizedFault, BadRequestFault {
        ValueEnforcer.notNull((Object)serviceMetadataPublisherServiceType, (String)"ServiceMetadata");
        ValueEnforcer.notEmpty((CharSequence)serviceMetadataPublisherServiceType.getServiceMetadataPublisherID(), (String)"ServiceMetadata.ServiceMetadataPublisherID");
        ValueEnforcer.notNull((Object)serviceMetadataPublisherServiceType.getPublisherEndpoint(), (String)"ServiceMetadata.PublisherEndpoint");
        ValueEnforcer.notEmpty((CharSequence)serviceMetadataPublisherServiceType.getPublisherEndpoint().getPhysicalAddress(), (String)"ServiceMetadata.PublisherEndpoint.PhysicalAddress");
        ValueEnforcer.notEmpty((CharSequence)serviceMetadataPublisherServiceType.getPublisherEndpoint().getLogicalAddress(), (String)"ServiceMetadata.PublisherEndpoint.LogicalAddress");
        LOGGER.info("Trying to update SMP '" + serviceMetadataPublisherServiceType.getServiceMetadataPublisherID() + "' with physical address '" + serviceMetadataPublisherServiceType.getPublisherEndpoint().getPhysicalAddress() + "' and logical address '" + serviceMetadataPublisherServiceType.getPublisherEndpoint().getLogicalAddress() + "'");
        this.createWSPort().update(serviceMetadataPublisherServiceType);
    }

    public void delete(@Nonnull @Nonempty String string) throws InternalErrorFault, NotFoundFault, UnauthorizedFault, BadRequestFault {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SMPID");
        LOGGER.info("Trying to delete SMP '" + string + "'");
        this.createWSPort().delete(string);
    }

    @Nonnull
    public ServiceMetadataPublisherServiceType read(@Nonnull @Nonempty String string) throws InternalErrorFault, NotFoundFault, UnauthorizedFault, BadRequestFault {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SMPID");
        ServiceMetadataPublisherServiceType serviceMetadataPublisherServiceType = new ServiceMetadataPublisherServiceType();
        serviceMetadataPublisherServiceType.setServiceMetadataPublisherID(string);
        return this.read(serviceMetadataPublisherServiceType);
    }

    @Nonnull
    public ServiceMetadataPublisherServiceType read(@Nonnull ServiceMetadataPublisherServiceType serviceMetadataPublisherServiceType) throws InternalErrorFault, NotFoundFault, UnauthorizedFault, BadRequestFault {
        ValueEnforcer.notNull((Object)serviceMetadataPublisherServiceType, (String)"SMPService");
        ValueEnforcer.notEmpty((CharSequence)serviceMetadataPublisherServiceType.getServiceMetadataPublisherID(), (String)"SMPService.ServiceMetadataPublisherID");
        LOGGER.info("Trying to read SMP '" + serviceMetadataPublisherServiceType.getServiceMetadataPublisherID() + "'");
        return this.createWSPort().read(serviceMetadataPublisherServiceType);
    }
}

