/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.smlclient;

import com.helger.annotation.Nonempty;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringImplode;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppol.smlclient.participant.BadRequestFault;
import com.helger.peppol.smlclient.participant.InternalErrorFault;
import com.helger.peppol.smlclient.participant.ManageBusinessIdentifierService;
import com.helger.peppol.smlclient.participant.ManageBusinessIdentifierServiceSoap;
import com.helger.peppol.smlclient.participant.MigrationRecordType;
import com.helger.peppol.smlclient.participant.NotFoundFault;
import com.helger.peppol.smlclient.participant.PageRequestType;
import com.helger.peppol.smlclient.participant.ParticipantIdentifierPageType;
import com.helger.peppol.smlclient.participant.ServiceMetadataPublisherServiceForParticipantType;
import com.helger.peppol.smlclient.participant.UnauthorizedFault;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.simple.participant.SimpleParticipantIdentifier;
import com.helger.wsclient.WSClientConfig;
import com.helger.xsds.peppol.id1.ParticipantIdentifierType;
import jakarta.annotation.Nonnull;
import jakarta.xml.ws.BindingProvider;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageParticipantIdentifierServiceCaller
extends WSClientConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManageParticipantIdentifierServiceCaller.class);
    private static final char[] MK_LOWER = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final char[] MK_UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] MK_DIGITS = "0123456789".toCharArray();
    private static final char[] MK_SPECIAL = "@#$%()[]{}*^-!~|+=".toCharArray();
    private static final char[] MK_ALL = ArrayHelper.getConcatenated((char[])MK_LOWER, (char[])ArrayHelper.getConcatenated((char[])MK_UPPER, (char[])ArrayHelper.getConcatenated((char[])MK_DIGITS, (char[])MK_SPECIAL)));

    public ManageParticipantIdentifierServiceCaller(@Nonnull ISMLInfo iSMLInfo) {
        this(iSMLInfo.getManageParticipantIdentifierEndpointAddress());
    }

    public ManageParticipantIdentifierServiceCaller(@Nonnull URL uRL) {
        super(uRL);
    }

    @Nonnull
    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected ManageBusinessIdentifierServiceSoap createWSPort() {
        ManageBusinessIdentifierService manageBusinessIdentifierService = new ManageBusinessIdentifierService();
        ManageBusinessIdentifierServiceSoap manageBusinessIdentifierServiceSoap = manageBusinessIdentifierService.getManageBusinessIdentifierServicePort();
        this.applyWSSettingsToBindingProvider((BindingProvider)manageBusinessIdentifierServiceSoap);
        return manageBusinessIdentifierServiceSoap;
    }

    public void create(@Nonnull @Nonempty String string, @Nonnull IParticipantIdentifier iParticipantIdentifier) throws BadRequestFault, InternalErrorFault, UnauthorizedFault, NotFoundFault {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SMPID");
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"Identifier");
        ServiceMetadataPublisherServiceForParticipantType serviceMetadataPublisherServiceForParticipantType = new ServiceMetadataPublisherServiceForParticipantType();
        serviceMetadataPublisherServiceForParticipantType.setServiceMetadataPublisherID(string);
        serviceMetadataPublisherServiceForParticipantType.setParticipantIdentifier((ParticipantIdentifierType)new SimpleParticipantIdentifier(iParticipantIdentifier));
        this.create(serviceMetadataPublisherServiceForParticipantType);
    }

    public void create(@Nonnull ServiceMetadataPublisherServiceForParticipantType serviceMetadataPublisherServiceForParticipantType) throws BadRequestFault, InternalErrorFault, UnauthorizedFault, NotFoundFault {
        ValueEnforcer.notNull((Object)serviceMetadataPublisherServiceForParticipantType, (String)"SMPParticpantService");
        ValueEnforcer.notNull((Object)serviceMetadataPublisherServiceForParticipantType.getParticipantIdentifier(), (String)"SMPParticpantService.ParticipantIdentifier");
        ValueEnforcer.notEmpty((CharSequence)serviceMetadataPublisherServiceForParticipantType.getServiceMetadataPublisherID(), (String)"SMPParticpantService.ServiceMetadataPublisherID");
        LOGGER.info("Trying to create new participant " + CIdentifier.getURIEncoded((ParticipantIdentifierType)serviceMetadataPublisherServiceForParticipantType.getParticipantIdentifier()) + " in SMP '" + serviceMetadataPublisherServiceForParticipantType.getServiceMetadataPublisherID() + "'");
        this.createWSPort().create(serviceMetadataPublisherServiceForParticipantType);
    }

    @Nonnull
    private static String _toString(@Nonnull Collection<? extends IParticipantIdentifier> collection) {
        return StringImplode.imploder().separator(", ").source(collection, IIdentifier::getURIEncoded).build();
    }

    @Nonnull
    private static String _toString2(@Nonnull Collection<? extends ParticipantIdentifierType> collection) {
        return StringImplode.imploder().separator(", ").source(collection, CIdentifier::getURIEncoded).build();
    }

    public void createList(@Nonnull @Nonempty Collection<? extends IParticipantIdentifier> collection, @Nonnull @Nonempty String string) throws BadRequestFault, InternalErrorFault, NotFoundFault, UnauthorizedFault {
        ValueEnforcer.notEmptyNoNullValue(collection, (String)"ParticipantIdentifiers");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SMPID");
        LOGGER.info("Trying to create multiple new participants " + ManageParticipantIdentifierServiceCaller._toString(collection) + " in SMP '" + string + "'");
        ParticipantIdentifierPageType participantIdentifierPageType = new ParticipantIdentifierPageType();
        for (IParticipantIdentifier iParticipantIdentifier : collection) {
            participantIdentifierPageType.addParticipantIdentifier((ParticipantIdentifierType)new SimpleParticipantIdentifier(iParticipantIdentifier));
        }
        participantIdentifierPageType.setServiceMetadataPublisherID(string);
        this.createWSPort().createList(participantIdentifierPageType);
    }

    public void delete(@Nonnull @Nonempty String string, @Nonnull IParticipantIdentifier iParticipantIdentifier) throws BadRequestFault, InternalErrorFault, NotFoundFault, UnauthorizedFault {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"Identifier");
        ServiceMetadataPublisherServiceForParticipantType serviceMetadataPublisherServiceForParticipantType = new ServiceMetadataPublisherServiceForParticipantType();
        serviceMetadataPublisherServiceForParticipantType.setServiceMetadataPublisherID(string);
        serviceMetadataPublisherServiceForParticipantType.setParticipantIdentifier((ParticipantIdentifierType)new SimpleParticipantIdentifier(iParticipantIdentifier));
        this.delete(serviceMetadataPublisherServiceForParticipantType);
    }

    public void delete(@Nonnull ServiceMetadataPublisherServiceForParticipantType serviceMetadataPublisherServiceForParticipantType) throws BadRequestFault, InternalErrorFault, NotFoundFault, UnauthorizedFault {
        ValueEnforcer.notNull((Object)serviceMetadataPublisherServiceForParticipantType, (String)"SMPParticpantService");
        ValueEnforcer.notNull((Object)serviceMetadataPublisherServiceForParticipantType.getParticipantIdentifier(), (String)"SMPParticpantService.ParticipantIdentifier");
        LOGGER.info("Trying to delete participant " + CIdentifier.getURIEncoded((ParticipantIdentifierType)serviceMetadataPublisherServiceForParticipantType.getParticipantIdentifier()));
        this.createWSPort().delete(serviceMetadataPublisherServiceForParticipantType);
    }

    public void deleteList(@Nonnull @Nonempty Collection<? extends ParticipantIdentifierType> collection) throws BadRequestFault, InternalErrorFault, NotFoundFault, UnauthorizedFault {
        ValueEnforcer.notEmptyNoNullValue(collection, (String)"ParticipantIdentifiers");
        LOGGER.info("Trying to delete multiple participants " + ManageParticipantIdentifierServiceCaller._toString2(collection));
        ParticipantIdentifierPageType participantIdentifierPageType = new ParticipantIdentifierPageType();
        for (ParticipantIdentifierType participantIdentifierType : collection) {
            participantIdentifierPageType.addParticipantIdentifier(participantIdentifierType.clone());
        }
        this.createWSPort().deleteList(participantIdentifierPageType);
    }

    public ParticipantIdentifierPageType list(@Nonnull String string, @Nonnull @Nonempty String string2) throws BadRequestFault, InternalErrorFault, NotFoundFault, UnauthorizedFault {
        ValueEnforcer.notNull((Object)string, (String)"PageId");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"SMPID");
        PageRequestType pageRequestType = new PageRequestType();
        pageRequestType.setServiceMetadataPublisherID(string2);
        pageRequestType.setNextPageIdentifier(string);
        return this.list(pageRequestType);
    }

    public ParticipantIdentifierPageType list(@Nonnull PageRequestType pageRequestType) throws BadRequestFault, InternalErrorFault, NotFoundFault, UnauthorizedFault {
        ValueEnforcer.notNull((Object)pageRequestType, (String)"PageRequest");
        ValueEnforcer.notEmpty((CharSequence)pageRequestType.getServiceMetadataPublisherID(), (String)"PageRequest.ServiceMetadataPublisherID");
        LOGGER.info("Trying to list participants in SMP '" + pageRequestType.getServiceMetadataPublisherID() + "'");
        return this.createWSPort().list(pageRequestType);
    }

    private static char _random(@Nonnull char[] cArray) {
        int n = ThreadLocalRandom.current().nextInt(cArray.length);
        return cArray[n];
    }

    @Nonnull
    @Nonempty
    public static final String createRandomMigrationKey() {
        StringBuilder stringBuilder = new StringBuilder(24);
        stringBuilder.append(ManageParticipantIdentifierServiceCaller._random(MK_LOWER));
        stringBuilder.append(ManageParticipantIdentifierServiceCaller._random(MK_UPPER));
        stringBuilder.append(ManageParticipantIdentifierServiceCaller._random(MK_DIGITS));
        stringBuilder.append(ManageParticipantIdentifierServiceCaller._random(MK_SPECIAL));
        stringBuilder.append(ManageParticipantIdentifierServiceCaller._random(MK_LOWER));
        stringBuilder.append(ManageParticipantIdentifierServiceCaller._random(MK_UPPER));
        stringBuilder.append(ManageParticipantIdentifierServiceCaller._random(MK_DIGITS));
        stringBuilder.append(ManageParticipantIdentifierServiceCaller._random(MK_SPECIAL));
        for (int i = 8; i < 24; ++i) {
            stringBuilder.append(ManageParticipantIdentifierServiceCaller._random(MK_ALL));
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public String prepareToMigrate(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string) throws BadRequestFault, InternalErrorFault, NotFoundFault, UnauthorizedFault {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"Identifier");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SMPID");
        String string2 = ManageParticipantIdentifierServiceCaller.createRandomMigrationKey();
        return this.prepareToMigrate(iParticipantIdentifier, string2, string);
    }

    @Nonnull
    public String prepareToMigrate(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) throws BadRequestFault, InternalErrorFault, NotFoundFault, UnauthorizedFault {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"Identifier");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"SMPID");
        LOGGER.info("Preparing to migrate participant " + iParticipantIdentifier.getURIEncoded() + " from SMP '" + string2 + "' using migration key '" + string + "'");
        MigrationRecordType migrationRecordType = new MigrationRecordType();
        migrationRecordType.setParticipantIdentifier((ParticipantIdentifierType)new SimpleParticipantIdentifier(iParticipantIdentifier));
        migrationRecordType.setMigrationKey(string);
        migrationRecordType.setServiceMetadataPublisherID(string2);
        this.createWSPort().prepareToMigrate(migrationRecordType);
        LOGGER.info("Successfully called 'prepareToMigrate'");
        return string;
    }

    public void migrate(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) throws BadRequestFault, InternalErrorFault, NotFoundFault, UnauthorizedFault {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"Identifier");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"MigrationKey");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"SMPID");
        LOGGER.info("Finishing migration of participant " + iParticipantIdentifier.getURIEncoded() + " to SMP '" + string2 + "' using migration key '" + string + "'");
        MigrationRecordType migrationRecordType = new MigrationRecordType();
        migrationRecordType.setParticipantIdentifier((ParticipantIdentifierType)new SimpleParticipantIdentifier(iParticipantIdentifier));
        migrationRecordType.setMigrationKey(string);
        migrationRecordType.setServiceMetadataPublisherID(string2);
        this.createWSPort().migrate(migrationRecordType);
        LOGGER.info("Successfully called 'migrate'");
    }
}

