/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.smlclient;

import com.helger.annotation.Nonempty;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.url.URLHelper;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppol.smlclient.bdmsl.BDMSLService;
import com.helger.peppol.smlclient.bdmsl.BDMSLServiceSoap;
import com.helger.peppol.smlclient.bdmsl.BadRequestFault;
import com.helger.peppol.smlclient.bdmsl.InternalErrorFault;
import com.helger.peppol.smlclient.bdmsl.IsAliveType;
import com.helger.peppol.smlclient.bdmsl.NotFoundFault;
import com.helger.peppol.smlclient.bdmsl.PrepareChangeCertificateType;
import com.helger.peppol.smlclient.bdmsl.SMPAdvancedServiceForParticipantType;
import com.helger.peppol.smlclient.bdmsl.ServiceMetadataPublisherServiceForParticipantType;
import com.helger.peppol.smlclient.bdmsl.UnauthorizedFault;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.simple.participant.SimpleParticipantIdentifier;
import com.helger.wsclient.WSClientConfig;
import com.helger.xsds.peppol.id1.ParticipantIdentifierType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.WebServiceException;
import java.net.URL;
import java.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDMSLClient
extends WSClientConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(BDMSLClient.class);

    public BDMSLClient(@Nonnull ISMLInfo iSMLInfo) {
        super(URLHelper.getAsURL((String)(iSMLInfo.getManagementServiceURL() + "/bdmslservice")));
    }

    public BDMSLClient(@Nonnull URL uRL) {
        super(uRL);
    }

    @Nonnull
    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    protected BDMSLServiceSoap createWSPort() {
        BDMSLService bDMSLService = new BDMSLService();
        BDMSLServiceSoap bDMSLServiceSoap = bDMSLService.getBDMSLServicePort();
        this.applyWSSettingsToBindingProvider((BindingProvider)bDMSLServiceSoap);
        return bDMSLServiceSoap;
    }

    public void prepareChangeCertificate(@Nonnull @Nonempty String string, @Nullable LocalDate localDate) throws BadRequestFault, InternalErrorFault, NotFoundFault, UnauthorizedFault {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"NewCertificatePublicKey");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("prepareChangeCertificate (" + string + ", " + String.valueOf(localDate) + ")");
        }
        PrepareChangeCertificateType prepareChangeCertificateType = new PrepareChangeCertificateType();
        prepareChangeCertificateType.setNewCertificatePublicKey(string);
        prepareChangeCertificateType.setMigrationDate(localDate);
        this.createWSPort().prepareChangeCertificate(prepareChangeCertificateType);
    }

    public void createParticipantIdentifier(@Nonnull @Nonempty String string, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string2) throws BadRequestFault, InternalErrorFault, NotFoundFault, UnauthorizedFault {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SMPID");
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"ServiceName");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("createParticipantIdentifier (" + string + ", " + String.valueOf(iParticipantIdentifier) + ", " + string2 + ")");
        }
        SMPAdvancedServiceForParticipantType sMPAdvancedServiceForParticipantType = new SMPAdvancedServiceForParticipantType();
        ServiceMetadataPublisherServiceForParticipantType serviceMetadataPublisherServiceForParticipantType = new ServiceMetadataPublisherServiceForParticipantType();
        serviceMetadataPublisherServiceForParticipantType.setServiceMetadataPublisherID(string);
        serviceMetadataPublisherServiceForParticipantType.setParticipantIdentifier((ParticipantIdentifierType)new SimpleParticipantIdentifier(iParticipantIdentifier));
        sMPAdvancedServiceForParticipantType.setCreateParticipantIdentifier(serviceMetadataPublisherServiceForParticipantType);
        sMPAdvancedServiceForParticipantType.setServiceName(string2);
        this.createWSPort().createParticipantIdentifier(sMPAdvancedServiceForParticipantType);
    }

    public boolean isAlive() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("isAlive ()");
        }
        try {
            IsAliveType isAliveType = new IsAliveType();
            this.createWSPort().isAlive(isAliveType);
            return true;
        }
        catch (InternalErrorFault | WebServiceException throwable) {
            return false;
        }
    }
}

