/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.sbdh;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.peppol.sbdh.PeppolSBDHData;
import jakarta.annotation.Nonnull;
import java.util.Map;
import org.unece.cefact.namespaces.sbdh.BusinessScope;
import org.unece.cefact.namespaces.sbdh.DocumentIdentification;
import org.unece.cefact.namespaces.sbdh.Partner;
import org.unece.cefact.namespaces.sbdh.PartnerIdentification;
import org.unece.cefact.namespaces.sbdh.Scope;
import org.unece.cefact.namespaces.sbdh.StandardBusinessDocument;
import org.unece.cefact.namespaces.sbdh.StandardBusinessDocumentHeader;

@NotThreadSafe
public class PeppolSBDHDataWriter {
    public static final boolean DEFAULT_FAVOUR_SPEED = false;
    private String m_sHeaderVersion = "1.0";
    private boolean m_bFavourSpeed = false;

    @Nonnull
    public final String getHeaderVersion() {
        return this.m_sHeaderVersion;
    }

    @Nonnull
    public final PeppolSBDHDataWriter setHeaderVersion(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"HeaderVersion");
        this.m_sHeaderVersion = string;
        return this;
    }

    public final boolean isFavourSpeed() {
        return this.m_bFavourSpeed;
    }

    @Nonnull
    public final PeppolSBDHDataWriter setFavourSpeed(boolean bl) {
        this.m_bFavourSpeed = bl;
        return this;
    }

    @Nonnull
    public StandardBusinessDocument createStandardBusinessDocument(@Nonnull PeppolSBDHData peppolSBDHData) {
        ValueEnforcer.notNull((Object)peppolSBDHData, (String)"Data");
        if (!peppolSBDHData.areAllFieldsSet()) {
            throw new IllegalArgumentException("Not all data fields are set!");
        }
        StandardBusinessDocumentHeader standardBusinessDocumentHeader = new StandardBusinessDocumentHeader();
        standardBusinessDocumentHeader.setHeaderVersion(this.m_sHeaderVersion);
        Partner partner = new Partner();
        Object object = new PartnerIdentification();
        object.setAuthority(peppolSBDHData.getSenderScheme());
        object.setValue(peppolSBDHData.getSenderValue());
        partner.setIdentifier((PartnerIdentification)object);
        standardBusinessDocumentHeader.addSender(partner);
        partner = new Partner();
        object = new PartnerIdentification();
        object.setAuthority(peppolSBDHData.getReceiverScheme());
        object.setValue(peppolSBDHData.getReceiverValue());
        partner.setIdentifier((PartnerIdentification)object);
        standardBusinessDocumentHeader.addReceiver(partner);
        partner = new DocumentIdentification();
        partner.setStandard(peppolSBDHData.getStandard());
        partner.setTypeVersion(peppolSBDHData.getTypeVersion());
        partner.setType(peppolSBDHData.getType());
        partner.setInstanceIdentifier(peppolSBDHData.getInstanceIdentifier());
        partner.setCreationDateAndTime(peppolSBDHData.getCreationDateAndTime());
        standardBusinessDocumentHeader.setDocumentIdentification((DocumentIdentification)partner);
        partner = new BusinessScope();
        object = new Scope();
        object.setType("DOCUMENTID");
        object.setInstanceIdentifier(peppolSBDHData.getDocumentTypeValue());
        object.setIdentifier(peppolSBDHData.getDocumentTypeScheme());
        partner.addScope((Scope)object);
        object = new Scope();
        object.setType("PROCESSID");
        object.setInstanceIdentifier(peppolSBDHData.getProcessValue());
        object.setIdentifier(peppolSBDHData.getProcessScheme());
        partner.addScope((Scope)object);
        object = new Scope();
        object.setType("COUNTRY_C1");
        object.setInstanceIdentifier(peppolSBDHData.getCountryC1());
        partner.addScope((Scope)object);
        if (peppolSBDHData.hasMLSToValue()) {
            object = new Scope();
            object.setType("MLS_TO");
            object.setInstanceIdentifier(peppolSBDHData.getMLSToValue());
            object.setIdentifier(peppolSBDHData.getMLSToScheme());
            partner.addScope((Scope)object);
        }
        if (peppolSBDHData.hasMLSType()) {
            object = new Scope();
            object.setType("MLS_TYPE");
            object.setInstanceIdentifier(peppolSBDHData.getMLSType().getID());
            partner.addScope((Scope)object);
        }
        for (Map.Entry entry : peppolSBDHData.additionalAttributes().entrySet()) {
            Scope scope = new Scope();
            scope.setType((String)entry.getKey());
            scope.setInstanceIdentifier(StringHelper.getNotNull((String)((String)entry.getValue())));
            partner.addScope(scope);
        }
        standardBusinessDocumentHeader.setBusinessScope((BusinessScope)partner);
        partner = new StandardBusinessDocument();
        partner.setStandardBusinessDocumentHeader(standardBusinessDocumentHeader);
        if (this.m_bFavourSpeed) {
            partner.setAny((Object)peppolSBDHData.getBusinessMessageNoClone());
        } else {
            partner.setAny((Object)peppolSBDHData.getBusinessMessage());
        }
        return partner;
    }
}

