/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reporting.backend.mongodb;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.style.IsSPIImplementation;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.UsedViaReflection;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ESuccess;
import com.helger.base.string.StringHelper;
import com.helger.config.IConfig;
import com.helger.peppol.reporting.api.PeppolReportingHelper;
import com.helger.peppol.reporting.api.PeppolReportingItem;
import com.helger.peppol.reporting.api.backend.IPeppolReportingBackendSPI;
import com.helger.peppol.reporting.api.backend.PeppolReportingBackendException;
import com.helger.peppol.reporting.backend.mongodb.MongoClientWrapper;
import com.helger.peppol.reporting.backend.mongodb.PeppolReportingMongoDBHelper;
import com.helger.peppolid.CIdentifier;
import com.mongodb.MongoClientException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.Sorts;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@IsSPIImplementation
public class PeppolReportingBackendMongoDBSPI
implements IPeppolReportingBackendSPI {
    public static final String DEFAULT_COLLECTION = "reporting-items";
    private static final String CONFIG_PREFIX = "peppol.reporting.mongodb.";
    public static final String CONFIG_PEPPOL_REPORTING_MONGODB_CONNECTIONSTRING = "peppol.reporting.mongodb.connectionstring";
    public static final String CONFIG_PEPPOL_REPORTING_MONGODB_DBNAME = "peppol.reporting.mongodb.dbname";
    public static final String CONFIG_PEPPOL_REPORTING_MONGODB_COLLECTION = "peppol.reporting.mongodb.collection";
    private static final Logger LOGGER = LoggerFactory.getLogger(PeppolReportingBackendMongoDBSPI.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private MongoClientWrapper m_aClientWrapper;
    private String m_sCollection;

    @UsedViaReflection
    public PeppolReportingBackendMongoDBSPI() {
    }

    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return "MongoDB";
    }

    @Nullable
    public static MongoClientWrapper createDefaultClientWrapper(@Nonnull IConfig iConfig) {
        String string = iConfig.getAsString((Object)CONFIG_PEPPOL_REPORTING_MONGODB_CONNECTIONSTRING);
        if (StringHelper.isEmpty((String)string)) {
            LOGGER.error("The MongoDB connection string is missing in the configuration. See property 'peppol.reporting.mongodb.connectionstring'");
            return null;
        }
        String string2 = iConfig.getAsString((Object)CONFIG_PEPPOL_REPORTING_MONGODB_DBNAME);
        if (StringHelper.isEmpty((String)string2)) {
            LOGGER.error("The MongoDB database name is missing in the configuration. See property 'peppol.reporting.mongodb.dbname'");
            return null;
        }
        LOGGER.info("Using Peppol Reporting MongoDB database name '" + string2 + "'");
        return new MongoClientWrapper(string, string2);
    }

    @Nullable
    @OverrideOnDemand
    protected MongoClientWrapper createClientWrapper(@Nonnull IConfig iConfig) {
        return PeppolReportingBackendMongoDBSPI.createDefaultClientWrapper(iConfig);
    }

    @Nullable
    @OverrideOnDemand
    protected String getMongoCollectionName(@Nonnull IConfig iConfig) {
        String string = iConfig.getAsString((Object)CONFIG_PEPPOL_REPORTING_MONGODB_COLLECTION);
        return StringHelper.getNotEmpty((String)string, (String)DEFAULT_COLLECTION);
    }

    @Nonnull
    public ESuccess initBackend(@Nonnull IConfig iConfig) {
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aClientWrapper != null) {
                throw new IllegalStateException("The Peppol Reporting MongoDB backend was already initialized");
            }
            this.m_aClientWrapper = this.createClientWrapper(iConfig);
            this.m_sCollection = this.getMongoCollectionName(iConfig);
            if (StringHelper.isEmpty((String)this.m_sCollection)) {
                throw new IllegalStateException("The Peppol Reporting MongoDB backend collection name may not be empty");
            }
        });
        if (!this.isInitialized()) {
            return ESuccess.FAILURE;
        }
        try {
            this._getCollection().createIndex(Indexes.ascending((String[])new String[]{"exchangedate", "exchangedt"}));
            this._getCollection().createIndex(Indexes.ascending((String[])new String[]{"exchangedate"}));
        }
        catch (MongoClientException mongoClientException) {
            LOGGER.error("Failed to create indeces in Peppol Reporting MongoDB", (Throwable)mongoClientException);
            return ESuccess.FAILURE;
        }
        return ESuccess.SUCCESS;
    }

    @Nullable
    public final MongoClientWrapper getClientWrapper() {
        return (MongoClientWrapper)this.m_aRWLock.readLockedGet(() -> this.m_aClientWrapper);
    }

    public boolean isInitialized() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aClientWrapper != null);
    }

    public void shutdownBackend() {
        if (this.isInitialized()) {
            this.m_aRWLock.writeLocked(() -> {
                LOGGER.info("Shutting down Peppol Reporting MongoDB client");
                this.m_aClientWrapper.close();
                this.m_aClientWrapper = null;
                this.m_sCollection = null;
            });
        } else {
            LOGGER.warn("The Peppol Reporting MongoDB backend cannot be shutdown, because it was never properly initialized");
        }
    }

    @Nonnull
    private MongoCollection<Document> _getCollection() {
        return (MongoCollection)this.m_aRWLock.readLockedGet(() -> this.m_aClientWrapper.getCollection(this.m_sCollection));
    }

    private boolean _isDBWritable() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aClientWrapper.isDBWritable());
    }

    public void storeReportingItem(@Nonnull PeppolReportingItem peppolReportingItem) throws PeppolReportingBackendException {
        ValueEnforcer.notNull((Object)peppolReportingItem, (String)"ReportingItem");
        if (PeppolReportingHelper.isDocumentTypeEligableForReporting((String)peppolReportingItem.getDocTypeIDScheme(), (String)peppolReportingItem.getDocTypeIDValue())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Trying to store Peppol Reporting Item in MongoDB");
            }
            if (!this.isInitialized()) {
                throw new IllegalStateException("The Peppol Reporting MongoDB backend is not initialized");
            }
            if (!this._isDBWritable()) {
                throw new IllegalStateException("The Peppol Reporting MongoDB is not writable");
            }
            if (!this._getCollection().insertOne((Object)PeppolReportingMongoDBHelper.toBson(peppolReportingItem)).wasAcknowledged()) {
                throw new IllegalStateException("Failed to insert into Peppol Reporting MongoDB Collection");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Successfully stored Peppol Reporting Item in MongoDB");
            }
        } else {
            LOGGER.info("Not storing Peppol Reporting Item in MongoDB, as the document type is not eligable for reporting (" + CIdentifier.getURIEncoded((String)peppolReportingItem.getDocTypeIDScheme(), (String)peppolReportingItem.getDocTypeIDValue()) + ")");
        }
    }

    @Nonnull
    public Iterable<PeppolReportingItem> iterateReportingItems(@Nonnull LocalDate localDate, @Nonnull LocalDate localDate2) throws PeppolReportingBackendException {
        ValueEnforcer.notNull((Object)localDate, (String)"StartDateIncl");
        ValueEnforcer.notNull((Object)localDate2, (String)"EndDateIncl");
        ValueEnforcer.isTrue(() -> localDate2.compareTo(localDate) >= 0, (String)"EndDateIncl must be >= StartDateIncl");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Querying Peppol Reporting Items from MongoDB between " + String.valueOf(localDate) + " and " + String.valueOf(localDate2));
        }
        if (!this.isInitialized()) {
            throw new IllegalStateException("The Peppol Reporting MongoDB backend is not initialized");
        }
        Bson bson = Filters.and((Bson[])new Bson[]{Filters.gte((String)"exchangedate", (Object)localDate), Filters.lte((String)"exchangedate", (Object)localDate2)});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using MongoDB filter '" + bson.toBsonDocument().toJson() + "'");
        }
        return this._getCollection().find(bson).sort(Sorts.ascending((String[])new String[]{"exchangedt"})).map(PeppolReportingMongoDBHelper::toDomain);
    }
}

