/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reporting.backend.mongodb;

import com.helger.annotation.Nonempty;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.numeric.mutable.MutableInt;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.event.ClusterDescriptionChangedEvent;
import com.mongodb.event.ClusterListener;
import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandSucceededEvent;
import jakarta.annotation.Nonnull;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoClientWrapper
implements AutoCloseable {
    private final MongoClient m_aMongoClient;
    private final MongoDatabase m_aDatabase;
    private final IsWriteable m_aClusterListener = new IsWriteable();

    public MongoClientWrapper(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ConnectionString");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"DBName");
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applicationName("Peppol Reporting Backend").applyConnectionString(new ConnectionString(string)).addCommandListener((CommandListener)new LoggingCommandListener()).applyToClusterSettings(builder -> {
            builder.addClusterListener((ClusterListener)this.m_aClusterListener);
            if (GlobalDebug.isDebugMode()) {
                builder.serverSelectionTimeout(10L, TimeUnit.SECONDS);
            }
        }).build();
        this.m_aMongoClient = MongoClients.create((MongoClientSettings)mongoClientSettings);
        this.m_aDatabase = this.m_aMongoClient.getDatabase(string2);
    }

    @Override
    public void close() {
        StreamHelper.close((AutoCloseable)this.m_aMongoClient);
    }

    public boolean isDBWritable() {
        return this.m_aClusterListener.isWritable();
    }

    @Nonnull
    public MongoCollection<Document> getCollection(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        return this.m_aDatabase.getCollection(string);
    }

    private static class IsWriteable
    implements ClusterListener {
        private static final Logger LOGGER = LoggerFactory.getLogger(IsWriteable.class);
        private final AtomicBoolean m_aIsWritable = new AtomicBoolean(false);

        private IsWriteable() {
        }

        public void clusterDescriptionChanged(ClusterDescriptionChangedEvent clusterDescriptionChangedEvent) {
            if (!this.m_aIsWritable.get()) {
                if (clusterDescriptionChangedEvent.getNewDescription().hasWritableServer()) {
                    this.m_aIsWritable.set(true);
                    LOGGER.info("Able to write to server");
                }
            } else if (!clusterDescriptionChangedEvent.getNewDescription().hasWritableServer()) {
                this.m_aIsWritable.set(false);
                LOGGER.error("Unable to write to server");
            }
        }

        public boolean isWritable() {
            return this.m_aIsWritable.get();
        }
    }

    private static final class LoggingCommandListener
    implements CommandListener {
        private static final Logger LOGGER = LoggerFactory.getLogger(LoggingCommandListener.class);
        private final ICommonsMap<String, MutableInt> m_aCommands = new CommonsHashMap();

        private LoggingCommandListener() {
        }

        public synchronized void commandSucceeded(CommandSucceededEvent commandSucceededEvent) {
            String string2 = commandSucceededEvent.getCommandName();
            int n = ((MutableInt)this.m_aCommands.computeIfAbsent((Object)string2, string -> new MutableInt(0))).inc();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Successfully executed '" + string2 + "' [" + n + "]");
            }
        }

        public void commandFailed(CommandFailedEvent commandFailedEvent) {
            LOGGER.error("Failed execution of command '" + commandFailedEvent.getCommandName() + "' with id " + commandFailedEvent.getRequestId());
        }
    }
}

