/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.validator;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.IsSPIImplementation;
import com.helger.base.string.StringHelper;
import com.helger.peppolid.peppol.pidscheme.EPredefinedParticipantIdentifierScheme;
import com.helger.peppolid.peppol.validator.IParticipantIdentifierValidatorSPI;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@IsSPIImplementation
public final class ParticipantIdentifierValidatorNorwayOrgNumber
implements IParticipantIdentifierValidatorSPI {
    private static final int[] WEIGHTS = new int[]{3, 2, 7, 6, 5, 4, 3, 2};

    @Override
    public boolean isSupportedIssuingAgency(@Nonempty @NonNull String string) {
        return EPredefinedParticipantIdentifierScheme.NO_ORGNR.getISO6523Code().equals(string) || EPredefinedParticipantIdentifierScheme.NO_ORG.getISO6523Code().equals(string) || EPredefinedParticipantIdentifierScheme.NO_VAT.getISO6523Code().equals(string);
    }

    @Override
    public boolean isValueValid(@Nonempty @NonNull String string) {
        return ParticipantIdentifierValidatorNorwayOrgNumber.isValidOrganisationNumber(string);
    }

    public static boolean isValidOrganisationNumber(@Nullable String string) {
        int n;
        int n2;
        if (StringHelper.getLength((CharSequence)string) != 9) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (!Character.isDigit(cArray[8])) {
            return false;
        }
        int n3 = cArray[8] - 48;
        int n4 = 0;
        for (n2 = 0; n2 < 8; ++n2) {
            n = cArray[n2];
            if (!Character.isDigit((char)n)) {
                return false;
            }
            int n5 = n - 48;
            n4 += n5 * WEIGHTS[n2];
        }
        n2 = n4 % 11;
        if (n2 == 0 && n3 == 0) {
            return true;
        }
        n = 11 - n2;
        return n3 == n;
    }
}

