/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.process;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsCollection;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsSet;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.peppol.process.EPredefinedProcessIdentifier;
import com.helger.peppolid.peppol.process.IPeppolPredefinedProcessIdentifier;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class PredefinedProcessIdentifierManager {
    private static final ICommonsMap<String, IPeppolPredefinedProcessIdentifier> CODES = new CommonsHashMap();
    private static final PredefinedProcessIdentifierManager INSTANCE;

    private PredefinedProcessIdentifierManager() {
    }

    @Nonempty
    @ReturnsMutableCopy
    public static @NonNull ICommonsCollection<IPeppolPredefinedProcessIdentifier> getAllProcessIdentifiers() {
        return CODES.copyOfValues();
    }

    @Nonempty
    @ReturnsMutableCopy
    public static @NonNull ICommonsSet<String> getAllProcessIdentifierIDs() {
        return CODES.copyOfKeySet();
    }

    public static @Nullable IPeppolPredefinedProcessIdentifier getProcessIdentifierOfID(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string)) {
            String string2 = string.contains("::") ? string : CIdentifier.getURIEncoded("cenbii-procid-ubl", string);
            for (Map.Entry entry : CODES.entrySet()) {
                if (!string2.equals(entry.getKey())) continue;
                return (IPeppolPredefinedProcessIdentifier)entry.getValue();
            }
        }
        return null;
    }

    public static boolean containsProcessIdentifierWithID(@Nullable String string) {
        return PredefinedProcessIdentifierManager.getProcessIdentifierOfID(string) != null;
    }

    static {
        for (EPredefinedProcessIdentifier ePredefinedProcessIdentifier : EPredefinedProcessIdentifier.values()) {
            CODES.put((Object)ePredefinedProcessIdentifier.getURIEncoded(), (Object)ePredefinedProcessIdentifier);
        }
        INSTANCE = new PredefinedProcessIdentifierManager();
    }
}

