/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.process;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.misc.DevelopersNote;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.compare.CompareHelper;
import com.helger.peppolid.IMutableIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.peppolid.peppol.IPeppolIdentifier;
import com.helger.xsds.peppol.id1.ProcessIdentifierType;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class PeppolProcessIdentifier
extends ProcessIdentifierType
implements IPeppolIdentifier,
IProcessIdentifier,
IMutableIdentifier,
Comparable<PeppolProcessIdentifier>,
ICloneable<PeppolProcessIdentifier> {
    private static @NonNull String _verifyScheme(@NonNull IIdentifierFactory iIdentifierFactory, @Nullable String string) {
        if (!iIdentifierFactory.isProcessIdentifierSchemeValid(string)) {
            throw new IllegalArgumentException("Peppol Process identifier scheme '" + string + "' is invalid!");
        }
        return string;
    }

    private static @NonNull String _verifyValue(@NonNull IIdentifierFactory iIdentifierFactory, @Nullable String string, @NonNull String string2) {
        if (!iIdentifierFactory.isProcessIdentifierValueValid(string, string2)) {
            throw new IllegalArgumentException("Peppol Process identifier value '" + string2 + "' is invalid for scheme '" + string + "!");
        }
        return string2;
    }

    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public PeppolProcessIdentifier(@NonNull IIdentifierFactory iIdentifierFactory, @NonNull IProcessIdentifier iProcessIdentifier) {
        this(iIdentifierFactory, iProcessIdentifier.getScheme(), iProcessIdentifier.getValue());
    }

    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public PeppolProcessIdentifier(@NonNull IIdentifierFactory iIdentifierFactory, @NonNull String string, @NonNull String string2) {
        this(true, PeppolProcessIdentifier._verifyScheme(iIdentifierFactory, string), PeppolProcessIdentifier._verifyValue(iIdentifierFactory, string, string2));
    }

    protected PeppolProcessIdentifier(boolean bl, @NonNull String string, @NonNull String string2) {
        this.setScheme(string);
        this.setValue(string2);
    }

    @Override
    public boolean hasDefaultScheme() {
        return this.hasScheme("cenbii-procid-ubl");
    }

    @Override
    public int compareTo(@NonNull PeppolProcessIdentifier peppolProcessIdentifier) {
        int n = CompareHelper.compare((Comparable)((Object)this.getScheme()), (Comparable)((Object)peppolProcessIdentifier.getScheme()));
        if (n == 0) {
            n = CompareHelper.compare((Comparable)((Object)this.getValue()), (Comparable)((Object)peppolProcessIdentifier.getValue()));
        }
        return n;
    }

    @ReturnsMutableCopy
    public @NonNull PeppolProcessIdentifier getClone() {
        return new PeppolProcessIdentifier(true, this.getScheme(), this.getValue());
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static @NonNull PeppolProcessIdentifier internalCreatePreVerified(@Nullable String string, @Nullable String string2) {
        return new PeppolProcessIdentifier(true, string, string2);
    }
}

