/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.pidscheme;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.state.ETriState;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.peppol.pidscheme.EPredefinedParticipantIdentifierScheme;
import com.helger.peppolid.peppol.pidscheme.IPeppolParticipantIdentifierScheme;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class PeppolParticipantIdentifierSchemeManager {
    private static final ICommonsList<IPeppolParticipantIdentifierScheme> PI_SCHEMES = new CommonsArrayList();
    private static final PeppolParticipantIdentifierSchemeManager INSTANCE;

    private PeppolParticipantIdentifierSchemeManager() {
    }

    @Nonempty
    @ReturnsMutableCopy
    public static @NonNull ICommonsList<? extends IPeppolParticipantIdentifierScheme> getAllSchemes() {
        return (ICommonsList)PI_SCHEMES.getClone();
    }

    public static @Nullable IPeppolParticipantIdentifierScheme getSchemeOfISO6523Code(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string)) {
            for (IPeppolParticipantIdentifierScheme iPeppolParticipantIdentifierScheme : PI_SCHEMES) {
                if (!iPeppolParticipantIdentifierScheme.getISO6523Code().equalsIgnoreCase(string)) continue;
                return iPeppolParticipantIdentifierScheme;
            }
        }
        return null;
    }

    public static boolean containsSchemeWithISO6523Code(@Nullable String string) {
        return PeppolParticipantIdentifierSchemeManager.getSchemeOfISO6523Code(string) != null;
    }

    public static @Nullable String getSchemeIDOfISO6523Code(@Nullable String string) {
        IPeppolParticipantIdentifierScheme iPeppolParticipantIdentifierScheme = PeppolParticipantIdentifierSchemeManager.getSchemeOfISO6523Code(string);
        return iPeppolParticipantIdentifierScheme == null ? null : iPeppolParticipantIdentifierScheme.getSchemeID();
    }

    public static @Nullable IPeppolParticipantIdentifierScheme getSchemeOfSchemeID(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string)) {
            for (IPeppolParticipantIdentifierScheme iPeppolParticipantIdentifierScheme : PI_SCHEMES) {
                if (!iPeppolParticipantIdentifierScheme.getSchemeID().equalsIgnoreCase(string)) continue;
                return iPeppolParticipantIdentifierScheme;
            }
        }
        return null;
    }

    public static boolean containsSchemeWithSchemeID(@Nullable String string) {
        return PeppolParticipantIdentifierSchemeManager.getSchemeOfSchemeID(string) != null;
    }

    public static @Nullable String getISO6523CodeOfSchemeID(@Nullable String string) {
        IPeppolParticipantIdentifierScheme iPeppolParticipantIdentifierScheme = PeppolParticipantIdentifierSchemeManager.getSchemeOfSchemeID(string);
        return iPeppolParticipantIdentifierScheme == null ? null : iPeppolParticipantIdentifierScheme.getISO6523Code();
    }

    public static @NonNull ETriState isSchemeWithISO6523CodeDeprecated(@Nullable String string) {
        IPeppolParticipantIdentifierScheme iPeppolParticipantIdentifierScheme = PeppolParticipantIdentifierSchemeManager.getSchemeOfISO6523Code(string);
        return iPeppolParticipantIdentifierScheme == null ? ETriState.UNDEFINED : ETriState.valueOf((boolean)iPeppolParticipantIdentifierScheme.isDeprecated());
    }

    public static @NonNull ETriState isSchemeWithSchemeIDDeprecated(@Nullable String string) {
        IPeppolParticipantIdentifierScheme iPeppolParticipantIdentifierScheme = PeppolParticipantIdentifierSchemeManager.getSchemeOfSchemeID(string);
        return iPeppolParticipantIdentifierScheme == null ? ETriState.UNDEFINED : ETriState.valueOf((boolean)iPeppolParticipantIdentifierScheme.isDeprecated());
    }

    public static @Nullable IPeppolParticipantIdentifierScheme getSchemeOfIdentifier(@Nullable IParticipantIdentifier iParticipantIdentifier) {
        String string;
        if (iParticipantIdentifier != null && iParticipantIdentifier.hasScheme("iso6523-actorid-upis") && (string = iParticipantIdentifier.getValue()).length() > 5) {
            return PeppolParticipantIdentifierSchemeManager.getSchemeOfISO6523Code(string.substring(0, 4));
        }
        return null;
    }

    static {
        for (EPredefinedParticipantIdentifierScheme ePredefinedParticipantIdentifierScheme : EPredefinedParticipantIdentifierScheme.values()) {
            PI_SCHEMES.add((Object)ePredefinedParticipantIdentifierScheme);
        }
        INSTANCE = new PeppolParticipantIdentifierSchemeManager();
    }
}

