/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.doctype;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsCollection;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsSet;
import com.helger.peppolid.peppol.doctype.EPredefinedDocumentTypeIdentifier;
import com.helger.peppolid.peppol.doctype.IPeppolPredefinedDocumentTypeIdentifier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class PredefinedDocumentTypeIdentifierManager {
    private static final ICommonsMap<String, IPeppolPredefinedDocumentTypeIdentifier> CODES = new CommonsHashMap();
    private static final PredefinedDocumentTypeIdentifierManager INSTANCE;

    private PredefinedDocumentTypeIdentifierManager() {
    }

    @Nonempty
    @ReturnsMutableCopy
    public static @NonNull ICommonsCollection<IPeppolPredefinedDocumentTypeIdentifier> getAllDocumentTypeIdentifiers() {
        return CODES.copyOfValues();
    }

    @Nonempty
    @ReturnsMutableCopy
    public static @NonNull ICommonsSet<String> getAllDocumentTypeIdentifierIDs() {
        return CODES.copyOfKeySet();
    }

    public static @Nullable IPeppolPredefinedDocumentTypeIdentifier getDocumentTypeIdentifierOfID(@Nullable String string) {
        if (string != null) {
            return (IPeppolPredefinedDocumentTypeIdentifier)CODES.get((Object)string);
        }
        return null;
    }

    public static boolean containsDocumentTypeIdentifierWithID(@Nullable String string) {
        return PredefinedDocumentTypeIdentifierManager.getDocumentTypeIdentifierOfID(string) != null;
    }

    static {
        for (EPredefinedDocumentTypeIdentifier ePredefinedDocumentTypeIdentifier : EPredefinedDocumentTypeIdentifier.values()) {
            CODES.put((Object)ePredefinedDocumentTypeIdentifier.getURIEncoded(), (Object)ePredefinedDocumentTypeIdentifier);
        }
        INSTANCE = new PredefinedDocumentTypeIdentifierManager();
    }
}

