/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.doctype;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.peppol.doctype.IPeppolGenericDocumentTypeIdentifierParts;
import java.util.List;
import org.jspecify.annotations.NonNull;

@Immutable
public class PeppolGenericDocumentTypeIdentifierParts
implements IPeppolGenericDocumentTypeIdentifierParts {
    private final String m_sSyntaxSpecificID;
    private final String m_sCustomizationID;
    private final String m_sVersion;

    public PeppolGenericDocumentTypeIdentifierParts(@Nonempty @NonNull String string, @Nonempty @NonNull String string2, @Nonempty @NonNull String string3) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SyntaxSpecificID");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"CustomizationID");
        ValueEnforcer.notEmpty((CharSequence)string3, (String)"Version");
        this.m_sSyntaxSpecificID = string;
        this.m_sCustomizationID = string2;
        this.m_sVersion = string3;
    }

    @Override
    public final @NonNull String getSyntaxSpecificID() {
        return this.m_sSyntaxSpecificID;
    }

    @Override
    @Nonempty
    public final @NonNull String getCustomizationID() {
        return this.m_sCustomizationID;
    }

    @Override
    @Nonempty
    public final @NonNull String getVersion() {
        return this.m_sVersion;
    }

    public @NonNull PeppolGenericDocumentTypeIdentifierParts withCustomizationID(@Nonempty @NonNull String string) {
        return new PeppolGenericDocumentTypeIdentifierParts(this.m_sSyntaxSpecificID, string, this.m_sVersion);
    }

    public @NonNull PeppolGenericDocumentTypeIdentifierParts withVersion(@Nonempty @NonNull String string) {
        return new PeppolGenericDocumentTypeIdentifierParts(this.m_sSyntaxSpecificID, this.m_sCustomizationID, string);
    }

    @Override
    @Nonempty
    public final @NonNull String getAsDocumentTypeIdentifierValue() {
        return this.m_sSyntaxSpecificID + "##" + this.m_sCustomizationID + "::" + this.m_sVersion;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("SyntaxSpecificID", (Object)this.m_sSyntaxSpecificID).append("CustomizationID", (Object)this.m_sCustomizationID).append("Version", (Object)this.m_sVersion).getToString();
    }

    public static @NonNull PeppolGenericDocumentTypeIdentifierParts extractFromString(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DocumentTypeIdentifier");
        List list = StringHelper.getExploded((String)"##", (String)string, (int)2);
        if (list.size() != 2) {
            throw new IllegalArgumentException("The passed document type identifier is missing the separator between the Syntax specific ID and the Customization ID!");
        }
        String string2 = (String)list.get(0);
        if (StringHelper.isEmpty((String)string2)) {
            throw new IllegalArgumentException("The passed document type identifier has an empty Syntax specific ID!");
        }
        String string3 = (String)list.get(1);
        if (StringHelper.isEmpty((String)string3)) {
            throw new IllegalArgumentException("The passed document type identifier has an nothing after the Syntax specific ID!");
        }
        int n = string3.lastIndexOf("::");
        if (n < 0) {
            throw new IllegalArgumentException("The passed document type identifier remainder '" + string3 + "' is missing the separation between Customization ID and Version!");
        }
        String string4 = string3.substring(0, n);
        if (StringHelper.isEmpty((String)string4)) {
            throw new IllegalArgumentException("The passed document type identifier remainder '" + string3 + "' contains an empty Customization ID!");
        }
        String string5 = string3.substring(n + "::".length());
        if (StringHelper.isEmpty((String)string5)) {
            throw new IllegalArgumentException("The passed document type identifier remainder '" + string3 + "' contains an empty Version!");
        }
        return new PeppolGenericDocumentTypeIdentifierParts(string2, string4, string5);
    }

    public static @NonNull PeppolGenericDocumentTypeIdentifierParts extractFromIdentifier(@NonNull IDocumentTypeIdentifier iDocumentTypeIdentifier) {
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"Identifier");
        return PeppolGenericDocumentTypeIdentifierParts.extractFromString(iDocumentTypeIdentifier.getValue());
    }
}

