/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.doctype;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.wrapper.Wrapper;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.peppol.doctype.IPeppolDocumentTypeIdentifierParts;
import com.helger.peppolid.peppol.doctype.IPeppolGenericDocumentTypeIdentifierParts;
import com.helger.peppolid.peppol.doctype.PeppolGenericDocumentTypeIdentifierParts;
import java.util.List;
import java.util.function.BiConsumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class PeppolDocumentTypeIdentifierParts
extends PeppolGenericDocumentTypeIdentifierParts
implements IPeppolDocumentTypeIdentifierParts {
    private final String m_sRootNS;
    private final String m_sLocalName;

    @Nonempty
    public static @NonNull String createSyntaxSpecificID(@Nonempty @NonNull String string, @Nonempty @NonNull String string2) {
        return string + "::" + string2;
    }

    public PeppolDocumentTypeIdentifierParts(@Nonempty @NonNull String string, @Nonempty @NonNull String string2, @Nonempty @NonNull String string3, @Nonempty @NonNull String string4) {
        super(PeppolDocumentTypeIdentifierParts.createSyntaxSpecificID(string, string2), string3, string4);
        ValueEnforcer.notEmpty((CharSequence)string, (String)"RootNS");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"LocalName");
        this.m_sRootNS = string;
        this.m_sLocalName = string2;
    }

    @Override
    @Nonempty
    public @NonNull String getRootNS() {
        return this.m_sRootNS;
    }

    @Override
    @Nonempty
    public @NonNull String getLocalName() {
        return this.m_sLocalName;
    }

    @Override
    public @NonNull PeppolDocumentTypeIdentifierParts withCustomizationID(@Nonempty @NonNull String string) {
        return new PeppolDocumentTypeIdentifierParts(this.m_sRootNS, this.m_sLocalName, string, this.getVersion());
    }

    @Override
    public @NonNull PeppolDocumentTypeIdentifierParts withVersion(@Nonempty @NonNull String string) {
        return new PeppolDocumentTypeIdentifierParts(this.m_sRootNS, this.m_sLocalName, this.getCustomizationID(), string);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("RootNS", (Object)this.m_sRootNS).append("LocalName", (Object)this.m_sLocalName).getToString();
    }

    public static boolean isSyntaxSpecificIDLookingLikeXML(@Nullable String string) {
        int n;
        if (StringHelper.isNotEmpty((String)string) && (n = string.indexOf("::")) >= 0) {
            return n > 0 && n < string.length() - "::".length();
        }
        return false;
    }

    public static void extractXMLSyntaxSpecificID(@Nonempty @NonNull String string, @NonNull BiConsumer<String, String> biConsumer) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SyntaxSpecificID");
        ValueEnforcer.notNull(biConsumer, (String)"ResultConsumer");
        List list = StringHelper.getExploded((String)"::", (String)string, (int)2);
        if (list.size() < 2) {
            throw new IllegalArgumentException("The Syntax Specific ID '" + string + "' is missing the separation between the root namespace URI and the local name!");
        }
        String string2 = (String)list.get(0);
        if (StringHelper.isEmpty((String)string2)) {
            throw new IllegalArgumentException("The Syntax Specific ID '" + string + "' contains an empty root namespace URI!");
        }
        String string3 = (String)list.get(1);
        if (StringHelper.isEmpty((String)string2)) {
            throw new IllegalArgumentException("The Syntax Specific ID '" + string + "' contains an empty local name!");
        }
        biConsumer.accept(string2, string3);
    }

    public static @NonNull PeppolDocumentTypeIdentifierParts extractFromString(@Nonempty @NonNull String string3) {
        PeppolGenericDocumentTypeIdentifierParts peppolGenericDocumentTypeIdentifierParts = PeppolGenericDocumentTypeIdentifierParts.extractFromString(string3);
        Wrapper wrapper = new Wrapper();
        Wrapper wrapper2 = new Wrapper();
        PeppolDocumentTypeIdentifierParts.extractXMLSyntaxSpecificID(peppolGenericDocumentTypeIdentifierParts.getSyntaxSpecificID(), (string, string2) -> {
            wrapper.set(string);
            wrapper2.set(string2);
        });
        return new PeppolDocumentTypeIdentifierParts((String)wrapper.get(), (String)wrapper2.get(), peppolGenericDocumentTypeIdentifierParts.getCustomizationID(), peppolGenericDocumentTypeIdentifierParts.getVersion());
    }

    public static @NonNull PeppolDocumentTypeIdentifierParts extractFromIdentifier(@NonNull IDocumentTypeIdentifier iDocumentTypeIdentifier) {
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"Identifier");
        return PeppolDocumentTypeIdentifierParts.extractFromString(iDocumentTypeIdentifier.getValue());
    }

    public static @NonNull PeppolDocumentTypeIdentifierParts extract(@NonNull IPeppolGenericDocumentTypeIdentifierParts iPeppolGenericDocumentTypeIdentifierParts) {
        ValueEnforcer.notNull((Object)iPeppolGenericDocumentTypeIdentifierParts, (String)"DocIDParts");
        Wrapper wrapper = new Wrapper();
        Wrapper wrapper2 = new Wrapper();
        PeppolDocumentTypeIdentifierParts.extractXMLSyntaxSpecificID(iPeppolGenericDocumentTypeIdentifierParts.getSyntaxSpecificID(), (string, string2) -> {
            wrapper.set(string);
            wrapper2.set(string2);
        });
        return new PeppolDocumentTypeIdentifierParts((String)wrapper.get(), (String)wrapper2.get(), iPeppolGenericDocumentTypeIdentifierParts.getCustomizationID(), iPeppolGenericDocumentTypeIdentifierParts.getVersion());
    }
}

