/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol;

import com.helger.annotation.concurrent.ThreadSafe;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jspecify.annotations.Nullable;

@ThreadSafe
public final class PeppolIdentifierHelper {
    public static final int MAX_IDENTIFIER_SCHEME_LENGTH = 25;
    public static final boolean DEFAULT_CHARSET_CHECKS_DISABLED = false;
    public static final String PARTICIPANT_IDENTIFIER_SCHEME_REGEX = "[a-z0-9]+-[a-z0-9]+-[a-z0-9]+";
    private static final AtomicBoolean CHARSET_CHECKS_DISABLED = new AtomicBoolean(false);
    public static final String DOCUMENT_TYPE_SCHEME_BUSDOX_DOCID_QNS = "busdox-docid-qns";
    public static final String DOCUMENT_TYPE_SCHEME_PEPPOL_DOCTYPE_WILDCARD = "peppol-doctype-wildcard";
    public static final int MAX_DOCUMENT_TYPE_VALUE_LENGTH = 500;
    public static final String PARTICIPANT_SCHEME_ISO6523_ACTORID_UPIS = "iso6523-actorid-upis";
    public static final String DEFAULT_PARTICIPANT_SCHEME = "iso6523-actorid-upis";
    public static final int MAX_PARTICIPANT_VALUE_LENGTH = 135;
    public static final String PROCESS_SCHEME_CENBII_PROCID_UBL = "cenbii-procid-ubl";
    public static final String DEFAULT_PROCESS_SCHEME = "cenbii-procid-ubl";
    public static final int MAX_PROCESS_VALUE_LENGTH = 200;
    public static final char DOCUMENT_TYPE_WILDCARD_PART_SEPARATOR = '@';
    public static final char DOCUMENT_TYPE_WILDCARD_INDICATOR = '*';
    private static final PeppolIdentifierHelper INSTANCE = new PeppolIdentifierHelper();

    private PeppolIdentifierHelper() {
    }

    public static boolean areCharsetChecksDisabled() {
        return CHARSET_CHECKS_DISABLED.get();
    }

    public static void disableCharsetChecks(boolean bl) {
        CHARSET_CHECKS_DISABLED.set(bl);
    }

    private static boolean _isForbiddenSchemeIDChar(char c) {
        return c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r' || c == ' ' || c == '\u0085' || c == '\u00a0';
    }

    public static boolean isValidIdentifierScheme(@Nullable String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        if (string.indexOf("::") >= 0) {
            return false;
        }
        for (char c : string.toCharArray()) {
            if (!PeppolIdentifierHelper._isForbiddenSchemeIDChar(c)) continue;
            return false;
        }
        return n <= 25;
    }
}

