/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.factory;

import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cache.regex.RegExHelper;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.peppolid.peppol.PeppolIdentifierHelper;
import com.helger.peppolid.peppol.doctype.PeppolDocumentTypeIdentifier;
import com.helger.peppolid.peppol.doctype.PeppolGenericDocumentTypeIdentifierParts;
import com.helger.peppolid.peppol.participant.PeppolParticipantIdentifier;
import com.helger.peppolid.peppol.process.PeppolProcessIdentifier;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class PeppolIdentifierFactory
implements IIdentifierFactory {
    public static final PeppolIdentifierFactory INSTANCE = new PeppolIdentifierFactory();
    public static final boolean DEFAULT_STRICT = true;
    private final boolean m_bStrict;

    public PeppolIdentifierFactory() {
        this(true);
    }

    protected PeppolIdentifierFactory(boolean bl) {
        this.m_bStrict = bl;
    }

    @Override
    public boolean isDocumentTypeIdentifierSchemeMandatory() {
        return true;
    }

    @Override
    @Deprecated(forRemoval=false)
    public @NonNull String getDefaultDocumentTypeIdentifierScheme() {
        return "busdox-docid-qns";
    }

    @Override
    public @Nullable String getDefaultDocumentTypeIdentifierScheme(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        if (string.contains("##urn:peppol:pint:")) {
            return "peppol-doctype-wildcard";
        }
        return "busdox-docid-qns";
    }

    @Override
    public boolean isDocumentTypeIdentifierSchemeValid(@Nullable String string) {
        return PeppolIdentifierHelper.isValidIdentifierScheme(string);
    }

    private static boolean _isForbiddenCustomizationIDCharBusdoxDocidQns(char c) {
        return c == '*' || c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r' || c == ' ' || c == '\u0085' || c == '\u00a0';
    }

    public static boolean isValidCustomizationIDBusdoxDocidQns(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        for (char c : string.toCharArray()) {
            if (!PeppolIdentifierFactory._isForbiddenCustomizationIDCharBusdoxDocidQns(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean _isForbiddenCustomizationIDCharPeppolDoctypeWildcard(char c) {
        return c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r' || c == ' ' || c == '\u0085' || c == '\u00a0';
    }

    public static boolean isValidCustomizationIDPeppolDoctypeWildcard(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        for (char c : string.toCharArray()) {
            if (!PeppolIdentifierFactory._isForbiddenCustomizationIDCharPeppolDoctypeWildcard(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDocumentTypeIdentifierValueValid(@Nullable String string, @Nullable String string2) {
        if (string2 == null) {
            return false;
        }
        int n = string2.length();
        if (n == 0) {
            return false;
        }
        if (n > 500) {
            return false;
        }
        if (!PeppolIdentifierHelper.areCharsetChecksDisabled() && !StandardCharsets.ISO_8859_1.newEncoder().canEncode(string2)) {
            return false;
        }
        if (this.m_bStrict) {
            try {
                PeppolGenericDocumentTypeIdentifierParts peppolGenericDocumentTypeIdentifierParts = PeppolGenericDocumentTypeIdentifierParts.extractFromString(string2);
                if (string != null) {
                    switch (string) {
                        case "busdox-docid-qns": {
                            if (PeppolIdentifierFactory.isValidCustomizationIDBusdoxDocidQns(peppolGenericDocumentTypeIdentifierParts.getCustomizationID())) break;
                            return false;
                        }
                        case "peppol-doctype-wildcard": {
                            if (PeppolIdentifierFactory.isValidCustomizationIDPeppolDoctypeWildcard(peppolGenericDocumentTypeIdentifierParts.getCustomizationID())) break;
                            return false;
                        }
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }
        return true;
    }

    @Override
    public @Nullable PeppolDocumentTypeIdentifier createDocumentTypeIdentifierWithDefaultScheme(@Nullable String string) {
        return this.createDocumentTypeIdentifier(this.getDefaultDocumentTypeIdentifierScheme(string), string);
    }

    @Override
    public @Nullable PeppolDocumentTypeIdentifier createDocumentTypeIdentifier(@Nullable String string, @Nullable String string2) {
        String string3 = this.nullNotEmpty(string);
        String string4 = this.nullNotEmpty(this.isDocumentTypeIdentifierCaseInsensitive(string3) ? this.getUnifiedValue(string2) : string2);
        if (this.isDocumentTypeIdentifierSchemeValid(string3) && this.isDocumentTypeIdentifierValueValid(string3, string4)) {
            return PeppolDocumentTypeIdentifier.internalCreatePreVerified(string3, string4);
        }
        return null;
    }

    @Override
    public boolean isParticipantIdentifierSchemeMandatory() {
        return true;
    }

    @Override
    public @NonNull String getDefaultParticipantIdentifierScheme() {
        return "iso6523-actorid-upis";
    }

    @Override
    public boolean isParticipantIdentifierCaseInsensitive(@Nullable String string) {
        return "iso6523-actorid-upis".equals(string);
    }

    @Override
    public boolean isParticipantIdentifierSchemeValid(@Nullable String string) {
        if (!PeppolIdentifierHelper.isValidIdentifierScheme(string)) {
            return false;
        }
        return RegExHelper.stringMatchesPattern((String)"[a-z0-9]+-[a-z0-9]+-[a-z0-9]+", (String)string.toLowerCase(Locale.US));
    }

    @Override
    public boolean isParticipantIdentifierValueValid(@Nullable String string, @Nullable String string2) {
        if (string2 == null) {
            return false;
        }
        int n = string2.length();
        if (n == 0) {
            return false;
        }
        if (n > 135) {
            return false;
        }
        if (!PeppolIdentifierHelper.areCharsetChecksDisabled() && !StandardCharsets.ISO_8859_1.newEncoder().canEncode(string2)) {
            return false;
        }
        if ("iso6523-actorid-upis".equals(string)) {
            if (n < 6) {
                return false;
            }
            if (string2.indexOf(58) != 4) {
                return false;
            }
            if (!Character.isDigit(string2.charAt(0))) {
                return false;
            }
            if (!Character.isDigit(string2.charAt(1))) {
                return false;
            }
            if (!Character.isDigit(string2.charAt(2))) {
                return false;
            }
            if (!Character.isDigit(string2.charAt(3))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public @Nullable PeppolParticipantIdentifier createParticipantIdentifierWithDefaultScheme(@Nullable String string) {
        return this.createParticipantIdentifier(this.getDefaultParticipantIdentifierScheme(), string);
    }

    @Override
    public @Nullable PeppolParticipantIdentifier createParticipantIdentifier(@Nullable String string, @Nullable String string2) {
        String string3 = this.nullNotEmpty(string);
        String string4 = this.nullNotEmpty(this.isParticipantIdentifierCaseInsensitive(string3) ? this.getUnifiedValue(string2) : string2);
        if (this.isParticipantIdentifierSchemeValid(string) && this.isParticipantIdentifierValueValid(string, string2)) {
            return PeppolParticipantIdentifier.internalCreatePreVerified(string3, string4);
        }
        return null;
    }

    @Override
    public @NonNull String getDefaultProcessIdentifierScheme() {
        return "cenbii-procid-ubl";
    }

    @Override
    public boolean isProcessIdentifierSchemeValid(@Nullable String string) {
        return PeppolIdentifierHelper.isValidIdentifierScheme(string);
    }

    @Override
    public boolean isProcessIdentifierValueValid(@Nullable String string, @Nullable String string2) {
        int n = StringHelper.getLength((CharSequence)string2);
        if (n == 0) {
            return false;
        }
        if (n > 200) {
            return false;
        }
        if (!PeppolIdentifierHelper.areCharsetChecksDisabled() && !StandardCharsets.ISO_8859_1.newEncoder().canEncode(string2)) {
            return false;
        }
        for (char c : string2.toCharArray()) {
            if (!Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public @Nullable PeppolProcessIdentifier createProcessIdentifierWithDefaultScheme(@Nullable String string) {
        return this.createProcessIdentifier(this.getDefaultProcessIdentifierScheme(), string);
    }

    @Override
    public @Nullable PeppolProcessIdentifier createProcessIdentifier(@Nullable String string, @Nullable String string2) {
        String string3 = this.nullNotEmpty(string);
        String string4 = this.nullNotEmpty(this.isProcessIdentifierCaseInsensitive(string3) ? this.getUnifiedValue(string2) : string2);
        if (this.isProcessIdentifierSchemeValid(string) && this.isProcessIdentifierValueValid(string, string2)) {
            return PeppolProcessIdentifier.internalCreatePreVerified(string3, string4);
        }
        return null;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Strict", this.m_bStrict).getToString();
    }
}

