/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.factory;

import com.helger.annotation.Nonempty;
import com.helger.base.id.IHasID;
import com.helger.base.lang.EnumHelper;
import com.helger.base.name.IHasDisplayName;
import com.helger.peppolid.factory.BDXR1IdentifierFactory;
import com.helger.peppolid.factory.BDXR2IdentifierFactory;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.peppolid.factory.PeppolIdentifierFactory;
import com.helger.peppolid.factory.PeppolLaxIdentifierFactory;
import com.helger.peppolid.factory.SimpleIdentifierFactory;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public enum ESMPIdentifierType implements IHasID<String>,
IHasDisplayName
{
    SIMPLE("simple", "Simple", SimpleIdentifierFactory.INSTANCE),
    PEPPOL("peppol", "Peppol", PeppolIdentifierFactory.INSTANCE),
    PEPPOL_LAX("peppol-lax", "Peppol (lax)", PeppolLaxIdentifierFactory.INSTANCE),
    BDXR1("bdxr1", "OASIS BDXR v1", BDXR1IdentifierFactory.INSTANCE),
    BDXR2("bdxr2", "OASIS BDXR v2", BDXR2IdentifierFactory.INSTANCE);

    private final String m_sID;
    private final String m_sDisplayName;
    private final IIdentifierFactory m_aIF;

    private ESMPIdentifierType(@NonNull String string2, String string3, IIdentifierFactory iIdentifierFactory) {
        this.m_sID = string2;
        this.m_sDisplayName = string3;
        this.m_aIF = iIdentifierFactory;
    }

    @Nonempty
    public @NonNull String getID() {
        return this.m_sID;
    }

    @Nonempty
    public @NonNull String getDisplayName() {
        return this.m_sDisplayName;
    }

    public @NonNull IIdentifierFactory getIdentifierFactory() {
        return this.m_aIF;
    }

    public static @Nullable ESMPIdentifierType getFromIDOrNull(@Nullable String string) {
        return ESMPIdentifierType.getFromIDOrDefault(string, null);
    }

    public static @Nullable ESMPIdentifierType getFromIDOrDefault(@Nullable String string, @Nullable ESMPIdentifierType eSMPIdentifierType) {
        return (ESMPIdentifierType)EnumHelper.getFromIDOrDefault(ESMPIdentifierType.class, (Object)string, (Enum)eSMPIdentifierType);
    }
}

