/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.factory;

import com.helger.base.tostring.ToStringGenerator;
import com.helger.peppolid.bdxr.smp2.BDXR2IdentifierHelper;
import com.helger.peppolid.bdxr.smp2.doctype.BDXR2DocumentTypeIdentifier;
import com.helger.peppolid.bdxr.smp2.participant.BDXR2ParticipantIdentifier;
import com.helger.peppolid.bdxr.smp2.process.BDXR2ProcessIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class BDXR2IdentifierFactory
implements IIdentifierFactory {
    public static final BDXR2IdentifierFactory INSTANCE = new BDXR2IdentifierFactory();

    @Override
    public @NonNull String getDefaultDocumentTypeIdentifierScheme() {
        return "bdx-docid-qns";
    }

    @Override
    public boolean isDocumentTypeIdentifierCaseInsensitive(@Nullable String string) {
        return "bdx-docid-qns".equals(string);
    }

    @Override
    public boolean isDocumentTypeIdentifierSchemeValid(@Nullable String string) {
        return BDXR2IdentifierHelper.isValidIdentifierScheme(string);
    }

    @Override
    public boolean isDocumentTypeIdentifierValueValid(@Nullable String string, @Nullable String string2) {
        return BDXR2IdentifierHelper.isValidIdentifierValue(string2);
    }

    @Override
    public @Nullable BDXR2DocumentTypeIdentifier createDocumentTypeIdentifier(@Nullable String string, @Nullable String string2) {
        String string3 = this.nullNotEmpty(string);
        String string4 = this.nullNotEmpty(this.isDocumentTypeIdentifierCaseInsensitive(string3) ? this.getUnifiedValue(string2) : string2);
        if (this.isDocumentTypeIdentifierSchemeValid(string3) && this.isDocumentTypeIdentifierValueValid(string3, string4)) {
            return new BDXR2DocumentTypeIdentifier(string3, string4);
        }
        return null;
    }

    @Override
    public boolean isParticipantIdentifierCaseInsensitive(@Nullable String string) {
        return "iso6523-actorid-upis".equals(string);
    }

    @Override
    public boolean isParticipantIdentifierSchemeValid(@Nullable String string) {
        return BDXR2IdentifierHelper.isValidIdentifierScheme(string);
    }

    @Override
    public boolean isParticipantIdentifierValueValid(@Nullable String string, @Nullable String string2) {
        return BDXR2IdentifierHelper.isValidIdentifierValue(string2);
    }

    @Override
    public @Nullable BDXR2ParticipantIdentifier createParticipantIdentifier(@Nullable String string, @Nullable String string2) {
        String string3 = this.nullNotEmpty(string);
        String string4 = this.nullNotEmpty(this.isParticipantIdentifierCaseInsensitive(string3) ? this.getUnifiedValue(string2) : string2);
        if (this.isParticipantIdentifierSchemeValid(string3) && this.isParticipantIdentifierValueValid(string3, string4)) {
            return new BDXR2ParticipantIdentifier(string3, string4);
        }
        return null;
    }

    @Override
    public @NonNull String getDefaultProcessIdentifierScheme() {
        return "bdx-procid-transport";
    }

    @Override
    public boolean isProcessIdentifierCaseInsensitive(@Nullable String string) {
        return "bdx-procid-transport".equals(string);
    }

    @Override
    public boolean isProcessIdentifierValueValid(@Nullable String string, @Nullable String string2) {
        return BDXR2IdentifierHelper.isValidIdentifierValue(string2);
    }

    @Override
    public @Nullable BDXR2ProcessIdentifier createProcessIdentifier(@Nullable String string, @Nullable String string2) {
        String string3 = this.nullNotEmpty(string);
        String string4 = this.nullNotEmpty(this.isProcessIdentifierCaseInsensitive(string3) ? this.getUnifiedValue(string2) : string2);
        if (this.isProcessIdentifierSchemeValid(string3) && this.isProcessIdentifierValueValid(string3, string4)) {
            return new BDXR2ProcessIdentifier(string3, string4);
        }
        return null;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

