/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.string.StringHelper;
import com.helger.peppolid.CIdentifier;
import java.io.Serializable;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@MustImplementEqualsAndHashcode
public interface IIdentifier
extends Serializable {
    public @NonNull String getScheme();

    default public boolean hasScheme() {
        return this.getScheme() != null;
    }

    default public boolean hasScheme(@Nullable String string) {
        return EqualsHelper.equals((Object)this.getScheme(), (Object)string);
    }

    public @NonNull String getValue();

    default public boolean hasValue() {
        return StringHelper.isNotEmpty((String)this.getValue());
    }

    default public boolean hasValue(@Nullable String string) {
        return EqualsHelper.equals((Object)this.getValue(), (Object)string);
    }

    @Nonempty
    default public @NonNull String getURIEncoded() {
        return CIdentifier.getURIEncoded(this);
    }

    default public @NonNull String getURIPercentEncoded() {
        return CIdentifier.getURIPercentEncoded(this);
    }
}

