/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.pidscheme;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.state.ETriState;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.peppol.pidscheme.EPredefinedParticipantIdentifierScheme;
import com.helger.peppolid.peppol.pidscheme.IPeppolParticipantIdentifierScheme;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public final class PeppolParticipantIdentifierSchemeManager {
    private static final ICommonsList<IPeppolParticipantIdentifierScheme> PI_SCHEMES = new CommonsArrayList();
    private static final PeppolParticipantIdentifierSchemeManager INSTANCE;

    private PeppolParticipantIdentifierSchemeManager() {
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public static ICommonsList<? extends IPeppolParticipantIdentifierScheme> getAllSchemes() {
        return (ICommonsList)PI_SCHEMES.getClone();
    }

    @Nullable
    public static IPeppolParticipantIdentifierScheme getSchemeOfISO6523Code(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string)) {
            for (IPeppolParticipantIdentifierScheme iPeppolParticipantIdentifierScheme : PI_SCHEMES) {
                if (!iPeppolParticipantIdentifierScheme.getISO6523Code().equalsIgnoreCase(string)) continue;
                return iPeppolParticipantIdentifierScheme;
            }
        }
        return null;
    }

    public static boolean containsSchemeWithISO6523Code(@Nullable String string) {
        return PeppolParticipantIdentifierSchemeManager.getSchemeOfISO6523Code(string) != null;
    }

    @Nullable
    public static String getSchemeIDOfISO6523Code(@Nullable String string) {
        IPeppolParticipantIdentifierScheme iPeppolParticipantIdentifierScheme = PeppolParticipantIdentifierSchemeManager.getSchemeOfISO6523Code(string);
        return iPeppolParticipantIdentifierScheme == null ? null : iPeppolParticipantIdentifierScheme.getSchemeID();
    }

    @Nullable
    public static IPeppolParticipantIdentifierScheme getSchemeOfSchemeID(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string)) {
            for (IPeppolParticipantIdentifierScheme iPeppolParticipantIdentifierScheme : PI_SCHEMES) {
                if (!iPeppolParticipantIdentifierScheme.getSchemeID().equalsIgnoreCase(string)) continue;
                return iPeppolParticipantIdentifierScheme;
            }
        }
        return null;
    }

    public static boolean containsSchemeWithSchemeID(@Nullable String string) {
        return PeppolParticipantIdentifierSchemeManager.getSchemeOfSchemeID(string) != null;
    }

    @Nullable
    public static String getISO6523CodeOfSchemeID(@Nullable String string) {
        IPeppolParticipantIdentifierScheme iPeppolParticipantIdentifierScheme = PeppolParticipantIdentifierSchemeManager.getSchemeOfSchemeID(string);
        return iPeppolParticipantIdentifierScheme == null ? null : iPeppolParticipantIdentifierScheme.getISO6523Code();
    }

    @Nonnull
    public static ETriState isSchemeWithISO6523CodeDeprecated(@Nullable String string) {
        IPeppolParticipantIdentifierScheme iPeppolParticipantIdentifierScheme = PeppolParticipantIdentifierSchemeManager.getSchemeOfISO6523Code(string);
        return iPeppolParticipantIdentifierScheme == null ? ETriState.UNDEFINED : ETriState.valueOf((boolean)iPeppolParticipantIdentifierScheme.isDeprecated());
    }

    @Nonnull
    public static ETriState isSchemeWithSchemeIDDeprecated(@Nullable String string) {
        IPeppolParticipantIdentifierScheme iPeppolParticipantIdentifierScheme = PeppolParticipantIdentifierSchemeManager.getSchemeOfSchemeID(string);
        return iPeppolParticipantIdentifierScheme == null ? ETriState.UNDEFINED : ETriState.valueOf((boolean)iPeppolParticipantIdentifierScheme.isDeprecated());
    }

    @Nullable
    public static IPeppolParticipantIdentifierScheme getSchemeOfIdentifier(@Nullable IParticipantIdentifier iParticipantIdentifier) {
        String string;
        if (iParticipantIdentifier != null && iParticipantIdentifier.hasScheme("iso6523-actorid-upis") && (string = iParticipantIdentifier.getValue()).length() > 5) {
            return PeppolParticipantIdentifierSchemeManager.getSchemeOfISO6523Code(string.substring(0, 4));
        }
        return null;
    }

    static {
        for (EPredefinedParticipantIdentifierScheme ePredefinedParticipantIdentifierScheme : EPredefinedParticipantIdentifierScheme.values()) {
            PI_SCHEMES.add((Object)ePredefinedParticipantIdentifierScheme);
        }
        INSTANCE = new PeppolParticipantIdentifierSchemeManager();
    }
}

