/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.participant;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.misc.DevelopersNote;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.compare.CompareHelper;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringParser;
import com.helger.peppolid.IMutableIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.peppolid.peppol.IPeppolIdentifier;
import com.helger.peppolid.peppol.validator.IdentifierValidator;
import com.helger.xsds.peppol.id1.ParticipantIdentifierType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;

@NotThreadSafe
public class PeppolParticipantIdentifier
extends ParticipantIdentifierType
implements IParticipantIdentifier,
IPeppolIdentifier,
IMutableIdentifier,
Comparable<PeppolParticipantIdentifier>,
ICloneable<PeppolParticipantIdentifier> {
    @Nonnull
    private static String _verifyScheme(@Nonnull IIdentifierFactory iIdentifierFactory, @Nullable String string) {
        if (!iIdentifierFactory.isParticipantIdentifierSchemeValid(string)) {
            throw new IllegalArgumentException("Peppol Participant identifier scheme '" + string + "' is invalid!");
        }
        return string;
    }

    @Nonnull
    private static String _verifyValue(@Nonnull IIdentifierFactory iIdentifierFactory, @Nullable String string, @Nonnull String string2) {
        if (!iIdentifierFactory.isParticipantIdentifierValueValid(string, string2)) {
            throw new IllegalArgumentException("Peppol Participant identifier value '" + string2 + "' is invalid for scheme '" + string + "'!");
        }
        return string2;
    }

    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public PeppolParticipantIdentifier(@Nonnull IIdentifierFactory iIdentifierFactory, @Nonnull IParticipantIdentifier iParticipantIdentifier) {
        this(iIdentifierFactory, iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue());
    }

    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public PeppolParticipantIdentifier(@Nonnull IIdentifierFactory iIdentifierFactory, @Nullable String string, @Nonnull String string2) {
        this(true, PeppolParticipantIdentifier._verifyScheme(iIdentifierFactory, string), PeppolParticipantIdentifier._verifyValue(iIdentifierFactory, string, string2));
    }

    protected PeppolParticipantIdentifier(boolean bl, @Nonnull String string, @Nonnull String string2) {
        this.setScheme(string);
        this.setValue(string2);
    }

    @Override
    public boolean hasDefaultScheme() {
        return this.hasScheme("iso6523-actorid-upis");
    }

    public boolean isSemanticallyValid() {
        return IdentifierValidator.isValidParticipantIdentifier(this);
    }

    @Nullable
    public String getIssuingAgencyID() {
        if (this.hasDefaultScheme()) {
            return (String)StringHelper.getExploded((char)':', (String)this.getValue(), (int)2).get(0);
        }
        return null;
    }

    @Nullable
    public String getLocalParticipantID() {
        if (this.hasDefaultScheme()) {
            List list = StringHelper.getExploded((char)':', (String)this.getValue(), (int)2);
            return list.size() >= 2 ? (String)list.get(1) : null;
        }
        return null;
    }

    @Override
    public int compareTo(@Nonnull PeppolParticipantIdentifier peppolParticipantIdentifier) {
        int n = CompareHelper.compare((Comparable)((Object)this.getScheme()), (Comparable)((Object)peppolParticipantIdentifier.getScheme()));
        if (n == 0) {
            n = CompareHelper.compare((Comparable)((Object)this.getValue()), (Comparable)((Object)peppolParticipantIdentifier.getValue()));
        }
        return n;
    }

    @Nonnull
    @ReturnsMutableCopy
    public PeppolParticipantIdentifier getClone() {
        return new PeppolParticipantIdentifier(true, this.getScheme(), this.getValue());
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Nonnull
    public static PeppolParticipantIdentifier internalCreatePreVerified(@Nullable String string, @Nullable String string2) {
        return new PeppolParticipantIdentifier(true, string, string2);
    }

    public static boolean isValidValueWithDefaultScheme(@Nonnull String string) {
        List list = StringHelper.getExploded((char)':', (String)string, (int)2);
        if (list.size() != 2) {
            return false;
        }
        String string2 = (String)list.get(0);
        if (string2.length() != 4 || !StringParser.isUnsignedInt((String)string2)) {
            return false;
        }
        String string3 = ((String)list.get(1)).trim();
        return string3.length() > 0;
    }
}

