/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.sml;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.builder.IBuilder;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.id.factory.GlobalIDFactory;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.type.ObjectType;
import com.helger.peppol.sml.ISMLInfo;
import java.net.MalformedURLException;
import java.net.URL;
import org.jspecify.annotations.NonNull;

@Immutable
public class SMLInfo
implements ISMLInfo,
ICloneable<SMLInfo> {
    public static final String DEFAULT_SUFFIX_MANAGE_SMP = "/manageservicemetadata";
    public static final String DEFAULT_SUFFIX_MANAGE_PARTICIPANT = "/manageparticipantidentifier";
    public static final boolean DEFAULT_CLIENT_CERTIFICATE_REQUIRED = true;
    public static final ObjectType OT = new ObjectType("sml.info");
    private final String m_sID;
    private final String m_sDisplayName;
    private final String m_sDNSZone;
    private final String m_sManagementServiceURL;
    private final String m_sURLSuffixManageSMP;
    private final String m_sURLSuffixManageParticipant;
    private final boolean m_bClientCertificateRequired;
    private final URL m_aManageServiceMetaDataEndpointAddress;
    private final URL m_aManageParticipantIdentifierEndpointAddress;

    @Deprecated(forRemoval=true, since="12.1.0")
    public SMLInfo(@NonNull ISMLInfo iSMLInfo) {
        this((String)iSMLInfo.getID(), iSMLInfo.getDisplayName(), iSMLInfo.getDNSZone(), iSMLInfo.getManagementServiceURL(), iSMLInfo.isClientCertificateRequired());
    }

    @Deprecated(forRemoval=true, since="12.1.0")
    public SMLInfo(@Nonempty @NonNull String string, @Nonempty @NonNull String string2, @Nonempty @NonNull String string3, boolean bl) {
        this(GlobalIDFactory.getNewPersistentStringID(), string, string2, string3, bl);
    }

    @Deprecated(forRemoval=true, since="12.1.0")
    public SMLInfo(@Nonempty @NonNull String string, @Nonempty @NonNull String string2, @Nonempty @NonNull String string3, @Nonempty @NonNull String string4, boolean bl) {
        this(string, string2, string3, string4, DEFAULT_SUFFIX_MANAGE_SMP, DEFAULT_SUFFIX_MANAGE_PARTICIPANT, bl);
    }

    protected SMLInfo(@Nonempty @NonNull String string, @Nonempty @NonNull String string2, @Nonempty @NonNull String string3, @Nonempty @NonNull String string4, @NonNull String string5, @NonNull String string6, boolean bl) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"DisplayName");
        ValueEnforcer.notEmpty((CharSequence)string3, (String)"DNSZone");
        ValueEnforcer.notEmpty((CharSequence)string4, (String)"ManagementServiceURL");
        ValueEnforcer.isFalse(() -> string4.endsWith("/"), (String)"ManagementServiceURL must not end with a slash");
        ValueEnforcer.notNull((Object)string5, (String)"URLSuffixManageSMP");
        ValueEnforcer.notNull((Object)string6, (String)"URLSuffixManageParticipant");
        this.m_sID = string;
        this.m_sDisplayName = string2;
        this.m_sDNSZone = string3;
        this.m_sManagementServiceURL = string4;
        this.m_sURLSuffixManageSMP = string5;
        this.m_sURLSuffixManageParticipant = string6;
        this.m_bClientCertificateRequired = bl;
        try {
            this.m_aManageServiceMetaDataEndpointAddress = new URL(this.m_sManagementServiceURL + this.m_sURLSuffixManageSMP);
            this.m_aManageParticipantIdentifierEndpointAddress = new URL(this.m_sManagementServiceURL + this.m_sURLSuffixManageParticipant);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Failed to convert to URL", malformedURLException);
        }
    }

    public @NonNull ObjectType getObjectType() {
        return OT;
    }

    @Nonempty
    public @NonNull String getID() {
        return this.m_sID;
    }

    @Override
    @Nonempty
    public @NonNull String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Override
    @Nonempty
    public @NonNull String getDNSZone() {
        return this.m_sDNSZone;
    }

    @Override
    @Nonempty
    public @NonNull String getManagementServiceURL() {
        return this.m_sManagementServiceURL;
    }

    @Override
    public @NonNull String getURLSuffixManageSMP() {
        return this.m_sURLSuffixManageSMP;
    }

    @Override
    public @NonNull URL getManageServiceMetaDataEndpointAddress() {
        return this.m_aManageServiceMetaDataEndpointAddress;
    }

    @Override
    public @NonNull String getURLSuffixManageParticipant() {
        return this.m_sURLSuffixManageParticipant;
    }

    @Override
    public @NonNull URL getManageParticipantIdentifierEndpointAddress() {
        return this.m_aManageParticipantIdentifierEndpointAddress;
    }

    @Override
    public boolean isClientCertificateRequired() {
        return this.m_bClientCertificateRequired;
    }

    @ReturnsMutableCopy
    public @NonNull SMLInfo getClone() {
        return SMLInfo.builder(this).build();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SMLInfo sMLInfo = (SMLInfo)object;
        return this.m_sID.equals(sMLInfo.m_sID) && this.m_sDisplayName.equals(sMLInfo.m_sDisplayName) && this.m_sDNSZone.equals(sMLInfo.m_sDNSZone) && this.m_sManagementServiceURL.equals(sMLInfo.m_sManagementServiceURL) && this.m_sURLSuffixManageSMP.equals(sMLInfo.m_sURLSuffixManageSMP) && this.m_sURLSuffixManageParticipant.equals(sMLInfo.m_sURLSuffixManageParticipant) && this.m_bClientCertificateRequired == sMLInfo.m_bClientCertificateRequired;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).append((Object)this.m_sDisplayName).append((Object)this.m_sDNSZone).append((Object)this.m_sManagementServiceURL).append((Object)this.m_sURLSuffixManageSMP).append((Object)this.m_sURLSuffixManageParticipant).append(this.m_bClientCertificateRequired).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("ID", (Object)this.m_sID).append("DisplayName", (Object)this.m_sDisplayName).append("DNSZone", (Object)this.m_sDNSZone).append("ManagementServiceURL", (Object)this.m_sManagementServiceURL).append("URLSuffixManageSMP", (Object)this.m_sURLSuffixManageSMP).append("URLSuffixManageParticipant", (Object)this.m_sURLSuffixManageParticipant).append("ClientCertificateRequired", this.m_bClientCertificateRequired).getToString();
    }

    public static @NonNull SMLInfoBuilder builder() {
        return new SMLInfoBuilder();
    }

    public static @NonNull SMLInfoBuilder builder(@NonNull ISMLInfo iSMLInfo) {
        return new SMLInfoBuilder(iSMLInfo);
    }

    public static boolean isValidURLSuffix(@NonNull String string) {
        return string.length() == 0 || string.length() > 1 && string.startsWith("/");
    }

    public static class SMLInfoBuilder
    implements IBuilder<SMLInfo> {
        private String m_sID;
        private String m_sDisplayName;
        private String m_sDNSZone;
        private String m_sManagementServiceURL;
        private String m_sURLSuffixManageSMP;
        private String m_sURLSuffixManageParticipant;
        private boolean m_bClientCertificateRequired;

        public SMLInfoBuilder() {
            this.urlSuffixManageSMP(SMLInfo.DEFAULT_SUFFIX_MANAGE_SMP);
            this.urlSuffixManageParticipant(SMLInfo.DEFAULT_SUFFIX_MANAGE_PARTICIPANT);
        }

        public SMLInfoBuilder(@NonNull ISMLInfo iSMLInfo) {
            ValueEnforcer.notNull((Object)iSMLInfo, (String)"SMLInfo");
            this.id((String)iSMLInfo.getID()).displayName(iSMLInfo.getDisplayName()).dnsZone(iSMLInfo.getDNSZone()).managementServiceURL(iSMLInfo.getManagementServiceURL()).urlSuffixManageSMP(iSMLInfo.getURLSuffixManageSMP()).urlSuffixManageParticipant(iSMLInfo.getURLSuffixManageParticipant()).clientCertificateRequired(iSMLInfo.isClientCertificateRequired());
        }

        public @NonNull SMLInfoBuilder idNew() {
            return this.id(GlobalIDFactory.getNewStringID());
        }

        public @NonNull SMLInfoBuilder idNewPersistent() {
            return this.id(GlobalIDFactory.getNewPersistentStringID());
        }

        public @NonNull SMLInfoBuilder id(@Nonempty @NonNull String string) {
            ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
            this.m_sID = string;
            return this;
        }

        public @NonNull SMLInfoBuilder displayName(@Nonempty @NonNull String string) {
            ValueEnforcer.notEmpty((CharSequence)string, (String)"DisplayName");
            this.m_sDisplayName = string;
            return this;
        }

        public @NonNull SMLInfoBuilder dnsZone(@Nonempty @NonNull String string) {
            ValueEnforcer.notEmpty((CharSequence)string, (String)"DNSZone");
            this.m_sDNSZone = string;
            return this;
        }

        public @NonNull SMLInfoBuilder managementServiceURL(@Nonempty @NonNull String string) {
            ValueEnforcer.notEmpty((CharSequence)string, (String)"ManagementServiceURL");
            this.m_sManagementServiceURL = StringHelper.trimEnd((String)string, (char)'/');
            return this;
        }

        public @NonNull SMLInfoBuilder urlSuffixManageSMP(@NonNull String string) {
            ValueEnforcer.notNull((Object)string, (String)"URLSuffixManageSMP");
            ValueEnforcer.isTrue(() -> SMLInfo.isValidURLSuffix(string), (String)"URLSuffixManageSMP");
            this.m_sURLSuffixManageSMP = string;
            return this;
        }

        public @NonNull SMLInfoBuilder urlSuffixManageParticipant(@NonNull String string) {
            ValueEnforcer.notNull((Object)string, (String)"URLSuffixManageParticipant");
            ValueEnforcer.isTrue(() -> SMLInfo.isValidURLSuffix(string), (String)"URLSuffixManageParticipant");
            this.m_sURLSuffixManageParticipant = string;
            return this;
        }

        public @NonNull SMLInfoBuilder clientCertificateRequired(boolean bl) {
            this.m_bClientCertificateRequired = bl;
            return this;
        }

        public @NonNull SMLInfo build() {
            if (StringHelper.isEmpty((String)this.m_sID)) {
                throw new IllegalStateException("The ID must be set");
            }
            if (StringHelper.isEmpty((String)this.m_sDisplayName)) {
                throw new IllegalStateException("The Display Name must be set");
            }
            if (StringHelper.isEmpty((String)this.m_sDNSZone)) {
                throw new IllegalStateException("The DNS Zone must be set");
            }
            if (StringHelper.isEmpty((String)this.m_sManagementServiceURL)) {
                throw new IllegalStateException("The Management Service URL must be set");
            }
            if (this.m_sURLSuffixManageSMP == null) {
                throw new IllegalStateException("The Manage SMP URL Suffix must be set");
            }
            if (this.m_sURLSuffixManageParticipant == null) {
                throw new IllegalStateException("The Manage Participant URL Suffix must be set");
            }
            return new SMLInfo(this.m_sID, this.m_sDisplayName, this.m_sDNSZone, this.m_sManagementServiceURL, this.m_sURLSuffixManageSMP, this.m_sURLSuffixManageParticipant, this.m_bClientCertificateRequired);
        }
    }
}

