/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.security;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.peppol.security.PeppolTrustStores;
import com.helger.security.certificate.TrustedCAChecker;
import jakarta.annotation.Nonnull;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PeppolTrustedCA {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeppolTrustedCA.class);
    private static final TrustedCAChecker TEST_AP = new TrustedCAChecker(new X509Certificate[]{PeppolTrustStores.Config2018.CERTIFICATE_PILOT_AP, PeppolTrustStores.Config2025.CERTIFICATE_TEST_AP});
    private static final TrustedCAChecker PROD_AP = new TrustedCAChecker(new X509Certificate[]{PeppolTrustStores.Config2018.CERTIFICATE_PRODUCTION_AP, PeppolTrustStores.Config2025.CERTIFICATE_PRODUCTION_AP});
    private static final TrustedCAChecker ALL_AP = new TrustedCAChecker(new X509Certificate[]{PeppolTrustStores.Config2018.CERTIFICATE_PILOT_AP, PeppolTrustStores.Config2025.CERTIFICATE_TEST_AP, PeppolTrustStores.Config2018.CERTIFICATE_PRODUCTION_AP, PeppolTrustStores.Config2025.CERTIFICATE_PRODUCTION_AP});
    private static final TrustedCAChecker TEST_SMP = new TrustedCAChecker(new X509Certificate[]{PeppolTrustStores.Config2018.CERTIFICATE_PILOT_SMP, PeppolTrustStores.Config2025.CERTIFICATE_TEST_SMP});
    private static final TrustedCAChecker PROD_SMP = new TrustedCAChecker(new X509Certificate[]{PeppolTrustStores.Config2018.CERTIFICATE_PRODUCTION_SMP, PeppolTrustStores.Config2025.CERTIFICATE_PRODUCTION_SMP});
    private static final TrustedCAChecker ALL_SMP = new TrustedCAChecker(new X509Certificate[]{PeppolTrustStores.Config2018.CERTIFICATE_PILOT_SMP, PeppolTrustStores.Config2025.CERTIFICATE_TEST_SMP, PeppolTrustStores.Config2018.CERTIFICATE_PRODUCTION_SMP, PeppolTrustStores.Config2025.CERTIFICATE_PRODUCTION_SMP});

    private PeppolTrustedCA() {
    }

    @Nonnull
    public static TrustedCAChecker peppolTestAP() {
        return TEST_AP;
    }

    @Nonnull
    public static TrustedCAChecker peppolProductionAP() {
        return PROD_AP;
    }

    @Nonnull
    public static TrustedCAChecker peppolAllAP() {
        return ALL_AP;
    }

    @Nonnull
    public static TrustedCAChecker peppolTestSMP() {
        return TEST_SMP;
    }

    @Nonnull
    public static TrustedCAChecker peppolProductionSMP() {
        return PROD_SMP;
    }

    @Nonnull
    public static TrustedCAChecker peppolAllSMP() {
        return ALL_SMP;
    }

    public static void clearRevocationCheckCache() {
        TEST_AP.getRevocationCache().clearCache();
        PROD_AP.getRevocationCache().clearCache();
        ALL_AP.getRevocationCache().clearCache();
        TEST_SMP.getRevocationCache().clearCache();
        PROD_SMP.getRevocationCache().clearCache();
        ALL_SMP.getRevocationCache().clearCache();
        LOGGER.info("The PeppolCertificateChecker revocation cache was cleared");
    }
}

