/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.security;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.security.keystore.EKeyStoreType;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.ITrustStoreDescriptor;
import com.helger.security.keystore.TrustStoreDescriptor;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PeppolTrustStores {
    public static final String TRUSTSTORE_PASSWORD = "peppol";
    private static final Logger LOGGER = LoggerFactory.getLogger(PeppolTrustStores.class);
    private static final PeppolTrustStores INSTANCE = new PeppolTrustStores();

    @Nullable
    private static X509Certificate _resolveCert(@Nonnull KeyStore keyStore, @Nonnull @Nonempty String string) {
        try {
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            if (x509Certificate == null) {
                LOGGER.warn("Failed to resolve alias '" + string + "' in trust store");
            }
            return x509Certificate;
        }
        catch (KeyStoreException keyStoreException) {
            LOGGER.warn("Failed to resolve alias '" + string + "' in trust store.", (Throwable)keyStoreException);
            return null;
        }
    }

    private PeppolTrustStores() {
    }

    @Immutable
    public static class Config2025 {
        public static final EKeyStoreType TRUSTSTORE_TYPE = EKeyStoreType.PKCS12;
        public static final String TRUSTSTORE_AP_PRODUCTION_CLASSPATH = "truststore/2025/ap-prod-truststore.p12";
        public static final ITrustStoreDescriptor TRUSTSTORE_DESCRIPTOR_AP_PRODUCTION = TrustStoreDescriptor.builder().type((IKeyStoreType)TRUSTSTORE_TYPE).path("truststore/2025/ap-prod-truststore.p12").password("peppol").build();
        public static final KeyStore TRUSTSTORE_AP_PRODUCTION = TRUSTSTORE_DESCRIPTOR_AP_PRODUCTION.loadTrustStore().getKeyStore();
        public static final String TRUSTSTORE_SMP_PRODUCTION_CLASSPATH = "truststore/2025/smp-prod-truststore.p12";
        public static final ITrustStoreDescriptor TRUSTSTORE_DESCRIPTOR_SMP_PRODUCTION;
        public static final KeyStore TRUSTSTORE_SMP_PRODUCTION;
        public static final String TRUSTSTORE_PRODUCTION_ALIAS_ROOT = "peppol root ca - g3";
        public static final X509Certificate CERTIFICATE_PRODUCTION_ROOT;
        public static final String TRUSTSTORE_PRODUCTION_ALIAS_AP = "peppol access point ca - g3 (peppol root ca - g3)";
        public static final X509Certificate CERTIFICATE_PRODUCTION_AP;
        public static final String TRUSTSTORE_PRODUCTION_ALIAS_SMP = "peppol service metadata publisher ca - g3 (peppol root ca - g3)";
        public static final X509Certificate CERTIFICATE_PRODUCTION_SMP;
        public static final String TRUSTSTORE_AP_TEST_CLASSPATH = "truststore/2025/ap-test-truststore.p12";
        public static final ITrustStoreDescriptor TRUSTSTORE_DESCRIPTOR_AP_TEST;
        public static final KeyStore TRUSTSTORE_AP_TEST;
        public static final String TRUSTSTORE_SMP_TEST_CLASSPATH = "truststore/2025/smp-test-truststore.p12";
        public static final ITrustStoreDescriptor TRUSTSTORE_DESCRIPTOR_SMP_TEST;
        public static final KeyStore TRUSTSTORE_SMP_TEST;
        public static final String TRUSTSTORE_TEST_ALIAS_ROOT = "peppol root test ca - g3";
        public static final X509Certificate CERTIFICATE_TEST_ROOT;
        public static final String TRUSTSTORE_TEST_ALIAS_AP = "peppol access point test ca - g3 (peppol root test ca - g3)";
        public static final X509Certificate CERTIFICATE_TEST_AP;
        public static final String TRUSTSTORE_TEST_ALIAS_SMP = "peppol service metadata publisher test ca - g3 (peppol root test ca - g3)";
        public static final X509Certificate CERTIFICATE_TEST_SMP;

        protected Config2025() {
        }

        static {
            if (TRUSTSTORE_AP_PRODUCTION == null) {
                throw new IllegalStateException("Failed to load pre-configured production AP trust store");
            }
            TRUSTSTORE_DESCRIPTOR_SMP_PRODUCTION = TrustStoreDescriptor.builder().type((IKeyStoreType)TRUSTSTORE_TYPE).path(TRUSTSTORE_SMP_PRODUCTION_CLASSPATH).password(PeppolTrustStores.TRUSTSTORE_PASSWORD).build();
            TRUSTSTORE_SMP_PRODUCTION = TRUSTSTORE_DESCRIPTOR_SMP_PRODUCTION.loadTrustStore().getKeyStore();
            if (TRUSTSTORE_SMP_PRODUCTION == null) {
                throw new IllegalStateException("Failed to load pre-configured SMP production trust store");
            }
            CERTIFICATE_PRODUCTION_ROOT = PeppolTrustStores._resolveCert(TRUSTSTORE_AP_PRODUCTION, TRUSTSTORE_PRODUCTION_ALIAS_ROOT);
            CERTIFICATE_PRODUCTION_AP = PeppolTrustStores._resolveCert(TRUSTSTORE_AP_PRODUCTION, TRUSTSTORE_PRODUCTION_ALIAS_AP);
            CERTIFICATE_PRODUCTION_SMP = PeppolTrustStores._resolveCert(TRUSTSTORE_AP_PRODUCTION, TRUSTSTORE_PRODUCTION_ALIAS_SMP);
            TRUSTSTORE_DESCRIPTOR_AP_TEST = TrustStoreDescriptor.builder().type((IKeyStoreType)TRUSTSTORE_TYPE).path(TRUSTSTORE_AP_TEST_CLASSPATH).password(PeppolTrustStores.TRUSTSTORE_PASSWORD).build();
            TRUSTSTORE_AP_TEST = TRUSTSTORE_DESCRIPTOR_AP_TEST.loadTrustStore().getKeyStore();
            if (TRUSTSTORE_AP_TEST == null) {
                throw new IllegalStateException("Failed to load pre-configured AP test trust store");
            }
            TRUSTSTORE_DESCRIPTOR_SMP_TEST = TrustStoreDescriptor.builder().type((IKeyStoreType)TRUSTSTORE_TYPE).path(TRUSTSTORE_SMP_TEST_CLASSPATH).password(PeppolTrustStores.TRUSTSTORE_PASSWORD).build();
            TRUSTSTORE_SMP_TEST = TRUSTSTORE_DESCRIPTOR_SMP_TEST.loadTrustStore().getKeyStore();
            if (TRUSTSTORE_SMP_TEST == null) {
                throw new IllegalStateException("Failed to load pre-configured SMP test trust store");
            }
            CERTIFICATE_TEST_ROOT = PeppolTrustStores._resolveCert(TRUSTSTORE_AP_TEST, TRUSTSTORE_TEST_ALIAS_ROOT);
            CERTIFICATE_TEST_AP = PeppolTrustStores._resolveCert(TRUSTSTORE_AP_TEST, TRUSTSTORE_TEST_ALIAS_AP);
            CERTIFICATE_TEST_SMP = PeppolTrustStores._resolveCert(TRUSTSTORE_AP_TEST, TRUSTSTORE_TEST_ALIAS_SMP);
        }
    }

    @Immutable
    public static class Config2018 {
        public static final EKeyStoreType TRUSTSTORE_TYPE = EKeyStoreType.JKS;
        public static final String TRUSTSTORE_AP_PRODUCTION_CLASSPATH = "truststore/2018/prod-truststore.jks";
        public static final ITrustStoreDescriptor TRUSTSTORE_DESCRIPTOR_AP_PRODUCTION = TrustStoreDescriptor.builder().type((IKeyStoreType)TRUSTSTORE_TYPE).path("truststore/2018/prod-truststore.jks").password("peppol").build();
        public static final KeyStore TRUSTSTORE_AP_PRODUCTION = TRUSTSTORE_DESCRIPTOR_AP_PRODUCTION.loadTrustStore().getKeyStore();
        public static final String TRUSTSTORE_SMP_PRODUCTION_CLASSPATH = "truststore/2018/smp-prod-truststore.jks";
        public static final ITrustStoreDescriptor TRUSTSTORE_DESCRIPTOR_SMP_PRODUCTION;
        public static final KeyStore TRUSTSTORE_SMP_PRODUCTION;
        public static final String TRUSTSTORE_PRODUCTION_ALIAS_ROOT = "peppol root ca - g2";
        public static final X509Certificate CERTIFICATE_PRODUCTION_ROOT;
        public static final String TRUSTSTORE_PRODUCTION_ALIAS_AP = "peppol access point ca - g2 (peppol root ca - g2)";
        public static final X509Certificate CERTIFICATE_PRODUCTION_AP;
        public static final String TRUSTSTORE_PRODUCTION_ALIAS_SMP = "peppol service metadata publisher ca - g2 (peppol root ca - g2)";
        public static final X509Certificate CERTIFICATE_PRODUCTION_SMP;
        public static final String TRUSTSTORE_AP_PILOT_CLASSPATH = "truststore/2018/pilot-truststore.jks";
        public static final ITrustStoreDescriptor TRUSTSTORE_DESCRIPTOR_AP_PILOT;
        public static final KeyStore TRUSTSTORE_AP_PILOT;
        public static final String TRUSTSTORE_SMP_PILOT_CLASSPATH = "truststore/2018/smp-pilot-truststore.jks";
        public static final ITrustStoreDescriptor TRUSTSTORE_DESCRIPTOR_SMP_PILOT;
        public static final KeyStore TRUSTSTORE_SMP_PILOT;
        public static final String TRUSTSTORE_PILOT_ALIAS_ROOT = "peppol root test ca - g2";
        public static final X509Certificate CERTIFICATE_PILOT_ROOT;
        public static final String TRUSTSTORE_PILOT_ALIAS_AP = "peppol access point test ca - g2 (peppol root test ca - g2)";
        public static final X509Certificate CERTIFICATE_PILOT_AP;
        public static final String TRUSTSTORE_PILOT_ALIAS_SMP = "peppol service metadata publisher test ca - g2 (peppol root test ca - g2)";
        public static final X509Certificate CERTIFICATE_PILOT_SMP;

        protected Config2018() {
        }

        static {
            if (TRUSTSTORE_AP_PRODUCTION == null) {
                throw new IllegalStateException("Failed to load pre-configured production AP trust store");
            }
            TRUSTSTORE_DESCRIPTOR_SMP_PRODUCTION = TrustStoreDescriptor.builder().type((IKeyStoreType)TRUSTSTORE_TYPE).path(TRUSTSTORE_SMP_PRODUCTION_CLASSPATH).password(PeppolTrustStores.TRUSTSTORE_PASSWORD).build();
            TRUSTSTORE_SMP_PRODUCTION = TRUSTSTORE_DESCRIPTOR_SMP_PRODUCTION.loadTrustStore().getKeyStore();
            if (TRUSTSTORE_SMP_PRODUCTION == null) {
                throw new IllegalStateException("Failed to load pre-configured SMP production trust store");
            }
            CERTIFICATE_PRODUCTION_ROOT = PeppolTrustStores._resolveCert(TRUSTSTORE_AP_PRODUCTION, TRUSTSTORE_PRODUCTION_ALIAS_ROOT);
            CERTIFICATE_PRODUCTION_AP = PeppolTrustStores._resolveCert(TRUSTSTORE_AP_PRODUCTION, TRUSTSTORE_PRODUCTION_ALIAS_AP);
            CERTIFICATE_PRODUCTION_SMP = PeppolTrustStores._resolveCert(TRUSTSTORE_AP_PRODUCTION, TRUSTSTORE_PRODUCTION_ALIAS_SMP);
            TRUSTSTORE_DESCRIPTOR_AP_PILOT = TrustStoreDescriptor.builder().type((IKeyStoreType)TRUSTSTORE_TYPE).path(TRUSTSTORE_AP_PILOT_CLASSPATH).password(PeppolTrustStores.TRUSTSTORE_PASSWORD).build();
            TRUSTSTORE_AP_PILOT = TRUSTSTORE_DESCRIPTOR_AP_PILOT.loadTrustStore().getKeyStore();
            if (TRUSTSTORE_AP_PILOT == null) {
                throw new IllegalStateException("Failed to load pre-configured AP pilot trust store");
            }
            TRUSTSTORE_DESCRIPTOR_SMP_PILOT = TrustStoreDescriptor.builder().type((IKeyStoreType)TRUSTSTORE_TYPE).path(TRUSTSTORE_SMP_PILOT_CLASSPATH).password(PeppolTrustStores.TRUSTSTORE_PASSWORD).build();
            TRUSTSTORE_SMP_PILOT = TRUSTSTORE_DESCRIPTOR_SMP_PILOT.loadTrustStore().getKeyStore();
            if (TRUSTSTORE_SMP_PILOT == null) {
                throw new IllegalStateException("Failed to load pre-configured SMP pilot trust store");
            }
            CERTIFICATE_PILOT_ROOT = PeppolTrustStores._resolveCert(TRUSTSTORE_AP_PILOT, TRUSTSTORE_PILOT_ALIAS_ROOT);
            CERTIFICATE_PILOT_AP = PeppolTrustStores._resolveCert(TRUSTSTORE_AP_PILOT, TRUSTSTORE_PILOT_ALIAS_AP);
            CERTIFICATE_PILOT_SMP = PeppolTrustStores._resolveCert(TRUSTSTORE_AP_PILOT, TRUSTSTORE_PILOT_ALIAS_SMP);
        }
    }
}

