/*
 * Decompiled with CFR 0.152.
 */
package com.helger.maven.jscompress;

import com.google.javascript.jscomp.ClosureRunner;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public final class JSCompressMojo
extends AbstractMojo {
    private static final String EXTENSION_JS = ".js";
    private static final String[] EXTENSIONS_JS_COMPRESSED = new String[]{".min.js", "-min.js", ".minified.js", "-minified.js"};
    private MavenProject project;
    private File sourceDirectory;
    private boolean recursive = true;
    private String sourceEncoding = "UTF-8";
    private String targetFileExtension = ".min.js";
    private boolean forceCreation = false;

    public void setProject(MavenProject mavenProject) {
        this.project = mavenProject;
    }

    public void setSourceDirectory(File file) {
        this.sourceDirectory = file;
        if (!this.sourceDirectory.isAbsolute()) {
            this.sourceDirectory = new File(this.project.getBasedir(), file.getPath());
        }
        if (!this.sourceDirectory.exists()) {
            this.getLog().error((CharSequence)("JS source directory '" + String.valueOf(this.sourceDirectory) + "' does not exist!"));
        }
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    public void setSourceEncoding(String string) {
        this.sourceEncoding = string;
    }

    public void setTargetFileExtension(String string) {
        this.targetFileExtension = string;
    }

    public void setForceCreation(boolean bl) {
        this.forceCreation = bl;
    }

    private static boolean _isAlreadyCompressed(String string) {
        for (String string2 : EXTENSIONS_JS_COMPRESSED) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getWithoutExtension(@Nullable String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        int n2 = Math.max(string.lastIndexOf(47), string.lastIndexOf(92));
        int n3 = n2 > n ? -1 : n;
        return n3 == -1 ? string : string.substring(0, n3);
    }

    private void _compressJSFile(@Nonnull File file, @Nonnull ClosureRunner closureRunner) {
        File file2 = new File(JSCompressMojo.getWithoutExtension(file.getAbsolutePath()) + this.targetFileExtension);
        if (this.forceCreation || file2.lastModified() < file.lastModified()) {
            this.getLog().debug((CharSequence)("Start " + (this.forceCreation ? "forced " : "") + "compressing JS file " + file.toString()));
            closureRunner.compressJSFile(file, file2, new File[0]);
        } else {
            this.getLog().debug((CharSequence)("Ignoring already compressed JS file " + file.toString()));
        }
    }

    private void _scanDirectory(@Nonnull File file, @Nonnull ClosureRunner closureRunner) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    if (!this.recursive) continue;
                    this._scanDirectory(file2, closureRunner);
                    continue;
                }
                if (!file2.isFile() || !file2.getName().endsWith(EXTENSION_JS) || JSCompressMojo._isAlreadyCompressed(file2.getName())) continue;
                this._compressJSFile(file2, closureRunner);
            }
        }
    }

    public void execute() throws MojoExecutionException {
        ClosureRunner closureRunner = new ClosureRunner(this.getLog(), this.sourceEncoding);
        this._scanDirectory(this.sourceDirectory, closureRunner);
    }
}

