/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCommandLineRunner;
import com.google.javascript.jscomp.AllowlistWarningsGuard;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CodingConventions;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.FlagUsageException;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.WarningLevel;
import com.google.javascript.jscomp.WarningsGuard;
import com.google.javascript.jscomp.deps.ClosureBundler;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.jscomp.transpile.BaseTranspiler;
import com.google.javascript.jscomp.transpile.Transpiler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.logging.Log;

public final class ClosureRunner
extends AbstractCommandLineRunner<Compiler, CompilerOptions> {
    private static final boolean DEBUG = false;
    private static final boolean GENERATE_EXPORTS = false;
    private final Log m_aLog;
    private final String m_sCharset;
    private ClosureBundler m_aBundler;

    public ClosureRunner(@Nonnull Log log, @Nonnull String string) {
        if (log == null) {
            throw new NullPointerException("log");
        }
        if (string == null) {
            throw new NullPointerException("charset");
        }
        this.m_aLog = log;
        this.m_sCharset = string;
    }

    protected void addAllowlistWarningsGuard(@Nonnull CompilerOptions compilerOptions, @Nonnull File file) {
        compilerOptions.addWarningsGuard((WarningsGuard)AllowlistWarningsGuard.fromFile((File)file));
    }

    protected Compiler createCompiler() {
        return new Compiler(System.err);
    }

    protected List<SourceFile> createExterns(CompilerOptions compilerOptions) throws FlagUsageException, IOException {
        List list = super.createExterns(compilerOptions);
        List list2 = AbstractCommandLineRunner.getBuiltinExterns((CompilerOptions.Environment)compilerOptions.getEnvironment());
        list2.addAll(list);
        return list2;
    }

    protected CompilerOptions createOptions() {
        CompilerOptions.LanguageMode languageMode = CompilerOptions.LanguageMode.ECMASCRIPT_2021;
        CompilerOptions compilerOptions = new CompilerOptions();
        compilerOptions.setCodingConvention((CodingConvention)new ClosureCodingConvention());
        compilerOptions.setLanguageIn(languageMode);
        compilerOptions.setLanguageOut(languageMode);
        CompilationLevel compilationLevel = CompilationLevel.SIMPLE_OPTIMIZATIONS;
        compilationLevel.setOptionsForCompilationLevel(compilerOptions);
        WarningLevel.QUIET.setOptionsForWarningLevel(compilerOptions);
        compilerOptions.setPrettyPrint(false);
        compilerOptions.setPrintInputDelimiter(false);
        compilerOptions.setClosurePass(false);
        return compilerOptions;
    }

    private void _setDefaultConfig() {
        this.getCommandLineConfig().setPrintTree(false).setPrintAst(false).setJscompDevMode(CompilerOptions.DevMode.OFF).setLoggingLevel(Level.WARNING.getName()).setExterns(Collections.emptyList()).setJsOutputFile("").setJsonStreamMode(CompilerOptions.JsonStreamMode.NONE).setModule(Collections.emptyList()).setVariableMapInputFile("").setPropertyMapInputFile("").setVariableMapOutputFile("").setCreateNameMapFiles(false).setPropertyMapOutputFile("").setCodingConvention(CodingConventions.getDefault()).setSummaryDetailLevel(1).setOutputWrapper("").setModuleWrapper(Collections.emptyList()).setModuleOutputPathPrefix("./").setCreateSourceMap("").setDefine(Collections.emptyList()).setCharset(this.m_sCharset).setOutputManifest(Collections.emptyList());
    }

    public boolean compressJSFile(@Nonnull File file, @Nonnull File file2, @Nonnull File[] fileArray) {
        if (file == null) {
            throw new NullPointerException("sourceFile");
        }
        try {
            this.m_aLog.info((CharSequence)("Compressing JS " + file.getName() + " to " + file2.getName()));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (File file3 : fileArray) {
                arrayList.add(file3.getAbsolutePath());
            }
            this._setDefaultConfig();
            ArrayList arrayList2 = new ArrayList();
            arrayList2.add(new AbstractCommandLineRunner.FlagEntry((Object)AbstractCommandLineRunner.JsSourceType.JS, file.getAbsolutePath()));
            this.getCommandLineConfig().setExterns(arrayList).setMixedJsSources((List)arrayList2).setJsOutputFile(file2.getAbsolutePath());
            int n = this.doRun();
            if (n == 0) {
                return true;
            }
            this.m_aLog.error((CharSequence)("Failed to compress JS with " + n + " errors: " + file.getName()));
        }
        catch (Exception exception) {
            this.m_aLog.error((CharSequence)("Failed to compress JS " + file.toString()), (Throwable)exception);
        }
        return false;
    }

    @Nonnull
    private ClosureBundler _getBundler() {
        if (this.m_aBundler == null) {
            ImmutableList immutableList = ImmutableList.of((Object)"./");
            CompilerOptions compilerOptions = this.createOptions();
            FeatureSet featureSet = CompilerOptions.LanguageMode.ECMASCRIPT_NEXT.toFeatureSet().without(FeatureSet.Feature.MODULES, new FeatureSet.Feature[0]);
            ModuleLoader.ResolutionMode resolutionMode = compilerOptions.getModuleResolutionMode();
            ImmutableMap immutableMap = compilerOptions.getBrowserResolverPrefixReplacements();
            this.m_aBundler = new ClosureBundler(Transpiler.NULL, (Transpiler)new BaseTranspiler(new BaseTranspiler.CompilerSupplier(featureSet, resolutionMode, immutableList, immutableMap), ""));
        }
        return this.m_aBundler;
    }

    protected void prepForBundleAndAppendTo(Appendable appendable, CompilerInput compilerInput, String string) throws IOException {
        this._getBundler().withPath(compilerInput.getName()).appendTo(appendable, (DependencyInfo)compilerInput, string);
    }

    protected void appendRuntimeTo(Appendable appendable) throws IOException {
        this._getBundler().appendRuntimeTo(appendable);
    }

    protected String getVersionText() {
        return "ph-jscompress-maven-plugin based on Google Closure Compiler";
    }
}

